/*
 * Copyright (C) 2015 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __XML_SCHEM_H_INCLUDED
#define __XML_SCHEM_H_INCLUDED

struct xml_schem_name {
	struct xml_schem_name *prev;
	struct xml_schem_name *next;

	const char *name;
};

struct xml_schem_ge {
	struct xml_schem_ge *prev;
	struct xml_schem_ge *next;

	enum {
		GE_LINE,
		GE_BOX,
		GE_CIRCLE,
		GE_TEXT,
	} type;
	union {
		struct {
			double x0;
			double y0;
			double x1;
			double y1;
		} line;
		struct {
			double x0;
			double y0;
			double x1;
			double y1;
		} box;
		struct {
			double x;
			double y;
			double r;
		} circle;
		struct {
			const char *str;
			double x;
			double y;
			unsigned int align;
			unsigned int angle;
		} text;
	};
};

struct xml_schem_generic {
	struct xml_schem_generic *prev;
	struct xml_schem_generic *next;

	const char *seq;
	const char *name;
	const char *type;
	const char *value;
	struct xml_schem_ge *ge_first;
	struct xml_schem_ge *ge_last;
};
struct xml_schem_port {
	struct xml_schem_port *prev;
	struct xml_schem_port *next;

	const char *seq;
	const char *name;
	const char *signal;
	const char *inout;
	struct xml_schem_ge *ge_first;
	struct xml_schem_ge *ge_last;
};
struct xml_schem_signal {
	struct xml_schem_signal *prev;
	struct xml_schem_signal *next;

	const char *id;
	const char *type;
	struct xml_schem_name *name_first;
	struct xml_schem_name *name_last;
	struct xml_schem_ge *ge_first;
	struct xml_schem_ge *ge_last;
};
struct xml_schem_component {
	struct xml_schem_component *prev;
	struct xml_schem_component *next;

	const char *name;
	const char *type;
	struct xml_schem_generic *gen_first;
	struct xml_schem_generic *gen_last;
	struct xml_schem_port *port_first;
	struct xml_schem_port *port_last;
	struct xml_schem_ge *ge_first;
	struct xml_schem_ge *ge_last;
};
struct xml_schem {
	struct xml_schem_generic *gen_first;
	struct xml_schem_generic *gen_last;
	struct xml_schem_port *port_first;
	struct xml_schem_port *port_last;
	struct xml_schem_signal *sig_first;
	struct xml_schem_signal *sig_last;
	struct xml_schem_component *comp_first;
	struct xml_schem_component *comp_last;
};

extern void
xml_schem_component_bbox(
	struct xml_schem_component *comp,
	double *minxp,
	double *minyp,
	double *maxxp,
	double *maxyp
);

extern void
xml_schem_bbox(
	struct xml_schem *schem,
	double *minxp,
	double *minyp,
	double *maxxp,
	double *maxyp
);

extern void
xml_schem_translate(struct xml_schem *schem, double dx, double dy);

extern struct xml_schem *
xml_schem_read(FILE *fp);

extern int
xml_schem_write(FILE *fp, struct xml_schem *schem);

#endif /* __XML_SCHEM_H_INCLUDED */
