.\" Copyright (c) 1993, 2003 Free Software Foundation, Inc.
.\" See section COPYING for conditions for redistribution
.TH gen-index 8 "August 2003" "GNATS @VERSION@" "GNATS Administration Utilities"
.de BP
.sp
.ti -.2i
\(**
..
.SH NAME
gen-index \- generate new GNATS database index
.SH SYNOPSIS
.hy 0
.na
.B gen\-index
.RS
[
.B -n
|
.B --numeric
]
[
.B -h
|
.B --help
]
.br
[
.B -o
.I outfile
|
.BI --outfile= outfile
]
.br
[
.B -i
|
.B --import
]
[
.B -e
|
.B --export
]
.br
[
.B -d
.I databasename
|
.BI --database= databasename
]
.br
[
.B -V
|
.B --version
]
.ad b
.hy 1
.SH DESCRIPTION
Builds an index for the specified GNATS database. The index is printed
to standard output by default.
.SH OPTIONS
.TP 0.5i
.B -n, --numeric
Sorts index entries numerically rather than by their order in the
categories list.
.TP
.B -d \fIdatabasename\fB, --database=\fIdatabasename\fR
Specifies the database to be indexed.  If no database is specified,
the database named \fIdefault\fR is assumed.  This option overrides
the database specified in the \fBGNATSDB\fR environment variable.
.TP
.B -o \fIoutfile\fB, --outfile=\fIoutfile\fR
Prints the index to 
.I outfile
rather than to the standard output.
.TP
.B -i, --import
Import the existing index file instead of re-indexing the database.
.TP
.B -e, --export
Force plaintext output
.TP
.B -h, --help
Prints usage for 
.BR gen\-index .
.TP
.B -V, --version
Prints the version number of
.BR gen\-index .
.SH ENVIRONMENT VARIABLES
The \fBGNATSDB\fR environment variable is used to determine which database to
use.  For a local database, it contains the name of the database to access.
.P
For network access via \fIgnatsd\fR, it contains a colon-separated list
of strings that describe the remote database, in the form
.TP
\fIserver\fR:\fIport\fR:\fIdatabasename\fR:\fIusername\fR:\fIpassword\fR
.P
Any of the fields may be omitted, but at least one colon must appear;
otherwise, the value is assumed to be the name of a local database.
.P
If \fBGNATSDB\fR is not set, it is assumed that the database is local
and that its name is \fIdefault\fR.
.SH "SEE ALSO"
.I Keeping Track: Managing Messages With GNATS
(also installed as the GNU Info file
.BR gnats.info )
and
.I Reporting Problems Using send-pr
(also installed as the GNU Info file
.BR send-pr.info ).
.LP
.BR databases (5),
.BR dbconfig (5),
.BR delete-pr (8),
.BR edit-pr (1)
.BR file-pr (8),
.BR gen-index (8),
.BR gnats (7),
.BR gnatsd (8),
.BR mkcat (8),
.BR mkdb (8),
.BR pr-edit (8),
.BR query-pr (1),
.BR queue-pr (8),
.BR send-pr (1).
.SH COPYING
Copyright (c) 1993 Free Software Foundation, Inc.
.PP
Permission is granted to make and distribute verbatim copies of
this manual provided the copyright notice and this permission notice
are preserved on all copies.
.PP
Permission is granted to copy and distribute modified versions of this
manual under the conditions for verbatim copying, provided that the
entire resulting derived work is distributed under the terms of a
permission notice identical to this one.
.PP
Permission is granted to copy and distribute translations of this
manual into another language, under the above conditions for modified
versions, except that this permission notice may be included in
translations approved by the Free Software Foundation instead of in
the original English.
