#!/usr/bin/env python
"""
Runs the gnatcoll testsuite through the unittesting framework in python,
and add support for reporting events to GAIA.

You can specify the names of one or more testsuites to execute directly on
the command line, for instance
    xref  json.Test.test_json1
Do not forget the name of the test class

"""

import support
import os
import sys
import unittest

os.environ["PATH"] = \
    os.path.join(os.getcwd(), "..", "local_install", "lib") \
    + support.pathsep \
    + os.path.join(os.getcwd(), "..", "local_install", "bin") \
    + support.pathsep + os.getenv("PATH", "")

os.environ["GPR_PROJECT_PATH"] = \
    os.path.join(os.getcwd(), "..", "local_install", "lib", "gnat") + \
    support.pathsep + \
    os.path.join(os.getcwd(), "..", "src") + \
    support.pathsep + \
    os.getenv("GPR_PROJECT_PATH", "")

os.environ["LD_LIBRARY_PATH"] = \
    os.path.join(os.getcwd(), "..", "local_install", "lib") + \
    support.pathsep + \
    os.getenv("LD_LIBRARY_PATH", "")

testnames = set()
suites = unittest.TestSuite()
loader = unittest.TestLoader()

support.verbosity = 0
for v in sys.argv[1:]:
    if v == "-v":
        support.verbosity += 1
    else:
        testnames.add(v)

all_testsuites = set([
    'iconv', 'readline', 'config', 'traces', 'scripts', 'mmap_tests',
    'email', 'paragraph_filling', 'geometry', 'templates',
    'vfs', 'tribools', 'refcount', 'pools', 'storage_pools',
    'sql', 'projects', 'xref', 'json', 'utils'

    # Disable ravenscar tests, not reliable (H329-004)
    # Disable GMP tests, we get undefined symbols on saumur (IA23-022)
])

if testnames:
    n = [n.split(".")[0] for n in testnames]
    all_testsuites.intersection_update(n)

for s in sorted(all_testsuites):
    __import__(s)
    m = sys.modules[s]

    if not testnames or s in testnames:
        suite = loader.loadTestsFromModule(m)  # No filtering
    else:
        names = [n.split(".", 1)[1] for n in testnames
                 if n.startswith(s + ".")]
        suite = loader.loadTestsFromNames(names=names, module=m)
    suites.addTest(suite)

runner = support.GNATCOLL_TestRunner(
    verbosity=support.verbosity, stream=sys.stderr)
runner.separator2 = None
runner.run(suites)
