/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/


#ifndef MacroParamEditor_H
#include "MacroParamEditor.h"
#endif

#ifndef EditorFactory_H
#include "EditorFactory.h"
#endif

#ifndef IconObject_H
#include "IconObject.h"
#endif

#ifndef IconFactory_H
#include "IconFactory.h"
#endif

#ifndef RequestPanel_H
#include "RequestPanel.h"
#endif

#ifndef Dropping_H
#include "Dropping.h"
#endif


#include "IconClass.h"

#include "MacroParam.h"

MacroDropArea::MacroDropArea(MacroParamEditor* owner):
        owner_(owner)
{
	install(owner_->drag());
}

Widget MacroDropArea::menu()
{   
    Widget menu = owner_->menu();
    XtSetSensitive(menu, current_.size() != 0);
    return menu;
}   

void MacroDropArea::openIcon(IconObject* o)
{
    IconHolder::openIcon(o);
}

void MacroDropArea::closeIcon(IconObject* o)
{
    IconHolder::closeIcon(o);
}


MacroParamEditor::MacroParamEditor(const IconClass& name,const string& kind):
  XEditor<UIParamEditor_c>(name,kind),
  panel_(0),
  macroArea_(this)
{
}

MacroParamEditor::~MacroParamEditor()
{
}

bool MacroDropArea::accept(IconObject* o)
{   
    const IconClass& ic = o->iconClass();
    if ( ic.canBecome(IconClass::find("MACRO")) )   return true;
    return false;   
}

void MacroDropArea::drop(Dropping& drop)
{
    IconObjectH o = drop.object(*this);
    clear();
    cout << "MacroAera::drop" << endl;
    o->request().print();
    if ( drop.copy() )   
        o = o->clone(owner_->current()->embeddedFolder());
    add(o); 
    owner_->editMacro(o);
}

void MacroDropArea::add(IconObjectH o) 
{
    clear();
    IconHolder::add(o);
}

void MacroDropArea::clear() 
{
    IconHolder::clear();
}   

vector<IconObjectH> MacroDropArea::icon() 
{
    return icons_;
}

Widget MacroParamEditor::drag() 
{       
    return drag_;
}

Widget MacroParamEditor::menu() 
{       
    return menu_;
}

void MacroParamEditor::apply()
{
	panel_->apply();
	state_->request(panel_->request());
	macroParam()->state(state_);
}

MacroParam* MacroParamEditor::macroParam() const
{
	IconObject* cur = current_;
	return  dynamic_cast<MacroParam*>(cur);
}

void MacroParamEditor::reset()
{   
	delete  panel_;
	panel_ = 0;

	macroArea_.clear();

	MacroParam* obj = macroParam();
	state_ = obj->state();

	editMacro(state_->macro());
}

void MacroParamEditor::close()
{      
   if ( macro_ ) macro_->removeObserver(this);
   macro_ = 0;
   delete  panel_;
   panel_ = 0;
   state_ = 0;
}

void MacroParamEditor::editMacro(IconObjectH macro)
{     
	if ( macro_ )
	     macro_->removeObserver(this);
	macro_ = macro;

	if(macro) {
		macroArea_.add(macro);      
		macro_->addObserver(this);
	}

	state_->macro(macro);

	delete  panel_;
	panel_  = new RequestPanel(state_->iconClass(), editor_, 0); 
	panel_->reset(state_->iconObject());
}

void MacroParamEditor::replace(IconObject* o)
{
    panel_->replace(o);
}

void MacroParamEditor::merge(IconObject* o)
{
     panel_->merge(o); 
}


IconObject* MacroParamEditor::copy(const string& name)
{
    IconObject* o = IconFactory::create(name, class_);
    panel_->apply();
    o->request(panel_->request());
    return o;
}

void MacroParamEditor::removeCB(Widget, XtPointer) 
{
    macroArea_.clear();
    panel_->Unmanage();
    delete panel_;

    state_->macro(0);  //-- no macro anymore!

    //-- recreate panel_ or Apply button will core dump (020218/vk)
    panel_ = new RequestPanel(state_->iconClass(), editor_, 0);
    panel_->reset(state_->iconObject());
}

void MacroParamEditor::editCB(Widget, XtPointer)
{
	macro_->edit();
}
    
void MacroParamEditor::edited(IconObject* o)
{
    macroArea_.openIcon(o);
}

void MacroParamEditor::changed(IconObject* o)
{
    editMacro(o);
}

void MacroParamEditor::destroyed(IconObject* o)
{
    editMacro(0);
}

void MacroParamEditor::closed(IconObject* o)
{
     macroArea_.closeIcon(o);
}

static EditorMaker<MacroParamEditor> editorMaker("TwoLevelsEditor");
