/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#include <MPaper.hpp>

void MPaperWidget::init(MWidget *parent, const char *name, ...)
{
        va_list argptr;
        Arg al[64];           /* Arg List */
        register int ac = 0;      /* Arg Count */
 
        va_start(argptr, name);
        ac = MInitArgs(al, NULL, argptr);
        ident = mPaper;
        widget = (Widget) CreatePaperWidget( parent->widget, name, al, ac);
        attachObject();
	MFreeArgs(al, ac);
}
 
void MPaperWidget::setPages(PaperRectangle* r)
{
	PaperSetPages(widget,r);
}

PaperRectangle* MPaperWidget::newPage(double top,
	double left,double bottom,double right)
{
	return PaperNewPage(widget,top,left,bottom,right);
}

PaperRectangle* MPaperWidget::find(XEvent* ev)
{
	return PaperFind(widget,ev);
}

void MPaperWidget::update()
{
	PaperUpdate(widget);
}

PaperRectangle* MPaperWidget::getPages()
{
	return PaperGetPages(widget);
}

void MPaperWidget::insetSelection(double t,double l,double b,double r)
{
	PaperInsetSelection(widget,t,l,b,r);
}

void MPaperWidget::setSize(double h,double v)
{
	PaperSetSize(widget,h,v);
}

void MPaperWidget::getSize(double& h,double& v)
{
	PaperGetSize(widget,&h,&v);
}

void MPaperWidget::splitSelection(int h,int v,double mh,double mv)
{
	PaperSplitSelection(widget,h,v,mv,mv);
}

void MPaperWidget::joinSelection()
{
	PaperJoinSelection(widget);
}

void MPaperWidget::groupSelection()
{
	PaperGroupSelection(widget);
}

void MPaperWidget::ungroupSelection()
{
	PaperUngroupSelection(widget);
}



void MPaperWidget::alignTop()
{
	PaperAlignTop(widget);
}

void MPaperWidget::alignLeft()
{
	PaperAlignLeft(widget);
}

void MPaperWidget::alignRight()
{
	PaperAlignRight(widget);
}

void MPaperWidget::alignBottom()
{
	PaperAlignBottom(widget);
}

void MPaperWidget::distributeHorizontally()
{
	PaperDistributeHorizontally(widget);
}

void MPaperWidget::distributeVertically()
{
	PaperDistributeVertically(widget);
}
