/***********************************************************************************************************************************
Buffer IO Write

Write to a Buffer object using the IoWrite interface.
***********************************************************************************************************************************/
#ifndef COMMON_IO_BUFFERWRITE_H
#define COMMON_IO_BUFFERWRITE_H

/***********************************************************************************************************************************
Object type
***********************************************************************************************************************************/
typedef struct IoBufferWrite IoBufferWrite;

#include "common/io/write.h"

/***********************************************************************************************************************************
Constructor
***********************************************************************************************************************************/
IoBufferWrite *ioBufferWriteNew(Buffer *buffer);

/***********************************************************************************************************************************
Functions
***********************************************************************************************************************************/
void ioBufferWrite(IoBufferWrite *this, Buffer *buffer);
IoBufferWrite *ioBufferWriteMove(IoBufferWrite *this, MemContext *parentNew);

/***********************************************************************************************************************************
Getters
***********************************************************************************************************************************/
IoWrite *ioBufferWriteIo(const IoBufferWrite *this);

/***********************************************************************************************************************************
Destructor
***********************************************************************************************************************************/
void ioBufferWriteFree(IoBufferWrite *this);

/***********************************************************************************************************************************
Macros for function logging
***********************************************************************************************************************************/
#define FUNCTION_LOG_IO_BUFFER_WRITE_TYPE                                                                                          \
    IoBufferWrite *
#define FUNCTION_LOG_IO_BUFFER_WRITE_FORMAT(value, buffer, bufferSize)                                                             \
    objToLog(value, "IoBufferWrite", buffer, bufferSize)

#endif
