# `abi_ptx`

The tracking issue for this feature is: [#38788]

[#38788]: https://github.com/rust-lang/rust/issues/38788

------------------------

When emitting PTX code, all vanilla Rust functions (`fn`) get translated to
"device" functions. These functions are *not* callable from the host via the
CUDA API so a crate with only device functions is not too useful!

OTOH, "global" functions *can* be called by the host; you can think of them
as the real public API of your crate. To produce a global function use the
`"ptx-kernel"` ABI.

<!-- NOTE(ignore) this example is specific to the nvptx targets -->

``` rust,ignore
#![feature(abi_ptx)]
#![no_std]

pub unsafe extern "ptx-kernel" fn global_function() {
    device_function();
}

pub fn device_function() {
    // ..
}
```

``` text
$ xargo rustc --target nvptx64-nvidia-cuda --release -- --emit=asm

$ cat $(find -name '*.s')
//
// Generated by LLVM NVPTX Back-End
//

.version 3.2
.target sm_20
.address_size 64

        // .globl       _ZN6kernel15global_function17h46111ebe6516b382E

.visible .entry _ZN6kernel15global_function17h46111ebe6516b382E()
{


        ret;
}

        // .globl       _ZN6kernel15device_function17hd6a0e4993bbf3f78E
.visible .func _ZN6kernel15device_function17hd6a0e4993bbf3f78E()
{


        ret;
}
```
