/* Copyright (C) 1993,1994 by the author(s).
 
 This software is published in the hope that it will be useful, but
 WITHOUT ANY WARRANTY for any part of this software to work correctly
 or as described in the manuals. See the ShapeTools Public License
 for details.

 Permission is granted to use, copy, modify, or distribute any part of
 this software but only under the conditions described in the ShapeTools 
 Public License. A copy of this license is supposed to have been given
 to you along with ShapeTools in a file named LICENSE. Among other
 things, this copyright notice and the Public License must be
 preserved on all copies.
*/
/*
 * ShapeTools/shape program - misc.c
 *
 * Author: Axel Mahler (Axel.Mahler@cs.tu-berlin.de)
 *
 * $Header: misc.c[8.0] Wed Jul  7 18:33:06 1993 axel@cs.tu-berlin.de frozen $
 */
#ifndef lint
static char *AtFSid = "$Header: misc.c[8.0] Wed Jul  7 18:33:06 1993 axel@cs.tu-berlin.de frozen $";
#endif

#include "shape.h"

/* Struct for registering links */
EXPORT struct linkreg *link_reg = (struct linkreg *) NIL;
LOCAL  struct linkreg *last_link;

LOCAL  char *types[] = { "generation",          /*  0  int */
			   "revision",            /*  1  int */
			   "state",               /*  2  short */
			   "author",              /*  3  short */
			   "group",               /*  4  short */
			   "version",             /*  5  char * */
			   "variant",             /*  6  char * */
			   "syspath",             /*  7  char * */
			   "host",                /*  8  char * */
			   "locker",              /*  9  char * */
			   "owner",               /* 10  char * */
			   "0"};                  /* 99  default = char *
						     (for userdefined attributes */


EXPORT char *states[] = { "busy",
			    "saved",
			    "proposed",
			    "published",
			    "accessed",
			    "frozen",
			    "0"};
  
EXPORT int get_attr_type (name)
     char *name;
{
  register int i = 0;

  if (name == NIL)
    return(99);

  while(strcmp(types[i],"0") != 0)
    {
      if((strcmp(types[i],name) == 0))
	return(i);
      i++;
    }
  return(99);
}

LOCAL struct linkreg *init_linkreg()
{
  register struct linkreg *lreg = (struct linkreg *) NIL;

  if ((lreg = (struct linkreg *) malloc(sizeof(struct linkreg))) ==
      (struct linkreg *) NIL)
    errexit(10,"malloc");
  if((lreg->fn = malloc(MYMAXNAMLEN)) == NIL)
    errexit(10,"malloc");
  if((lreg->newfn = malloc(MYMAXNAMLEN)) == NIL)
    errexit(10,"malloc");
  lreg->fn[0] = '\0';
  lreg->newfn[0] = '\0';
  lreg->next = (struct linkreg *) NIL;

  return(lreg);
}

EXPORT void register_link (fn, newfn, busy_exist)
     char *fn;
     char *newfn;
     Bool busy_exist;
{
  if (link_reg == (struct linkreg *) NIL)
    {
      link_reg = init_linkreg();
      strcpy(link_reg->fn, fn);
      strcpy(link_reg->newfn, newfn);
      link_reg->busy_exist = busy_exist;
      last_link = link_reg;
    }
  else
    {
      last_link->next = init_linkreg();
      last_link = last_link->next;
      strcpy(last_link->fn, fn);
      strcpy(last_link->newfn, newfn);
      last_link->busy_exist = busy_exist;
    }
}

EXPORT void cleanup_links (cur_link)
     struct linkreg *cur_link;
{
  if(cur_link != (struct linkreg *) NIL)
    {
      cleanup_links(cur_link->next);
    }

  if(cur_link != (struct linkreg *) NIL)
    {
      if (unlink(cur_link->fn) != 0)
	fprintf(stderr, "shape - warning: can't unlink temporarily restored version %s\n", cur_link->fn);
      if (cur_link->busy_exist)
	{
	  if (link (cur_link->newfn, cur_link->fn) != 0)
	    {
	      fprintf(stderr, "shape - warning: can't restore original busy version of %s\n",
		      cur_link->fn);
	      fprintf(stderr, "\t\t original file available as %s !\n", cur_link->newfn);
	    }
	  else
	    {
	      if (unlink(cur_link->newfn) != 0)
		fprintf(stderr, "shape - warning: can't unlink temporary file %s\n", cur_link->newfn);
	    }
	}
    }
}

EXPORT void free_linklist()
{
/* not yet implemented */
/* should free memory of linklist */
  ;
}

EXPORT Bool is_in_forcelist(name)
     char *name;
{
  register int i = 0;
  while(forcelist[i] != NIL) {
    if (!strcmp(forcelist[i],name))
      return(TRUE);
    i++;
  }
  return(FALSE);
}

EXPORT int D_debug(name,type,at)
     /*ARGSUSED*/
     char *name, *type, *at;
{
  printf("shape - %s does not bear the appropriate attributes or does not exist\n", name);
  return(0);
}
