%  slrnface - feeble attempt at delivering X-Faces to slrn users
%  Copyright (C) 2000, 2001, 2002  Drazen Kacar
%
%  This program is free software; you can redistribute it and/or modify
%  it under the terms of the GNU General Public License as published by
%  the Free Software Foundation; either version 2 of the License, or
%  (at your option) any later version.
%
%  This program is distributed in the hope that it will be useful,
%  but WITHOUT ANY WARRANTY; without even the implied warranty of
%  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%  GNU General Public License for more details.
%
%  You should have received a copy of the GNU General Public License
%  along with this program; if not, write to the Free Software
%  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

implements ("slrnface");

variable fp;	% Pipe to slrnface

define clear ()
{
   % This if is in case somebody's been messing with our private
   % variables. It shouldn't happen, but you never know.
   if (fp != NULL)
   {
      fputs ("clear\n", fp);
      fflush (fp);
   }
}

define read ()
{
   variable xface;

   if (fp != NULL)
   {
      xface = extract_article_header ("X-Face");
      if (xface != "")
	 fputs ("xface " + xface + "\n", fp);
      else
	 clear ();
      fflush (fp);
   }
}

define my_hide_article ()
{
   % Too bad slrn doesn't have a way to return function bound to a
   % certain key. If some other macro package binds its own function to
   % the key 'h' it will never be called, or this function will never be
   % called, depending on who made definekey call last.
   %
   % And this functionality doesn't have to be bound to 'h' in the first
   % place. We'd actually like to know which key will call hide_article
   % and then bind this function to that key. A hook would serve the
   % purpose better, though.

   call ("hide_article");
   if (is_article_visible ())
       read ();
   else
   {
      if (fp != NULL)
      {
	  fputs ("clear\n", fp);
	  fflush (fp);
      }
   }
}

define startup ()
{
   variable success, home, reason, envvar;

   fp = NULL;

   home = make_home_filename (".slrnfaces");
   if (home == NULL)
   {
      message_now ("Cannot run slrnface: home directory undefined.");
      return;
   }

   % If DISPLAY is not set slrnface can't run, but the user probably
   % knows that, so fail silently.
   envvar = getenv ("DISPLAY");
   if (envvar == NULL)
      return;

   % On the other hand, yell if WINDOWID is not set.
   envvar = getenv ("WINDOWID");
   if (envvar == NULL)
   {
      message_now ("Cannot run slrnface: $WINDOWID undefined.");
      return;
   }

   if (mkdir (home, 0700) != 0)
   {
      if (errno != EEXIST)
      {
	 reason = "cannot create " + home + ": " + errno_string(errno);
         message_now ("Cannot run slrnface: " + reason);
	 return;
      }
   }
   else
   {
      variable fpm, message;

      fpm = fopen (home + "/README", "w");
      if (fpm != NULL)
      {
         message =
"This directory is used to create named pipes for communication between\n" +
"slrnface and its parent process. It should normally be empty because\n" +
"the pipe is deleted right after it has been opened by both processes.\n\n" +
"File names generated by slrnface have the form \"hostname.pid\". It is\n" +
"probably an error if they linger here longer than a fraction of a second.\n" +
"\nHowever, if the directory is mounted from an NFS server, you might see\n" +
"special files created by your NFS server while slrnface is running.\n" +
"Do not try to remove them.\n";
	 fputs (message, fpm);
	 fclose (fpm);
      }
   }

   % This is our FIFO.
   home = home + "/" + uname().nodename + "." + string (getpid ());

   % If it already exists, we'll delete it first. Because it really
   % shouldn't exist.
   remove (home);

   if (mkfifo (home, 0600) != 0)
   {
      reason = "cannot create FIFO: " + errno_string(errno);
      message_now ("Cannot run slrnface: " + reason);
      return;
   }

   success = system ("slrnface " + home) shr 8;

   switch (success)
   { case 0: fp = fopen (home, "w");
      	     if (fp != NULL)
	     {
		fputs ("start\n", fp);
		fflush (fp);
		remove (home);
		
		% Seems everything's peachy keen, so we can register hooks.

		register_hook ("followup_hook",     "slrnface->clear");
		register_hook ("forward_hook",      "slrnface->clear");
		register_hook ("group_mode_hook",   "slrnface->clear");
		register_hook ("post_hook",         "slrnface->clear");
		register_hook ("reply_hook",        "slrnface->clear");
		register_hook ("supersede_hook",    "slrnface->clear");

		register_hook ("read_article_hook", "slrnface->read");
		definekey ("slrnface->my_hide_article", "h", "article");
		return;
	     }
	     else
		reason = "cannot open " + home + ": " + errno_string(errno);
   }
   % case 1 means DISPLAY is set, but slrnface couldn't connect. Probably
   % because X server refused. We need to inform the user about this.
   { case 1: reason = "couldn't connect to display."; }
   { case 2: reason = "WINDOWID not found in environment."; }
   { case 3: reason = "couldn't find controlling terminal."; }
   { case 4: reason = "terminal doesn't export width and height."; }
   { case 5: reason = "cannot open " + home + " as FIFO."; }
   { case 6: reason = "fork() failed."; }
   { reason = "error " + string (success) + " (unknown reason)."; }

   % Delete the FIFO.
   remove (home);

   message_now ("Slrnface failed: " + reason);
}

register_hook ("startup_hook", "slrnface->startup");
