/*
 *  Copyright (C) 2008 Nicolas Vion <nico@picapo.net>
 *
 *   This file is part of swac-get.
 *
 *   Swac-get is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   Swac-get is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with Foobar; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <string>
#include <list>
#include <vector>
#include <iostream>

#include <libxml/uri.h>

#include "http.hh"
#include "basic.hh"

#include "swac.hh"



#define IS_HTTP(str) str.substr(0, 7) == "http://"
#define IS_FILE(str) str.substr(0, 7) == "file://"


void Tswac::package_deselect_idx(std::string idx) {
	db.query("DELETE FROM `sounds` WHERE `packages_idx` = '" + idx + "';");
	db.query("DELETE FROM `alphaidx` WHERE `packages_idx` = '" + idx + "';");
	db.query("DELETE FROM `packages` WHERE `idx` = '" + idx + "';");
}


static int package_delete_callback(void *user_data, int argc, char **argv, char **col_name){
	if (argc == 1)
		((Tswac *) user_data)->package_deselect_idx(argv[0]);
	return 0;
}


bool Tswac::package_delete(std::string url) {
	db.exec("SELECT idx FROM `packages` WHERE `path` = " + db.str(url) + ";" , package_delete_callback, this); 
	return (db.changes() != 0);
}


void Tswac::package_deselect(std::string url) {
	if (IS_HTTP(url) or IS_FILE(url)) {
		print_action("DESELECT PACKAGE \"" + url + "\"");
		print_result(package_delete(url));
	}
	else 
		package_deselect_id(url);
}


void Tswac::package_select_url(std::string url) {
	print_action("LOAD PACKAGE " + url);

	package_delete(url);

	if (!Tswac_package::load("packages", url)) {
		print_result(false);
		return;
	}

	if (IS_FILE(url))
		print_result(read_file(db.last_insert_rowid(), url.substr(7, url.size() - 7) + "index.xml.bz2"));

	else if (IS_HTTP(url))
		print_result(read_url(db.last_insert_rowid(), url + "index.xml.bz2"));

	else 
		print_result(false);
}

void Tswac::package_select(std::string str) {
	if (IS_FILE(str) or IS_HTTP(str))
		package_select_url(str);
	else
		package_select_id(str);
}


static int upgrade_callback(void *user_data, int argc, char **argv, char **col_name){
	if (argc == 1)
		((std::list<std::string> *) user_data)->push_back(argv[0]);

	return 0;
}

void Tswac::upgrade() {
	std::list<std::string> list;
	db.exec("SELECT path FROM `packages` ;", upgrade_callback, &list); 
	for (std::list<std::string>::iterator it = list.begin(); it != list.end(); it++)
		package_select(*it);
}



void Tswac::source_select(std::string url) {
	print_action("SELECT SOURCE \"" + url + "\"");
	print_result(
		db.query("DELETE FROM `sources` WHERE `path`=" + db.str(url) + ";") and
		db.query("INSERT INTO `sources` (path, selected) VALUES (" + db.str(url) + ", '1');")
	);
}


void Tswac::source_deselect(std::string url) {
	print_action("DESELECT SOURCE \"" + url + "\"");
	print_result(
		db.query("UPDATE `sources` SET `selected`='0' WHERE `path`=" + db.str(url) + ";") and
		db.changes() != 0
	);
}



void Tswac::source_delete(std::string url) {
	print_action("DELETE SOURCE \"" + url + "\"");
	print_result(
		db.query("DELETE FROM `sources` WHERE `path`=" + db.str(url) + ";") and
		db.changes() != 0
	);
}

void Tswac::source_load(std::string url) {
	print_action("LOOKING ON " + url);
	if (url.size() > 7 and IS_HTTP(url))
		print_result(Tswac_repository_http::load(url));
	

	else if (url.size() > 7 and IS_FILE(url)) 
		print_result(Tswac_repository_local::load(url.substr(7, url.size() - 7)));

	else {
		print_error("Not a valid url: \"" + url + "\"");
		print_result(false);
	}
}

int update_callback(void *user_data, int argc, char **argv, char **col_name){
	if (argc == 1) 
		((Tswac*) user_data)->source_load(argv[0]);
	
	return 0;
}


void Tswac::update() {
	if (db.query("DELETE FROM `packages_available`;"))
		db.exec("SELECT path FROM `sources` WHERE selected='1';" , update_callback, this);
}





static int package_select_id_callback(void *user_data, int argc, char **argv, char **col_name){

	std::vector<std::string> *result = (std::vector<std::string> *) user_data;
	result->push_back(argv[2]);
	std::cout << result->size() << ")" << std::endl;

	for (int i = 0; i < argc; i++) 
		std::cout << "  " << col_name[i] << ": " << argv[i] << std::endl; 
	std::cout << std::endl;
	return 0;
}



void Tswac::package_select_id(std::string packid) {
	std::vector<std::string> result;

	print_action("Looking for package \"" + packid + "\"");
	std::cout << std::endl;

	db.exec("SELECT format, version, path FROM `packages_available` WHERE `packid`=" + db.str(packid) + ";" , package_select_id_callback, &result);
	
	if (result.size() == 0) {
		print_error("Can not find package \"" + packid + "\"");
		return;
	}
	
	if (result.size() == 1) {
		package_select(result.at(0));
		return;	
	}

	int selected;
	std::cout << "Please, choose a package: ";
	std::cin >> selected;
	if (selected > 0 and selected <= result.size())
		package_select(result.at(selected - 1));
}


void Tswac::package_deselect_id(std::string packid) {
	std::vector<std::string> result;

	print_action("Looking for package \"" + packid + "\"");
	std::cout << std::endl;

	db.exec("SELECT format, version, path FROM `packages` WHERE `packid`=" + db.str(packid) + ";" , package_select_id_callback, &result);
	
	if (result.size() == 0) {
		print_error("Package \"" + packid + "\" not installed");
		return;
	}
	
	if (result.size() == 1) {
		package_deselect(result.at(0));
		return;	
	}

	int selected;
	std::cout << "Please, choose a package: ";
	std::cin >> selected;
	if (selected > 0 and selected <= result.size())
		package_deselect(result.at(selected - 1));
}

int sql_results;
static int sql_callback(void *user_data, int argc, char **argv, char **col_name){
	if (sql_results == 0) {
		for (int i = 0; i < argc; i++) {
			if (i != 0)
				std::cout << "	";
			std::cout << col_name[i];
		}
		std::cout << std::endl << "------------------" << std::endl;
	}
	sql_results++;

	for (int i = 0; i < argc; i++) {
		if (i != 0)
			std::cout << "	";
		std::cout << argv[i]; 
	}
	std::cout << std::endl;
	return 0;
}

void Tswac::sql(std::string query) {
	std::cout << "SQL QUERY: \"" << query << "\"" << std::endl;

	sql_results = 0;
	db.exec(query, sql_callback, this); 

	std::cout << "Result(s): " << sql_results << std::endl;
}



