/* This file is Copyright 1993 by Clifford A. Adams */
/* shcmd.c
 *
 * help scan command interpreter
 */

#include "EXTERN.h"
#include "common.h"
#ifdef SCAN
#include "final.h"		/* assert() */
#include "init.h"
#include "cache.h"
#include "bits.h"
#include "scan.h"
#include "scmd.h"
#include "sdisp.h"
#include "smisc.h"
#include "spage.h"
#include "shelp.h"
#include "shdata.h"
#include "shfile.h"
#include "shmisc.h"
#include "term.h"
#include "INTERN.h"
#include "shcmd.h"

void
sh_go_bot()
{
    s_ref_all = TRUE;
    s_goxy(0,LINES-s_bot_lines);	/* go to bottom bar */
    erase_eol();			/* erase to end of line */
    s_goxy(0,LINES-s_bot_lines);	/* go (back?) to bottom bar */
    fflush(stdout);			/* do it *now* */
}

/* interprets command in TRN-global buf */
int
sh_docmd()
{
    long a;		/* entry pointed to */
    int i;		/* for misc. purposes */
    char *s;

    a = page_ents[s_ptr_page_line].entnum;
    switch(*buf) {
	case '\n':
	case ' ':	/* enter group/context by default */
	    sh_go_bot();
	    s_refill = TRUE;
	    switch (sh_ents[a].type) {
		case 1:		/* file */
		    xmouse_off();
		    sh_page_file(sh_ents[a].file);
		    xmouse_on();
		    return(0);	/* carry on... */
		case 2:		/* file */
		    (void)sh_use_file(sh_ents[a].file,
				sh_ents[a].name);
		    if (s_fillpage()<=0) {
			/* if we cannot fill a page, go back up */
			s_beep();		/* alert the user */
			sh_old_context();	/* go back up */
			s_ref_all = TRUE;	/* refill and refresh all */
		    }
		    return(0);	/* carry on... */
	    }
	    printf("Help scan: Entry pointed to has an illegal type!\n") FLUSH;
	    assert(FALSE);
	    /* NOTREACHED */
	    break;
	case 'q':	/* quit from context or extended help */
	    /* maybe make behavior optional (sh_fastquit variable?) */
	    if (sh_num_contexts==1) {		/* at top */
		sh_go_bot();
		return(SH_QUIT);
	    }
	    /* FALL THROUGH */
	case '(':	/* go up a context */
	    if (sh_num_contexts<2) {	/* already at top */
		s_beep();
		break;
	    }
	    sh_go_bot();
	    sh_old_context();	/* maybe call a wrapper later */
	    s_refill = TRUE;
	    s_ref_all = TRUE;	/* refill and refresh all */
	    break;
	case Ctl('e'):		/* edit current file */
	    for (i=sh_num_contexts-1;i>=0;i--)
		if (sh_contexts[i].filename)
		    break;
	    if (i<0) {
		s_beep();
		break;
	    }
	    xmouse_off();
	    sh_edit_file(sh_contexts[i].filename,FALSE);
	    xmouse_on();
	    s_ref_all = TRUE;
	    break;
	case 'E':		/* edit file pointed to by cursor */
	    s = sh_ents[a].file;
	    xmouse_off();
	    if (isalnum(*s))
		sh_edit_file(s,TRUE);
	    else
		sh_edit_file(s,FALSE);
	    xmouse_on();
	    s_ref_all = TRUE;
	    break;
	default:
	    s_beep();
	    break;
    }
    return(0);
}
#endif /* SCAN */
