/* This file is Copyright 1993 by Clifford A. Adams */
/* shdata.h
 *
 * Data structures and functions for help scan
 */

/* per-entry data */
/* could be a union, but why bother? */
typedef struct sh_entrydata {
    int  type;
    /* 1: file containing help text
     * 2: topic file
     */
    long flags;
    char *name;			/* what to display for the description */
    char *file;			/* filename for topic or display */
} SH_ENTRYDATA;

/* note: the 0th entry of sh_ents is unused (scan compatibility) */
EXT int sh_num_ents		INIT(0);
EXT int sh_ents_alloc		INIT(0);
EXT SH_ENTRYDATA *sh_ents	INIT((SH_ENTRYDATA*)NULL);

typedef struct sh_context {
    int  cnum;			/* context number */
    int  num_ents;		/* number of entries */
    int  ents_alloc;		/* number of allocated entries */
    char *title;		/* for this context */
    char *filename;		/* if non-null, is filename of local context */
    /* add other things like flags later */
    SH_ENTRYDATA *ents;		/* entries */
} SH_CONTEXT;

EXT int sh_num_contexts		INIT(0);
EXT int sh_max_contexts		INIT(0);
EXT SH_CONTEXT *sh_contexts	INIT((SH_CONTEXT*)NULL);

void	sh_init_context	_((void));
void	sh_new_context	_((void));
void	sh_old_context	_((void));

bool	sh_init_ents	_((void));
int	sh_add_ent	_((int,char*));
void	sh_free_ents	_((void));
