/* 
 *	HT Editor
 *	htpal.h
 *
 *	Copyright (C) 1999, 2000, 2001 Stefan Weyergraf (stefan@weyergraf.de)
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License version 2 as
 *	published by the Free Software Foundation.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __HTPAL_H__
#define __HTPAL_H__

#include "htdata.h"
#include "htreg.h"

#define rnt_palette_name		"palette"

struct defpal {
	int idx;
	char *name;
	int color;
};

/*
 *	CLASS palette_entry
 */

class palette_entry: public ht_registry_data {
public:
	UINT idx;
	vcp color;

			palette_entry(UINT idx=0, vcp color=0);
/* overwritten */
	virtual	bool editdialog(char *keyname);
	virtual   void strvalue(char *buf32bytes);
	virtual	int  load(ht_object_stream *f);
	virtual	OBJECT_ID object_id();
	virtual	void store(ht_object_stream *f);
};

/*
 *	palette_key
 */

#define palettekey "palette"

/*
 *   palette class keys
 */

#define palclasskey_windialog						"windialog"
#define palclasskey_menu	     					"menu"
#define palclasskey_help     						"help"
#define palclasskey_keyline     					"keyline"
#define palclasskey_desktop     					"desktop"
#define palclasskey_tags	     					"tags"

/*
 *	windialog palette
 */

#define palkey_windialog_window_default				"default_window"
#define palkey_windialog_dialog_default				"default_dialog"

#define palkey_windialog_cyan						"cyan"
#define palkey_windialog_black					"black"
#define palkey_windialog_blue						"blue"
#define palkey_windialog_gray						"gray"
#define palkey_windialog_special					"special"

#define palcolors_windialog						23

#define palidx_windialog_body						0
#define palidx_windialog_shortcut					1
#define palidx_windialog_frame_focused				2
#define palidx_windialog_frame_unfocused			3
#define palidx_windialog_frame_moved    			4
#define palidx_windialog_frame_killer				5
#define palidx_windialog_scrollbar					6

#define palidx_windialog_input_focused				7
#define palidx_windialog_input_unfocused			8
#define palidx_windialog_input_selected				9
#define palidx_windialog_input_clip 				10

#define palidx_windialog_button_focused				11
#define palidx_windialog_button_unfocused			12
#define palidx_windialog_button_shadow 				13
#define palidx_windialog_button_shortcut			14

#define palidx_windialog_list_focused_selected		15
#define palidx_windialog_list_focused_unselected		16
#define palidx_windialog_list_unfocused_selected		17
#define palidx_windialog_list_unfocused_unselected	18

#define palidx_windialog_cluster_focused			19
#define palidx_windialog_cluster_unfocused			20
#define palidx_windialog_cluster_shortcut			21

#define palidx_windialog_label_focused				22

/*
 *	keyline palette
 */

#define palkey_keyline_default					"keyline"

#define palcolors_keyline		          		3

#define palidx_keyline_digit						0
#define palidx_keyline_active						1
#define palidx_keyline_inactive					2

/*
 *	desktop palette
 */

#define palkey_desktop_default					"desktop"

#define palcolors_desktop						1

#define palidx_desktop_body  						0

/*
 *	tag palette
 */

#define palkey_tags_default						"default"

#define palkey_tags_black						"black"
#define palkey_tags_blue							"blue"

#define palcolors_tags							9
/* coloridcs defined in httag.h */


struct palette {
	UINT size;
	vcp *data;
};

/*
 *   reg/pal management
 */

int create_pal(char *pal_class, char *pal_name, defpal *p, int entry_count, ht_registry_node_type rnt_pal);
vcp getcolorv(palette *pal, UINT index);
bool reloadpalettev(char *pal_class, char *pal_name, palette *pal);

/*
 *	INIT
 */

bool init_pal();

/*
 *	DONE
 */

void done_pal();

#endif /* !__HTPAL_H__ */
