/**
 * Python Interpreter wrapper for Inkscape
 *
 * Authors:
 *   Bob Jamison <rjamison@titan.com>
 *
 * Copyright (C) 2004 Authors
 *
 * Released under GNU GPL, read the file 'COPYING' for more information
 */


#include <Python.h>

#include "InkscapePython.h"


#include <stdio.h>

#include "inkscape_py.py.h"


/*
 * Generated by SWIG
 */
extern "C" void init_inkscape_py(void);


namespace Inkscape {
namespace Extension {
namespace Script {

/*
 *
 */
InkscapePython::InkscapePython()
{
}

    

/*
 *
 */
InkscapePython::~InkscapePython()
{

}

    
    
static bool initialized = false;
/*
 *  Interpret an in-memory string
 */
bool InkscapePython::interpretScript(Glib::ustring &script,
                                 Glib::ustring &output,
                                 Glib::ustring &error)
{
    if (!initialized)
        {
        Py_Initialize();
        init_inkscape_py();
        initialized = true;
        }
    char *codeStr = (char *)script.raw().c_str();
    PyRun_SimpleString(inkscape_module_script);
    PyRun_SimpleString("inkscape = _inkscape_py.getInkscape()\n");
    PyRun_SimpleString(codeStr);
    
    //## Check for errors
    if (PyErr_Occurred())
        {
        PyObject *errobj       = NULL;
        PyObject *errdata      = NULL;
        PyObject *errtraceback = NULL;

        PyErr_Fetch(&errobj, &errdata, &errtraceback);
        //PyErr_Clear();
        
        if (errobj && PyString_Check(errobj))
            {
            PyObject *pystring = PyObject_Str(errobj);
            char *errStr =  PyString_AsString(pystring);
            error = errStr;
            Py_XDECREF(pystring);
            }
        else
            {
            error = "Error occurred";
            }
        Py_XDECREF(errobj);
        Py_XDECREF(errdata);
        Py_XDECREF(errtraceback);
        return false;
        }
    //Py_Finalize();
    return true;
}

    
    




}  // namespace Script
}  // namespace Extension
}  // namespace Inkscape

/*
  Local Variables:
  mode:c++
  c-file-style:"stroustrup"
  c-file-offsets:((innamespace . 0)(inline-open . 0)(case-label . +))
  indent-tabs-mode:nil
  fill-column:99
  End:
*/
// vim: filetype=cpp:expandtab:shiftwidth=4:tabstop=8:softtabstop=4:encoding=utf-8:textwidth=99 :
