//////////////////////////////////////////////////////////////
//      $Id: kissInterface.h,v 1.11 2001/04/02 16:27:50 toivo Exp $ 
//
// Author: Toivo Pedaste
//
//////////////////////////////////////////////////////////////

#ifndef KISS_IFACE_H
#define KISS_IFACE_H

#include "../config.h"

#include <qlist.h>
#include <qstringlist.h>
#include <kprocess.h>

#include "procbuf.h"
#include "pkgInterface.h"

class packageInfo;
class updateLoc;
class cacheObj;

class KISS: public pkgInterface
{
  Q_OBJECT

public:
  KISS(QString remote);
  ~KISS();
  
  bool isType(char *buf, const QString &fname);
  param *initinstallOptions();
  param *inituninstallOptions();
  packageInfo *getPackageInfo(char mode, const QString &name, const QString &version);
  QStringList getFileList(packageInfo *p);

  QStringList FindFile(const QString &name);
  bool parseName(QString name, QString *n, QString *v);

public slots:
  void setLocation();
  void setAvail(LcacheObj *);

private:
  packageInfo* collectInfo(const char *inp);
  void listInstalledPackages(QList<packageInfo> *pki);
 
  QString install(int installFlags, QList<packageInfo> *plist, bool &test);
  QString uninstall(int uninstallFlags, QList<packageInfo> *plist, bool &test);

  QString doUninstall(int installFlags, QString packs, bool &test);
  QString doInstall(int installFlags, QString packs, bool &test);

};

#endif



