# Known Issues

## Printer crash

There is a bug in Clang 3.4.2 that causes wrong data tree traversal, which results in a crash.
It can occur during any traversal but it was observed in XML printer while printing default
values. The solution is to compile using either GCC or newer version of Clang. Starting
from which version it works we do not exactly know. Clang 5.0.0 works fine.

## XPath Expressions

### Axes

libyang uses its own XPath implementation to evaluate XPath expressions. The implementation
completely lacks support for [axes](https://www.w3.org/TR/1999/REC-xpath-19991116/#axes).
Nevertheless, it should always be possible to write equivalent expressions without
the use of axes.

### Deviation Must

If there are any XPath expressions defined as part of a deviation, they include literals,
which are directly compared with identityref nodes (testing whether an identityref has a
specific identity value), and the identity literal used is from the deviation module
(meaning it could be written without a prefix), the prefix is mandatory for libyang
to evaluate the XPath expression correctly.

## Nested Notification/Action Validation

[NMDA RFC](https://tools.ietf.org/html/rfc8342#section-6.2) specifically defines that
the parent data node of an invoked nested notification or action must exist in
the operational datastore. This validation is not implicitly performed by libyang when
validating the operation so if the validation is supposed to happen in full compliance
to this RFC, parent existence must be checked explicitly.

## Wrong API version

Since libyang 1.0, there is a check to make sure that the (user type or extension) plugin
was compiled with the compatible API version. In case there is a plugin with incompatible
API version, the following warning is generated by libyang:

libyang[1]: Processing "user\_date\_and\_time" user type plugin failed, wrong API version - 1 expected, 0 found.

The default path for the plugins is `/usr/local/lib64/libyang/` so you can clean it up
manually or set a different plugin directory via `LIBYANG_EXTENSIONS_PLUGINS_DIR` or
`LIBYANG_USER_TYPES_PLUGINS_DIR` environment variables.

