<?php
/**
 * Aliases for special pages
 *
 * @file
 * @ingroup Extensions
 */

$aliases = array();

/** English
 * @author IAlex
 */
$aliases['en'] = array(
	'OpenIDLogin'  => array( 'OpenIDLogin' ),
	'OpenIDFinish' => array( 'OpenIDFinish' ),
	'OpenIDConvert' => array( 'OpenIDConvert' ),
	'OpenIDServer' => array( 'OpenIDServer' ),
	'OpenIDXRDS' => array( 'OpenIDXRDS' ),
);

/** Arabic (العربية) */
$aliases['ar'] = array(
	'OpenIDLogin' => array( 'دخول_الهوية_المفتوحة' ),
	'OpenIDFinish' => array( 'نهاية_الهوية_المفتوحة' ),
	'OpenIDConvert' => array( 'تحويل_الهوية_المفتوحة' ),
	'OpenIDServer' => array( 'خادم_الهوية_المفتوحة' ),
	'OpenIDXRDS' => array( 'إكسردس_الهوية_المفتوحة' ),
);

/** Egyptian Spoken Arabic (مصرى) */
$aliases['arz'] = array(
	'OpenIDLogin' => array( 'دخول_الهوية_المفتوحة' ),
	'OpenIDFinish' => array( 'نهاية_الهوية_المفتوحة' ),
	'OpenIDConvert' => array( 'تحويل_الهوية_المفتوحة' ),
	'OpenIDServer' => array( 'خادم_الهوية_المفتوحة' ),
	'OpenIDXRDS' => array( 'إكسردس_الهوية_المفتوحة' ),
);

/** Interlingua (Interlingua) */
$aliases['ia'] = array(
	'OpenIDLogin' => array( 'Aperir session OpenID' ),
	'OpenIDFinish' => array( 'Completar session OpenID' ),
	'OpenIDConvert' => array( 'Converter a OpenID' ),
	'OpenIDServer' => array( 'Servitor OpenID' ),
	'OpenIDXRDS' => array( 'XRDS OpenID' ),
);

/** Japanese (日本語) */
$aliases['ja'] = array(
	'OpenIDLogin' => array( 'OpenIDログイン' ),
	'OpenIDFinish' => array( 'OpenID完了' ),
	'OpenIDConvert' => array( 'OpenID変換' ),
	'OpenIDServer' => array( 'OpenIDサーバー' ),
);

/** Sanskrit (संस्कृत) */
$aliases['sa'] = array(
	'OpenIDLogin' => array( 'उद्घटपरिचयपत्रप्रवेश' ),
	'OpenIDFinish' => array( 'उद्घटपरिचयपत्रसमापयति' ),
	'OpenIDConvert' => array( 'उद्घटपरिचयपत्रांतर' ),
	'OpenIDServer' => array( 'उद्घटपरिचयपत्रविदादाता' ),
	'OpenIDXRDS' => array( 'उद्घटपरिचयपत्रXRDS' ),
);

/** Tagalog (Tagalog) */
$aliases['tl'] = array(
	'OpenIDLogin' => array( 'Paglagda sa OpenID' ),
	'OpenIDFinish' => array( 'Pagtatapos ng OpenID' ),
	'OpenIDConvert' => array( 'Pagpapalit ng OpenID' ),
	'OpenIDServer' => array( 'Serbidor ng OpenID' ),
	'OpenIDXRDS' => array( 'XRDS ng OpenID' ),
);

