//---------------------------------------------------------------------------
#include "BibleCSMGR.h"
#include <swconfig.h>
//---------------------------------------------------------------------------
BibleCSMGR::BibleCSMGR(TModInstFrm *iModInstFrm) : SWMgr(0, false)
{
	ModInstFrm = iModInstFrm;
	Load();
}


char BibleCSMGR::AddModToConfig(int conffd, const char *fname)
{
	SWConfig modconf(fname);
	SectionMap::iterator section;
	AnsiString abouttext = "";
	bool logflag;
	TMemoryStream *RTFStream = new TMemoryStream();
	char retval;

	section = modconf.Sections.begin();

	ModInstFrm->ModText->Caption = "";
	ModInstFrm->ModText->Caption = ModInstFrm->ModText->Caption + "Found new module [ " + (*section).second["Description"].c_str() + " ]. Installing...";

	abouttext = abouttext + "{\\fs20\\cf0 " + (*section).second["About"].c_str() + " }";
	RTFStream->Clear();
	RTFStream->WriteBuffer(abouttext.c_str(), abouttext.Length());
	RTFStream->Position = 0;
	ModInstFrm->AboutText->Lines->LoadFromStream(RTFStream);
	delete RTFStream;
	
	ModInstFrm->ShowModal();

	logflag = SWLog::systemlog->log;
	SWLog::systemlog->log = false;	
	retval = SWMgr::AddModToConfig(conffd, fname);
	SWLog::systemlog->log = logflag;
	
	return retval;
}
