//---------------------------------------------------------------------------
#include <vcl\vcl.h>
#pragma hdrstop

#include <localemgr.h>
#include <list>
#include <string>
#include <dirent.h>
#include <io.h>
#include <dir.h>
#include "optionfrm.h"
#include "mainfrm.h"


//---------------------------------------------------------------------------
#pragma resource "*.dfm"
TOptionsfrm *Optionsfrm;

const char *TOptionsfrm::defaultLocaleName = "en_us";
const char *TOptionsfrm::defaultLocaleDescription = "English (US)";
//---------------------------------------------------------------------------
__fastcall TOptionsfrm::TOptionsfrm(TComponent* Owner)
	: TForm(Owner)
{
	 FontDialogText = new TFontSelFrm(this);
    	 FontDialogComment = new TFontSelFrm(this);
    	 FontDialogLD = new TFontSelFrm(this);
}
//--------------------------------------------------------------------------- 
void __fastcall TOptionsfrm::btnCurrVerseClick(TObject *Sender)
{
	ColorDialog1->Execute();
	CurrentVSColor->Brush->Color = ColorDialog1->Color;
	UpdatePreview();
}
//---------------------------------------------------------------------------


void __fastcall TOptionsfrm::FormCreate(TObject *Sender)
{
	list<string> locales;

	localeCB->Clear();
	localeCB->Items->AddObject(defaultLocaleDescription, (TObject *)defaultLocaleName);

	locales = LocaleMgr::systemLocaleMgr.getAvailableLocales();

	for (list<string>::iterator it = locales.begin(); it != locales.end(); it++) {
		const char *name       = LocaleMgr::systemLocaleMgr.getLocale(it->c_str())->getName();
		const char *description = LocaleMgr::systemLocaleMgr.getLocale(it->c_str())->getDescription();
		localeCB->Items->AddObject(description, (TObject *)name);
	}
	localeCB->ItemIndex = 0;
}
//---------------------------------------------------------------------------


void __fastcall TOptionsfrm::FormShow(TObject *Sender)
{

        PageControl1->ActivePage = TabSheet1;
        FindSchemeNames();
        cmbTextSelect->ItemIndex = 0;
        UpdatePreview();
}



void __fastcall TOptionsfrm::btnFontClick(TObject *Sender)
{

        TFontSelFrm* tempFrm = new TFontSelFrm(this);
        switch (cmbTextSelect->ItemIndex)
        {
          case 0:
		CopyFontDlg(tempFrm, FontDialogText);
          if(FontDialogText->ShowModal() == mrOk){
               CopyFontDlg(FontDialogComment, FontDialogText);
               CopyFontDlg(FontDialogLD, FontDialogText);
	          UpdatePreview();
          }else CopyFontDlg(FontDialogText, tempFrm);
          break;
          case 1:
		CopyFontDlg(tempFrm, FontDialogText);
          if(FontDialogText->ShowModal() == mrOk)
	          UpdatePreview();
          else CopyFontDlg(FontDialogText, tempFrm);
          break;
          case 2:
          CopyFontDlg(tempFrm, FontDialogComment);
          if(FontDialogComment->ShowModal() == mrOk)
	          UpdatePreview();
          else CopyFontDlg(FontDialogComment, tempFrm);
          break;
          case 3:
          CopyFontDlg(tempFrm, FontDialogLD);
          if(FontDialogLD->ShowModal() == mrOk)
	          UpdatePreview();
          else	CopyFontDlg(FontDialogLD, tempFrm);
        }
        delete tempFrm;
}
//---------------------------------------------------------------------------

void __fastcall TOptionsfrm::CurrentVSColorMouseDown(TObject *Sender,
      TMouseButton Button, TShiftState Shift, int X, int Y)
{
      	ColorDialog1->Execute();
	CurrentVSColor->Brush->Color = ColorDialog1->Color;
        UpdatePreview();
}
//---------------------------------------------------------------------------

void __fastcall TOptionsfrm::btnNumClrClick(TObject *Sender)
{
    ColorDialogVerseNum->Execute();
    UpdatePreview();
}
//---------------------------------------------------------------------------


void __fastcall TOptionsfrm::btnFieldClrClick(TObject *Sender)
{
   ColorDialogField->Execute();
}
//---------------------------------------------------------------------------


void __fastcall TOptionsfrm::cmbTextSelectChange(TObject *Sender)
{
  UpdatePreview();

}
//---------------------------------------------------------------------------


void __fastcall TOptionsfrm::cmbSchemeSelectChange(TObject *Sender)
{
     AnsiString tempName = ExtractFilePath(Application->ExeName) + COLOR_DIR + Optionsfrm->cmbSchemeSelect->Text + COLOR_EXT;
	SWConfig schemesconf(tempName.c_str());
	SectionMap::iterator sit;

	if ((sit = schemesconf.Sections.find("Appearance")) != schemesconf.Sections.end()) {
		if ((*sit).second.find("CurrentVSColor") != (*sit).second.end()){
			Optionsfrm->CurrentVSColor->Brush->Color =  TColor(atoi((*(*sit).second.find("CurrentVSColor")).second.c_str()));
			Optionsfrm->ColorDialog1->Color = TColor(atoi((*(*sit).second.find("CurrentVSColor")).second.c_str()));
		}
		else{
			Optionsfrm->CurrentVSColor->Brush->Color =  TColor(clBlue);
			Optionsfrm->ColorDialog1->Color = TColor(clBlue);
                }

                if ((*sit).second.find("VSNumberColor") != (*sit).second.end())
                        Optionsfrm->ColorDialogVerseNum->Color =  TColor(atoi ((*(*sit).second.find("VSNumberColor")).second.c_str()));
                else
                        Optionsfrm->ColorDialogVerseNum->Color = clBlue;

                if ((*sit).second.find("TextBackColor") != (*sit).second.end())
                        Optionsfrm->FontDialogText->BackColor = TColor(atoi((*(*sit).second.find("TextBackColor")).second.c_str()));
                else
                        Optionsfrm->FontDialogText->BackColor = TColor(clWhite);

                if ((*sit).second.find("CommentBackColor") != (*sit).second.end())
                        Optionsfrm->FontDialogComment->BackColor = TColor(atoi((*(*sit).second.find("CommentBackColor")).second.c_str()));
                else
                        Optionsfrm->FontDialogComment->BackColor = TColor(clWhite);

                if ((*sit).second.find("LDBackColor") != (*sit).second.end())
                        Optionsfrm->FontDialogLD->BackColor =  TColor(atoi((*(*sit).second.find("LDBackColor")).second.c_str()));
                else
                        Optionsfrm->FontDialogLD->BackColor = TColor(clWhite);

                if ((*sit).second.find("TextFontName") != (*sit).second.end())
                        Optionsfrm->FontDialogText->Font->Name =  ((*(*sit).second.find("TextFontName")).second.c_str());
                else
                        Optionsfrm->FontDialogText->Font->Name = "Times New Roman";

                if ((*sit).second.find("CommentFontName") != (*sit).second.end())
                        Optionsfrm->FontDialogComment->Font->Name =  ((*(*sit).second.find("CommentFontName")).second.c_str());
                else
                        Optionsfrm->FontDialogComment->Font->Name = "Times New Roman";

                if ((*sit).second.find("LDFontName") != (*sit).second.end())
                        Optionsfrm->FontDialogLD->Font->Name =  ((*(*sit).second.find("LDFontName")).second.c_str());
                else
                        Optionsfrm->FontDialogLD->Font->Name = "Times New Roman";
                if ((*sit).second.find("TextFontSize") != (*sit).second.end())
                        Optionsfrm->FontDialogText->Font->Size =  (atoi ((*(*sit).second.find("TextFontSize")).second.c_str()));
                else
                        Optionsfrm->FontDialogText->Font->Size = 10;
                if ((*sit).second.find("CommentFontSize") != (*sit).second.end())
                        Optionsfrm->FontDialogComment->Font->Size = (atoi ((*(*sit).second.find("CommentFontSize")).second.c_str()));
                else
                        Optionsfrm->FontDialogComment->Font->Size = 10;

                if ((*sit).second.find("CommentFontSize") != (*sit).second.end())
                        Optionsfrm->FontDialogLD->Font->Size =  (atoi ((*(*sit).second.find("LDFontSize")).second.c_str()));
                else
                        Optionsfrm->FontDialogLD->Font->Size = 10;
                if ((*sit).second.find("TextFontColor") != (*sit).second.end())
                        Optionsfrm->FontDialogText->Font->Color  =  TColor(atoi ((*(*sit).second.find("TextFontColor")).second.c_str()));
                else
                        Optionsfrm->FontDialogText->Font->Color  = clBlack;

                if ((*sit).second.find("CommentFontColor") != (*sit).second.end())
                        Optionsfrm->FontDialogComment->Font->Color  =  TColor(atoi ((*(*sit).second.find("CommentFontColor")).second.c_str()));
                else
                        Optionsfrm->FontDialogComment->Font->Color  = clBlack;

                if ((*sit).second.find("LDFontColor") != (*sit).second.end())
                        Optionsfrm->FontDialogLD->Font->Color  =  TColor(atoi ((*(*sit).second.find("LDFontColor")).second.c_str()));
                else
                        Optionsfrm->FontDialogLD->Font->Color = clBlack;

                if ((*sit).second.find("FieldColor") != (*sit).second.end())
                        Optionsfrm->ColorDialogField->Color =  TColor(atoi ((*(*sit).second.find("FieldColor")).second.c_str()));
                else
                        Optionsfrm->ColorDialogField->Color = clAqua;


	}

        UpdatePreview();


}
//---------------------------------------------------------------------------


void TOptionsfrm::UpdatePreview()
{
        char buffTemp[512], buffFinal[512], font[64];
        char* verse = "Why, my beloved brothers, let every man be swift to hear, slow to speak, slow to wrath";
        int vsColorRed, vsColorGreen, vsColorBlue,  numColorRed, numColorGreen, numColorBlue;
        int fontSize;
        TMemoryStream * RTFStream = new TMemoryStream;

        strcpy(buffFinal, "{\\rtf1\\ansi");

        switch (cmbTextSelect->ItemIndex)
        {
        case 2:
                TForm1::TColorToRGB(FontDialogComment->Font->Color, vsColorRed, vsColorGreen, vsColorBlue);
                TForm1::TColorToRGB(ColorDialogVerseNum->Color, numColorRed, numColorGreen, numColorBlue);
                strcpy(font, FontDialogComment->Font->Name.c_str());
                fontSize =  FontDialogComment->Font->Size;
                RTFPreview->Color = FontDialogComment->BackColor;
                break;
        case 3:
                TForm1::TColorToRGB(FontDialogLD->Font->Color, vsColorRed, vsColorGreen, vsColorBlue);
                TForm1::TColorToRGB(ColorDialogVerseNum->Color, numColorRed, numColorGreen, numColorBlue);
                strcpy(font, FontDialogLD->Font->Name.c_str());
                fontSize =  FontDialogLD->Font->Size;
                RTFPreview->Color = FontDialogLD->BackColor;
                break;
        default:
                TForm1::TColorToRGB(FontDialogText->Font->Color, vsColorRed, vsColorGreen, vsColorBlue);
                TForm1::TColorToRGB(ColorDialogVerseNum->Color, numColorRed, numColorGreen, numColorBlue);
                strcpy(font, FontDialogText->Font->Name.c_str());
                fontSize =  FontDialogText->Font->Size;
                RTFPreview->Color = FontDialogText->BackColor;
        }

        // This is a strange way to deal with font size but I can't think of a different way to do it.
        // So for now I will use the current system.
        fontSize -= 12;
        sprintf(buffTemp, "{\\fonttbl{\\f0\\fdecor\\fprq2 %s;}}" , font);
        strcat(buffFinal, buffTemp);
        sprintf(buffTemp, "{\\colortbl;\\red%d\\green%d\\blue%d;\\red%d\\green%d\\blue%d;}" , vsColorRed, vsColorGreen, vsColorBlue,  numColorRed, numColorGreen, numColorBlue);
        strcat(buffFinal, buffTemp);

        sprintf(buffTemp, "\\pard \\qc\\nowidctlpar{\\f1\\fs%d\\cf1\\b Chapter 1 ", (30 + fontSize));
        strcat(buffFinal, buffTemp);
        sprintf(buffTemp, "\\par\\fs%d\\par}", (10 + fontSize));
        strcat(buffFinal, buffTemp);

        sprintf(buffTemp, "{\\fs%d\\cf2\\super 19}", (10 + fontSize));
        strcat(buffFinal, buffTemp);

        sprintf(buffTemp, "\\ql\\nowidctlpar \\cf1\\f0\\fs%d ", (24 + fontSize));
        strcat(buffFinal, buffTemp);
        strcat(buffFinal, verse);

        strcat(buffFinal, " }");

        RTFStream->WriteBuffer(buffFinal, 512);
	RTFStream->Position = 0;
        RTFPreview->Lines->LoadFromStream(RTFStream);
}

TOptionsfrm::CopyFontDlg(TFontSelFrm* lhs, const TFontSelFrm* rhs)
{
	lhs->BackColor = rhs->BackColor;
     lhs->Font->Color = rhs->Font->Color;
     lhs->Font->Size = rhs->Font->Size;
     lhs->Font->Name = rhs->Font->Name;
}

void __fastcall TOptionsfrm::btnSaveScheme(TObject *Sender)
{
  TPoint menup, point;
  point.x = 0;
  point.y = btnSave->Height;
  menup = btnSave->ClientToScreen(point);
  SavePopup->Popup(menup.x, menup.y);
}
//---------------------------------------------------------------------------

void __fastcall TOptionsfrm::SaveSchemeClick(TObject *Sender)
{

	ConfigEntMap emap;
     AnsiString strName = Optionsfrm->cmbSchemeSelect->Text;
     if(strName != "" 	&& !strName.Pos("/") 	&& !strName.Pos("\\")
     				&& !strName.Pos(":") 	&& !strName.Pos("*")
                         && !strName.Pos("?")	&& !strName.Pos("\"")
                         && !strName.Pos("<")	&& !strName.Pos(">")
                         && !strName.Pos("|")) {
                         
     	AnsiString strName =  COLOR_DIR + Optionsfrm->cmbSchemeSelect->Text + COLOR_EXT;
     	SWConfig schemeconf(strName.c_str());

		emap = schemeconf.Sections["Appearance"];
		emap.erase("AutoVSColor"); emap.insert(ConfigEntMap::value_type("AutoVSColor", IntToStr((Optionsfrm->AutoVSColor->Checked)?1:0).c_str()));
		emap.erase("CurrentVSColor"); emap.insert(ConfigEntMap::value_type("CurrentVSColor", IntToStr(Optionsfrm->CurrentVSColor->Brush->Color).c_str()));

		emap.erase("VSNumberColor"); emap.insert(ConfigEntMap::value_type("VSNumberColor", IntToStr(Optionsfrm->ColorDialogVerseNum->Color).c_str()));

		emap.erase("TextBackColor"); emap.insert(ConfigEntMap::value_type("TextBackColor", IntToStr(Optionsfrm->FontDialogText->BackColor).c_str()));
		emap.erase("CommentBackColor"); emap.insert(ConfigEntMap::value_type("CommentBackColor", IntToStr(Optionsfrm->FontDialogComment->BackColor).c_str()));
		emap.erase("LDBackColor"); emap.insert(ConfigEntMap::value_type("LDBackColor", IntToStr(Optionsfrm->FontDialogLD->BackColor).c_str()));

		emap.erase("TextFontName"); emap.insert(ConfigEntMap::value_type("TextFontName", (Optionsfrm->FontDialogText->Font->Name).c_str()));
		emap.erase("CommentFontName"); emap.insert(ConfigEntMap::value_type("CommentFontName", (Optionsfrm->FontDialogComment->Font->Name).c_str()));
		emap.erase("LDFontName"); emap.insert(ConfigEntMap::value_type("LDFontName", (Optionsfrm->FontDialogLD->Font->Name).c_str()));

		emap.erase("TextFontSize"); emap.insert(ConfigEntMap::value_type("TextFontSize", IntToStr(Optionsfrm->FontDialogText->Font->Size).c_str()));
		emap.erase("CommentFontSize"); emap.insert(ConfigEntMap::value_type("CommentFontSize", IntToStr(Optionsfrm->FontDialogComment->Font->Size).c_str()));
		emap.erase("LDFontSize"); emap.insert(ConfigEntMap::value_type("LDFontSize", IntToStr(Optionsfrm->FontDialogLD->Font->Size).c_str()));

		emap.erase("TextFontColor"); emap.insert(ConfigEntMap::value_type("TextFontColor", IntToStr(Optionsfrm->FontDialogText->Font->Color).c_str()));
		emap.erase("CommentFontColor"); emap.insert(ConfigEntMap::value_type("CommentFontColor", IntToStr(Optionsfrm->FontDialogComment->Font->Color).c_str()));
		emap.erase("LDFontColor"); emap.insert(ConfigEntMap::value_type("LDFontColor", IntToStr(Optionsfrm->FontDialogLD->Font->Color).c_str()));

		emap.erase("FieldColor"); emap.insert(ConfigEntMap::value_type("FieldColor", IntToStr(Optionsfrm->ColorDialogField->Color).c_str()));

		schemeconf.Sections["Appearance"] = emap;
     	schemeconf.Save();
     }else{
     	Application->MessageBox("Scheme name missing or invalid.","Oops", MB_OK);
     }
     SetCurrentDir(ExtractFilePath(Application->ExeName));
     FindSchemeNames();
}
//---------------------------------------------------------------------------


void TOptionsfrm::FindSchemeNames()
{
	DIR *dir;
	struct dirent *ent;
	string conffile;
    	AnsiString strName;
     AnsiString strPath = COLOR_DIR;

     TStringList *schemeNames = new TStringList;
     Optionsfrm->cmbSchemeSelect->Clear();

     if (access(strPath.c_str(), 0)) {		// directory does not exist
		_mkdir(strPath.c_str());
	}

 	if (dir = opendir(strPath.c_str())) {
		rewinddir(dir);
		while ((ent = readdir(dir))) {
	          if ((strcmp(ent->d_name, "."))&& (strcmp(ent->d_name, "..")) && !strcmp(ExtractFileExt(ent->d_name).c_str(), COLOR_EXT.c_str())) {
               strName = ent->d_name;
               schemeNames->Add(strName.SubString(1, strName.Length() - 4).c_str());
			}
		}
		closedir(dir);
          Optionsfrm->cmbSchemeSelect->Items = schemeNames;
	}
     delete schemeNames;
}

void __fastcall TOptionsfrm::ExportClick(TObject *Sender)
{
     AnsiString name = Optionsfrm->cmbSchemeSelect->Text;
	AnsiString newFileName;
    	AnsiString exName;
    	AnsiString subdir = ExtractFilePath(Application->ExeName) + COLOR_DIR;
     if(name != ""){
     	SaveSchDlg->FileName = name;
  		if(SaveSchDlg->Execute()){
        		exName = subdir + name + COLOR_EXT;
        		newFileName = SaveSchDlg->FileName.c_str();
	   		if(!CopyFileA(exName.c_str(), newFileName.c_str(),1))
	            	Application->MessageBox("Export Failed." , "Oops", MB_OK);
     	}
     }else{
       Application->MessageBox("No Scheme Selected to Export. Please Select a Scheme and Retry" , "Oops", MB_OK);
     }
	SetCurrentDir(ExtractFilePath(Application->ExeName));
}
//---------------------------------------------------------------------------

void __fastcall TOptionsfrm::ImportClick(TObject *Sender)
{
	AnsiString newFileName;
     AnsiString exName, newPath;
     AnsiString subdir = ExtractFilePath(Application->ExeName) + COLOR_DIR;
  	if(OpenSchDlg->Execute()){
        exName = OpenSchDlg->FileName.c_str();
        newFileName = ExtractFileName(exName);
        newPath = subdir + newFileName;
	   if(!CopyFileA(exName.c_str(), newPath.c_str(),1))
            MessageBox(this, "Import Failed." , "Oops", MB_OK);
     }
     SetCurrentDir(ExtractFilePath(Application->ExeName));
     FindSchemeNames();
}
//---------------------------------------------------------------------------

void __fastcall TOptionsfrm::DeleteClick(TObject *Sender)
{
 	AnsiString name = Optionsfrm->cmbSchemeSelect->Text;
    	AnsiString fullName = ExtractFilePath(Application->ExeName) + COLOR_DIR + name + COLOR_EXT;
     if(name != ""){
       DeleteFile(fullName);
     }else{
       Application->MessageBox("No Scheme Selected to Delete. Please Select a Scheme and Retry" , "Oops", MB_OK);
     }
     SetCurrentDir(ExtractFilePath(Application->ExeName));
     FindSchemeNames();
}
//---------------------------------------------------------------------------

