#!/usr/local/bin/perl
# index.cgi
# Display a list of run-levels and the actions that are run at boot and
# shutdown time for each level

require './inittab-lib.pl';
&header( $text{'inittab_title'}, "", "index", 1, 1, 0,
	&help_search_link("inittab", "man"));
%access = &get_module_acl();

print(
"<p><hr><p><table border width=\"100%\">",
  "<tr ", $tb, ">",
	"<td><b>", &hlink( $text{ 'inittab_id' }, "id" ), "</b></td>",
	"<td><b>", &hlink( $text{ 'inittab_runlevels' }, "runlevels" ), "</b></td>",
	"<td><b>", &hlink( $text{ 'inittab_action' }, "action" ), "</b></td>",
	"<td><b>", &hlink( $text{ 'inittab_process' }, "process" ), "</b></td>",
  "</tr>" );

open( INITTAB, $config{ 'inittab_file' } );
while($line = <INITTAB>)
{
  $line =~ s/\r|\n//g;
  $line =~ s/#.*$//g;
  $line =~ s/\/\/.*$//g;

  if($line)
  {
	while($line =~ /\\$/)
	{
		local $nl = <INITTAB>;
		$line =~ s/\\$//;
		$nl =~ s/^\s+//;
		$line .= $nl;
	}
	local ( $id, $raw_runlevels, $action, $process ) = split( /:/, $line );
	local $runlevels = "";
	$process = $text{ 'inittab_none' } if( !$process );
    if( $raw_runlevels )
	{
	  foreach $runlevel ( split( //, $raw_runlevels ) )
	  {
		    $runlevels .= $runlevel. ", ";
	  }
	  chop( $runlevels ); chop( $runlevels );
	} else {
	  $runlevels = $text{ 'inittab_none' };
	}

	$action = "kbdrequest" if ($action eq "kbrequest");
	$action = "inittab_". $action;
	print(
  "<tr ", $cb, ">",
	"<td><a href=\"edit_inittab.cgi?id=", $id, "\">",
		&html_escape($id), "</a></td>",
	"<td>", &html_escape($runlevels), "</td>",
	"<td>", $text{ $action }, "</td>",
	"<td>", &html_escape($process), "</td>",
  "</tr>" );
  }
}
print(
"</table>",
"<a href=new_inittab.cgi>", $text{ 'inittab_new' }, "</a><p>" );

print "<hr>\n";
print "<table width=100%><tr>\n";
print "<form action=apply.cgi>\n";
print "<td><input type=submit value='$text{'inittab_apply'}'></td>\n";
print "<td>$text{'inittab_applymsg'}</td>\n";
print "</form></tr></table><br>\n";

print "<hr>\n";
&footer( "/", $text{'index'} );

