#!/usr/local/bin/perl
# view_data.cgi
# Display all data in some table

require './postgresql-lib.pl';
&ReadParse();
&can_edit_db($in{'db'}) || &error($text{'dbase_ecannot'});
@str = &table_structure($in{'db'}, $in{'table'});

if ($in{'delete'}) {
	# Deleting selected rows
	$count = 0;
	foreach $r (split(/\0/, $in{'row'})) {
		&execute_sql_logged($in{'db'},
				    "delete from $in{'table'} where oid = $r");
		$count++;
		}
	&webmin_log("delete", "data", $count, \%in);
	&redirect("view_table.cgi?db=$in{'db'}&".
		  "table=$in{'table'}&start=$in{'start'}");
	}
elsif ($in{'save'}) {
	# Update edited rows
	$count = 0;
	foreach $r (split(/\0/, $in{'row'})) {
		local @set;
		foreach $t (@str) {
			local $ij = $in{"${r}_$t->{'field'}"};
			$ij =~ s/'/''/g;
			if ($ij eq '') {
				push(@set, "$t->{'field'} = NULL");
				}
			else {
				push(@set, "$t->{'field'} = '$ij'");
				}
			}
		&execute_sql_logged($in{'db'}, "update $in{'table'} set ".
			            join(" , ", @set)." where oid = $r");
		$count++;
		}
	&webmin_log("modify", "data", $count, \%in);
	&redirect("view_table.cgi?db=$in{'db'}&".
		  "table=$in{'table'}&start=$in{'start'}");
	}
elsif ($in{'savenew'}) {
	# Adding a new row
	for($j=0; defined($in{$j}); $j++) {
		$in{$j} =~ s/'/''/g;
		push(@set, $in{$j} eq '' ? 'NULL' : "'$in{$j}'");
		}
	&execute_sql_logged($in{'db'}, "insert into $in{'table'} values (".
			    join(" , ", @set).")");
	&redirect("view_table.cgi?db=$in{'db'}&".
		  "table=$in{'table'}&start=$in{'start'}");
	&webmin_log("create", "data", undef, \%in);
	}
elsif ($in{'cancel'} || $in{'new'}) {
	undef($in{'row'});
	}

&header($text{'view_title'}, "", "view_table");
print "<center><font size=+2>",&text('table_header', "<tt>$in{'table'}</tt>",
				     "<tt>$in{'db'}</tt>"),"</font></center>\n";
print "<hr><p>\n";

$d = &execute_sql($in{'db'}, "select count(*) from $in{'table'}");
$total = $d->{'data'}->[0]->[0];
$in{'start'} = int($in{'start'});
if ($in{'new'} && $total > $config{'perpage'}) {
	# go to the last screen for adding a row
	$in{'start'} = $total - $config{'perpage'};
	$in{'start'} = int(($in{'start'} / $config{'perpage'}) + 1) *
		       $config{'perpage'};
	}
if ($in{'start'} || $total > $config{'perpage'}) {
	print "<center>\n";
	if ($in{'start'}) {
		printf "<a href='view_table.cgi?db=%s&table=%s&start=%s'>".
		       "<img src=/images/left.gif border=0 align=middle></a>\n",
			$in{'db'}, $in{'table'},
			$in{'start'} - $config{'perpage'};
		}
	print "<font size=+1>",&text('view_pos', $in{'start'}+1,
	      $in{'start'}+$config{'perpage'} > $total ? $total :
	      $in{'start'}+$config{'perpage'}, $total),"</font>\n";
	if ($in{'start'}+$config{'perpage'} < $total) {
		printf "<a href='view_table.cgi?db=%s&table=%s&start=%s'>".
		      "<img src=/images/right.gif border=0 align=middle></a>\n",
			$in{'db'}, $in{'table'},
			$in{'start'} + $config{'perpage'};
		}
	print "</center>\n";
	}

print "<form action=view_table.cgi method=post>\n";
print "<input type=hidden name=db value='$in{'db'}'>\n";
print "<input type=hidden name=table value='$in{'table'}'>\n";
print "<input type=hidden name=start value='$in{'start'}'>\n";
$check = !defined($in{'row'}) && !$in{'new'};
if ($total || $in{'new'}) {
	$d = &execute_sql($in{'db'}, "select oid,* from $in{'table'} limit ".
				     "$config{'perpage'} offset $in{'start'}");
	@data = @{$d->{'data'}};
	@titles = @{$d->{'titles'}}; shift(@titles);

	print "<table border width=100%>\n";
	print "<tr $tb>\n";
	print "<td>&nbsp;</td>\n" if ($check);
	foreach $t (@str) {
		print "<td><b>$t->{'field'}</b></td>\n";
		}
	print "</tr>\n";

	map { $row{$_}++ } split(/\0/, $in{'row'});
	$w = int(100 / scalar(@str));
	$w = 10 if ($w < 10);
	for($i=0; $i<@data; $i++) {
		local @d = @{$data[$i]};
		local $oid = shift(@d);
		print "<tr $cb>\n";
		if ($row{$oid}) {
			for($j=0; $j<@d; $j++) {
				$d[$j] =~ s/"/&quot;/g;
				printf "<td width=$w%%><input name=${oid}_$titles[$j] size=$w value=\"$d[$j]\"></td>\n";
				}
			print "<input type=hidden name=row value=$oid>\n";
			}
		else {
			print "<td><input type=checkbox name=row ",
			      "value=$oid></td>\n" if ($check);
			foreach $c (@d) {
				printf "<td width=$w%%>%s</td>\n",
					$c =~ /\S/ ? &html_escape($c) : "<br>";
				}
			}
		print "</tr>\n";
		}
	if ($in{'new'}) {
		print "<tr $cb>\n";
		for($j=0; $j<@str; $j++) {
			print "<td width=$w%><input name=$j size=$w></td>\n";
			}
		print "</tr>\n";
		}
	print "</table>\n";
	if ($check) {
		print "<a href='' onClick='document.forms[0].row.checked = true; for(i=0; i<document.forms[0].row.length; i++) { document.forms[0].row[i].checked = true; } return false'>$text{'view_all'}</a>&nbsp;\n";
		print "<a href='' onClick='document.forms[0].row.checked = !document.forms[0].row.checked; for(i=0; i<document.forms[0].row.length; i++) { document.forms[0].row[i].checked = !document.forms[0].row[i].checked; } return false'>$text{'view_invert'}</a><br>\n";
		}
	}
else {
	print "<b>$text{'view_none'}</b> <p>\n";
	}

print "<table width=100%><tr>\n";
if (!$check) {
	if ($in{'new'}) {
		print "<td><input type=submit name=savenew ",
		      "value='$text{'save'}'></td>\n";
		}
	else {
		print "<td><input type=submit name=save ",
		      "value='$text{'save'}'></td>\n";
		}
	print "<td align=right><input type=submit name=cancel ",
	      "value='$text{'cancel'}'></td>\n";
	}
else {
	print "<td><input type=submit name=edit ",
	      "value='$text{'view_edit'}'></td>\n";
	print "<td align=middle><input type=submit name=new ",
	      "value='$text{'view_new'}'></td>\n";
	print "<td align=right><input type=submit name=delete ",
	      "value='$text{'view_delete'}'></td>\n";
	}
print "</tr></table></form>\n";

print "<hr>\n";
&footer("edit_table.cgi?db=$in{'db'}&table=$in{'table'}",$text{'table_return'});

