#!/usr/local/bin/perl
# edit_upgrade.cgi
# Display a form for upgrading all of webmin from a tarfile

require './webmin-lib.pl';
&header($text{'upgrade_title'}, "");
print "<hr>\n";

# what kind of install was this?
if (open(MODE, "../install-type")) {
	chop($mode = <MODE>);
	close(MODE);
	}
else {
	chop($pwd = `cd .. ; pwd`);
	if ($pwd eq "/usr/libexec/webmin") {
		$mode = "rpm";
		}
	elsif ($pwd eq "/opt/webmin") {
		$mode = "solaris-pkg";
		}
	else {
		$mode = undef;
		}
	}

if ($mode eq "solaris-pkg") {
	print "<p>$text{'upgrade_esolaris'}<p>\n";
	print "<hr>\n";
	&footer("", $text{'index_return'});
	exit;
	}

print "<table width=100%><tr><td valign=top>\n";
print $text{"upgrade_desc$mode"},"</td><td valign=top>";

print "<form action=upgrade.cgi method=post enctype=multipart/form-data>\n";
print "<input type=hidden name=mode value='$mode'>\n";
print "<table border>\n";
print "<tr $tb> <td><b>$text{'upgrade_title'}</b></td> </tr>\n";
print "<tr $cb> <td nowrap>\n";
print "<input type=radio name=source value=0 checked> $text{'upgrade_local'}\n";
print "<input name=file size=40>\n";
print &file_chooser_button("file", 0),"<br>\n";
print "<input type=radio name=source value=1> $text{'upgrade_uploaded'}\n";
print "<input name=upload type=file size=30><br>\n";
if ($mode eq 'caldera') {
	print "<input type=radio name=source value=3> $text{'upgrade_cup'}\n";
	}
else {
	print "<input type=radio name=source value=2> $text{'upgrade_ftp'}\n";
	}
print "</td></tr></table><br>\n";
print "<input type=submit value=\"$text{'upgrade_ok'}\">\n";
print "</form></td></tr></table>\n";

print "<hr>\n";

print "<table width=100%>\n";
print "<tr> <td valign=top>$text{'update_desc1'}</td>\n";
print "<td><form action=update.cgi>\n";
print "<table border>\n";
print "<tr $tb> <td><b>$text{'update_header1'}</b></td> </tr>\n";
print "<tr $cb> <td nowrap>\n";

printf "<input type=radio name=source value=0 %s> %s<br>\n",
	$config{'upsource'} ? "" : "checked", $text{'update_webmin'};
printf "<input type=radio name=source value=1 %s> %s\n",
	$config{'upsource'} ? "checked" : "", $text{'update_other'};
printf "<input name=other size=30 value='%s'><br>\n",
	$config{'upsource'};

printf "<input type=checkbox name=show value=1 %s> %s<br>\n",
	$config{'upshow'} ? "checked" : "", $text{'update_show'};
printf "<input type=checkbox name=missing value=1 %s> %s<br>\n",
	$config{'upmissing'} ? "checked" : "", $text{'update_missing'};
print "</td></tr></table><br>\n";
print "<input type=submit value=\"$text{'update_ok'}\">\n";
print "</form></td></tr></table>\n";

print "<hr>\n";

print "<table width=100%>\n";
print "<tr> <td valign=top>$text{'update_desc2'}</td>\n";
print "<td><form action=update_sched.cgi>\n";
print "<table border>\n";
print "<tr $tb> <td><b>$text{'update_header2'}</b></td> </tr>\n";
print "<tr $cb> <td nowrap>\n";
printf "<input type=checkbox name=enabled value=1 %s> %s<p>\n",
	$config{'update'} ? 'checked' : '', $text{'update_enabled'};
	
printf "<input type=radio name=source value=0 %s> %s<br>\n",
	$config{'upsource'} ? "" : "checked", $text{'update_webmin'};
printf "<input type=radio name=source value=1 %s> %s\n",
	$config{'upsource'} ? "checked" : "", $text{'update_other'};
printf "<input name=other size=30 value='%s'><br>\n",
	$config{'upsource'};

print &text('update_sched',
	    "<input name=hour size=2 value='$config{'uphour'}'>",
	    "<input name=days size=3 value='$config{'updays'}'>"),"<br>\n";

printf "<input type=checkbox name=show value=1 %s> %s<br>\n",
      $config{'upshow'} ? 'checked' : '', $text{'update_show'};
printf "<input type=checkbox name=missing value=1 %s> %s<br>\n",
      $config{'upmissing'} ? 'checked' : '', $text{'update_missing'};
printf "<input type=checkbox name=quiet value=1 %s> %s<br>\n",
      $config{'upquiet'} ? 'checked' : '', $text{'update_quiet'};
printf "%s <input name=email size=30 value='%s'><br>\n",
	$text{'update_email'}, $config{'upemail'};

print "</td></tr></table><br>\n";
print "<input type=submit value=\"$text{'update_apply'}\">\n";
print "</form></td></tr></table>\n";

print "<hr>\n";
&footer("", $text{'index_return'});

