.\"	$Id: af.man,v 1.27 1997/04/20 10:30:28 malc Exp $
.TH AF %SEC1%
.SH NAME
af \- emacs-like mail reader.
.SH SYNOPSIS
.B af
[
.B -envwzEFH
] [
.BR -f " folder"
] [
.BR -u " user"
] [
.BR -l " loadfile"
] [
.BR -s " subject"
] [
.BR -S " scriptfile"
] [ destination ... ]
.SH DESCRIPTION
.I Af\^
is a screen-oriented electronic mail reader and composer.  The
interface is designed to be quite similar to that of the \fIEmacs\fP
screen editor, with lines on the display representing mail messages.
By default, \fIaf\fP will read your \fIincoming mailbox\fP, and then
wait for commands.  For more detail on using \fIaf\fP interactively,
see the Af User Manual.
.PP
If you specify \fIdestination\fPs on the command line, \fIaf\fP will
allow you to compose and send mail to the specified destinations, just
as if you had executed the command \fIsend-mail\fP from within af.
Once the message has been sent (or if you abort the message), then
\fIaf\fP exits.
.PP
Other arguments are options influencing the behaviour
of \fIaf\fP.
.SH OPTIONS
The
.B -v
(version) option makes \fIaf\fP print its version information to
standard output and then quit, regardless of any other arguments.
.PP
The
.B -e
(exists) option makes \fIaf\fP check whether there is mail in your
default mailbox (or, if \fB-f\fP or \fB-u\fP are given, any specified
folders) and then exit.  The exit status is zero if there is mail in
any of the folders; one if not.
.br
This option is ignored if destinations were specified.
.PP
The
.B -z
(zero) option makes \fIaf\fP terminate immediately with an exit status
of 1 if your default mailbox (or, if \fB-f\fP or \fB-u\fP is given,
any specified folders) is empty.  Otherwise, af will start up
normally.
.br
This option is ignored if destinations were specified.
.PP
The
.B -n
(no startup file) option makes \fIaf\fP ignore the file \fI.afrc\fP in
the user's home directory.
.PP
The
.B -E
(edit and deliver) option forces \fIaf\fP to send a single mail
message, asking for the destinations if not given on the command line.
If the if the text of the message to be sent is being read from the
standard input, then the text is gathered into a temporary file and
\fIaf\fP then asks for destinations and subject (if it has not already
read them from the message's text), editing the file and asking for
disposition.  This is mainly useful when \fIaf\fP is being called by
other programs or is at the receiving end of a pipeline of commands;
you'll very rarely need it, but when you do, it's invaluable.
.PP
The
.B -H
(headers anyway) option forces \fIaf\fP to present the user with the
headers of an outgoing message when editing it, or to force
translation of headers in mail sent from the standard input.  In
effect, it causes \fIaf\fP's \fBedit-initial-headers\fP variable to be
set to \fBtrue\fP regardless of the contents of the user's \fI.afrc\fP
file.
.PP
Multiple occurrences of \fB-e\fP, \fB-z\fP, \fB-E\fP, or \fB-H\fP act
as only one occurrence of the option; if given together, \fB-e\fP
takes precedence over \fB-z\fP.  It's not clear why anyone should ever
wish to do these things, but now you know.
.PP
The
.BI -f " folder"
(file or folder) option specifies the folder to be read instead of
your default mailbox.  Multiple \fB-f\fP options may be given.
\fB-f\fP and \fB-u\fP may be intermixed.  More than one \fB-f\fP or
\fB-u\fP causes each named folder to be read into its own buffer.
.br
This option is ignored if destinations were specified.
.PP
The
.BI -u " user"
(user) option specifies that \fIuser\fP's incoming mailbox is to be
read instead of your own.  You must have any necessary access
permissions to read the mailbox.  Multiple \fB-u\fP options may be
given.  \fB-u\fP and \fB-f\fP may be intermixed.  More than one
\fB-u\fP or \fB-f\fP causes each named file to be read into its own
buffer.
.br
This option is ignored if destinations were specified.
.PP
The
.B -F
(all files or folders) option tells af to treat any arguments as folders
to be read rather than destinations to send mail.  This can be convenient
when you want load several folders at once into af.
.PP
The
.B -w
(windows) option makes \fIaf\fP create enough windows to display all
the folders specified with the -f, -u or -F, options, subject to the
maximum number of windows that will fit on the screen (usually
about four or five).
.br
This option is ignored if destinations were specified.
.PP
The
.BI -l " loadfile"
(loadfile) option specifies a file of af commands which should be read
and executed on startup before any buffers are created.  Used with the
\fB-n\fP option, this allows the user to specify an alternate startup
file, rather than the default of \fI.afrc\fP in their home directory.
See the Af User Manual for details on startup files.
.PP
The
.BI -s " subject"
(subject) option specifies the Subject: for an outgoing message.  Only
one \fB-s\fP option may be given.
.br
This option is ignored if destinations were not specified.
.PP
The
.BI -S " file"
(script) option names a file of commands in \fIaf\fP's internal
language \fIafl\fP.  The commands in the file are read and executed
exactly as if \fIaf\fP had been started up interactively and then the
af command \fIload-file\fP had been executed.  When all the \fIafl\fP
commands in \fIfile\fP have been executed, or if an error is
encountered in the file, then \fIaf\fP terminates.  If the \fB-S\fP
option is given, then \fIaf\fP will not display the screen; only
messages will be printed to the standard output.
.br
Only one \fB-S\fP option may be given, it is ignored if
destinations were specified.
.SH "FINDING OUT MORE"
The definitive reference for \fIaf\fP is the Af Reference Manual,
which is available in \fItexinfo\fP and \fIinfo\fP, forms with
the \fIaf\fP distribution.
.PP
More convenient is the Af Quick Reference Card, which gives a very
condensed summary of \fIaf\fP commands, variables, and options.
The LaTeX sources for the reference card are available as part of
the \fIaf\fP distribution.
.PP
More immediately useful for exploring \fIaf\fP is \fIaf\fP's internal
help system, which can be accessed by entering \fIaf\fP and typing
\fBC-h\fP (control-H).  The first command you'll probably want to use
is \fBC-h C-i\fP (control-H followed by control-I), which will allow
you to browse the af user manual.
.SH FILES
.PD 0
.TP
/usr/spool/mail/\fIuser\fP (or similar)
incoming mail for \fIuser\fP;
the
\fIincoming mailfile\fP
.TP
$HOME/.signature
default signature file
.TP
$HOME/dead.letter
repository for unsent mail read from standard input
.TP
$HOME/.afrc
personal startup file
.TP
%ETCDIR%/afrc
global startup file
.TP
$HOME/.afalias
personal alias file
.TP
%ETCDIR%/afalias
global alias file
.TP
%LIBDIR%/af.help
help file
.TP
%LIBDIR%/readmbox
program to read mailboxes
.TP
%LIBDIR%/writembox
program to write mailboxes
.TP
/tmp/aftmp\(**
temporary file used when editing
.PD
.SH ENVIRONMENT
.PD 0
.TP
SHELL
.br
Shell to run as an inferior shell
.TP
VISUAL, EDITOR
.br
editor for outgoing mail
.TP
PAGER
.br
program to page text
.TP
MAIL
.br
location of your incoming mailbox
.TP
FOLDER
.br
directory for your folders
.TP
SAVEDIR
directory for your news folders
.TP
HOME
.br
your home directory
.TP
NAME
.br
your real name
.TP
ORGANIZATION
.br
your organisational affiliation
.TP
TMPDIR
.br
directory for temporary files
.PD
.SH "EXIT STATUS"
.I Af
exits with status zero indicating that all is well; status one for
unusual but not strictly incorrect happenings; and status two for
things that are just plain wrong.
.SH AUTHOR
.I Af
was written by Malc Arnold, with assistance from Kay Dekker
and Ian Dickinson.
.SH SEE ALSO
afack(%SEC1%), afalias(%SEC5%) ``The Af User Manual''.
.SH BUGS
Running out of memory causes ungraceful termination.
