/*
 **************************************************************************
 *
 * Boot-ROM-Code to load an operating system across a TCP/IP network.
 *
 * Module:  bootpriv.h
 * Purpose: Miscellaeous definitions for the boot loader routines
 * Entries: none
 *
 **************************************************************************
 *
 * Copyright (C) 1995,1996 Gero Kuhlmann <gero@gkminix.han.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


/*
 **************************************************************************
 *
 * External routines:
 */

/* Determine amount of conventional memory */
extern unsigned long convmem(void);

/* Determine amount of extended memory */
extern unsigned long extmem(void);

/* Copy memory block to address given as long word */
extern void lmove(unsigned long dest, void *src, int len);

/* Call boot image */
extern void exec_image(int mode, void far *exec, void far *head,
							void far *param);
/* Load a bootblock from disk */
extern int loaddisk(unsigned char *name, unsigned short loadseg);

