.TH DXPC 1 "February 27, 1997" "dxpc"
.ad b
.SH NAME
dxpc \- Differential X Protocol Compressor

.SH RELEASE
3.5.0

.SH SYNOPSIS

\fBServer Proxy mode:\fR
.br
.BR dxpc
[-s(1|2)]
[-p portnumber]
[-f|-k]
[-l filename]
[-w|clienthostname]
.br
.LP
\fBClient Proxy mode:\fR
.br
.BR dxpc
[-s(1|2)]
[-p portnumber]
[-d displaynum]
[-u]
[-t]
[-f|-k]
[-l filename]
[-w serverhostname]


.SH DESCRIPTION
\fBdxpc\fR is an X protocol compressor designed to improve the
speed of X11 applications run over low-bandwidth links (such as dialup
PPP connections).
.sp
dxpc must be run at both ends of a low-bandwidth link.  On the host
where the real X server is, dxpc runs in "Server Proxy" mode.  On the
host at the other end of the link, dxpc runs in "Client Proxy" mode.
The Client Proxy dxpc must be started first.  When the Server Proxy
dxpc is started, it connects to the Client Proxy.  (Note that versions
of dxpc before 3.3.1 used the opposite convention.)  If either of the
two communicating dxpc instances is subsequently terminated, the other
one automatically shuts down.
.sp
The Client Proxy mimics an X server.  X client applications connect
to the Client Proxy using display "unix:8" (or "<hostname>:8"; dxpc
supports both UNIX domain and TCP sockets).  The Client Proxy receives
X requests from the application, compresses them, and sends them to
the Server Proxy.  The Server Proxy uncompresses the requests and
sends them to the real X server.  Similarly, the Server Proxy receives
X events, replies, and errors from the real X server.  It compresses
these messages and sends them to the Client Proxy, which uncompresses
them and sends them to the client application.
.sp
The compression performance of dxpc depends upon the types of X applications
being run.  For many applications, dxpc achieves between 3:1 and 6:1
compression of the X protocol traffic.
.sp
.SH Options
.TP 12
.B -d \fIdisplaynum\fR
This option specifies the number of the X display that dxpc imitates.
The default value is 8.  (This option is ignored in Server Proxy mode.)

.TP 12
.B -f
This option tells dxpc to fork and run as a daemon process.  All subsequent
non-error output is suppressed, including statistics reports.  The daemon
can be killed by use of the \fB-k\fR option.

.TP 12
.B -k
This option tells dxpc to read a pid from the lockfile in the user's home
directory and then send a SIGKILL to the old process.  It does some error
checking to try to ensure that the file contains a valid pid file (and
nothing else).  The pidfile will exist only if dxpc was started with the
\fB-f\fR option.

.TP 12
.B -l
This option is used to tell dxpc to write messages and statistics to a
logfile.  Very useful with the \fB-f\fR option.

.TP 12
.B -p \fIportnumber\fR
This option specifies the TCP port number to be used for communication between
the Client Proxy and the Server Proxy.  The default value is 4000.

.TP 12
.B -s(1|2)
Print a report on dxpc's compression performance for an X application when
the application exits.  In Client Proxy mode, dxpc displays a report on the
compression of messages generated by the X client.  In Server Proxy mode,
dxpc displays a report on the compression of messages generated by the X
server.  The \fB-s1\fR option yields a simple report that provides the
overall compression ratio.  The \fB-s2\fR option yields a far more detailed
report on the compression ratios achieved for all the individual message
types in the X protocol.  The \fB-s2\fR option is the "hacker option"; most
people will probably want the \fB-s1\fR report instead.

.TP 12
.B "-u -t"
Normally, dxpc in Client Proxy mode imitates an X display, :8 by default,
by listening on both a UNIX domain socket and a TCP socket.  The \fB-u\fR
option tells it not to use the UNIX domain port, and the \fB-t\fR option
tells it not to use the TCP port.  (These options are ignored in Server
Proxy mode.)

.TP 12
.B "-v"
This option tells dxpc to print out its version number and copyright
message and exit.

.TP 12
.B -w
Use of this option swaps the connection sequence.  That is, the client will
initiate the connection to the server.  Thus, instead of starting the
client like \fBdxpc -f\fR and the server as \fBdxpc -f workserver\fR, you
can start the client as \fBdxpc -w -f homepc\fR and the server as \fBdxpc
-w -f\fR.  This option is intended to be useful for people running the
client proxy on a machine behind a firewall.

.TP 12
.B \fIclienthostname\fR
This argument must be used in Server Proxy mode to tell dxpc the hostname or
IP address of the machine where other dxpc (the one in Client Proxy mode) is
running.  (Note that the presence of this argument is what puts dxpc in Server
Proxy mode.  If this argument is not used, dxpc runs in Client Proxy mode.)

.SH EXAMPLES
Assume that you're running a real X server on the console of a local
workstation called homepc, and that you want to run some X applications on
a remote system called workserver and have them display on the console of
the local system.
.sp
On workserver, run
.nf
	$ export DISPLAY=homepc:0
    $ dxpc -f
    $ export DISPLAY=unix:8
.fi

On homepc, run
.nf
    $ export DISPLAY=unix:0
    $ dxpc -f workserver
.fi

Now on workserver,
.nf
    $ xterm&
    $ xemacs&
    etc...
.fi

.SH "DXPC AND XAUTH"
If you use X authorization, with a .Xauthority file on the workstation
where your real X server runs, you'll need to set up a .Xauthority file
on the host where the ClientProxy runs.  One way to do this is:
.sp
Copy your ~/.Xauthority file from the host where the real X server
runs to the host where the Client Proxy runs.
.sp
Run
.nf
    xauth list
.fi
to see the authorization keys.  There should be one for your
real X display.  It will look something like this:
.nf
    <hostname>/unix:0   MIT-MAGIC-COOKIE-1   <hex string>
.fi
On the host where the Client Proxy is located, add a new entry to
the .Xauthority file with the display name of the fake X server (the
DISPLAY where the Client Proxy is listening) and all of the other
values from the entry for the real X display.  The xauth "add"
command can be used, like this:
.nf
    xauth add <hostname>/unix:8 MIT-MAGIC-COOKIE-1  <hex string>
.fi
where <hostname> is the name of the host where the Client Proxy is running
and <hex string> has the same value as the <hex string> obtained for
the real X display in step 2.  Once you do this, you should be
able to run X clients through dxpc successfully.

.SH AUTHOR
Brian Pane

.SH MAINTAINER
Zachary Vonler (lightborn@mail.utexas.edu)

.SH ACKNOWLEDGMENTS
\fBdxpc\fR has adopted many good ideas from the \fBHBX\fR and \fBFHBX\fR
systems (http://www.cs.dartmouth.edu/~jmd/decs/DECSpage.html).
.sp
Thanks to all of the users of dxpc who have contributed feedback and
suggestions.

.SH SEE ALSO
xauth(1), README file from dxpc distribution
