;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.8/Ast/length.scm           */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue Jan 10 08:48:39 1995                          */
;*    Last change :  Wed Oct 11 11:06:57 1995 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The ast length computation                                       */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module ast_length
   (include "Ast/node.sch")
   (import  tools_shape
	    ast_dump)
   (export  (ast-length ast)))

;*---------------------------------------------------------------------*/
;*    ast-length ...                                                   */
;*---------------------------------------------------------------------*/
(define (ast-length ast)
   (ast-case ast
      ((atom)
       1)
      ((var)
       1)
      ((kwote)
       1)
      ((make-box)
       (+fx 1 (ast-length (make-box-value ast))))
      ((box-ref)
       2)
      ((box-set!)
       (+fx 1 (+fx (ast-length (box-set!-var ast))
		   (ast-length (box-set!-value ast)))))
      ((sequence)
       (let loop ((exp (sequence-exp ast))
                  (res 0))
          (if (null? exp)
              res
              (loop (cdr exp) (+fx (ast-length (car exp)) res)))))
      ((setq)
       (+fx 2 (ast-length (setq-val ast))))
      ((conditional)
       (+fx 1 (+fx (ast-length (conditional-test ast))
                   (+fx (ast-length (conditional-then ast))
                        (ast-length (conditional-else ast))))))
      ((fail)
       (+fx 1 (+fx (ast-length (fail-proc ast))
                   (+fx (ast-length (fail-msg ast))
                        (ast-length (fail-obj ast))))))
      ((let-fun)
       (let loop ((len    (+fx 1 (ast-length (let-fun-body ast))))
                  (locals (let-fun-locals ast)))
          (if (null? locals)
              len
              (let ((l (car locals)))
                 (loop (+fx (+fx (length (function-args (local-value l)))
                                 (ast-length (function-body (local-value l))))
                            len)
                       (cdr locals))))))
      ((let-var)
       (let loop ((len  (+fx 1 (ast-length (let-var-body ast))))
                  (bdgs (let-var-bindings ast)))
          (if (null? bdgs)
              len
              (let ((b (car bdgs)))
                 (loop (+fx (ast-length (cdr b)) (+fx 1 len))
                       (cdr bdgs))))))
      ((app-ly)
       (+fx 1 (+fx (ast-length (app-ly-fun ast))
                   (ast-length (app-ly-value ast)))))
      ((app)
       (let loop ((len  1)
                  (args (app-actuals ast)))
          (if (null? args)
              len
              (loop (+fx (ast-length (car args)) len)
                    (cdr args)))))
      ((fun)
       1)
      ((funcall)
       (let loop ((len  (ast-length (funcall-fun ast)))
                  (args (funcall-actuals ast)))
          (if (null? args)
              len
              (loop (+fx (ast-length (car args)) len)
                    (cdr args)))))
      ((set-ex-it)
       (+fx 2 (ast-length (set-ex-it-body ast))))
      ((jump-ex-it)
       (+fx 1
	    (+fx (ast-length (jump-ex-it-exit ast))
		 (ast-length (jump-ex-it-value ast)))))
      ((switch)
       (let loop ((len     (+fx 1 (ast-length (switch-test ast))))
                  (clauses (switch-clauses ast)))
          (if (null? clauses)
              len
              (let ((c (car clauses)))
                 (loop (+fx (if (pair? (car c))
				(length (car c))
				0)
			    (+fx (ast-length (cdr c))
				 len))
                       (cdr clauses))))))
      ((prag-ma)
       (let loop ((values (prag-ma-values ast))
		  (len    2))
	  (if (null? values)
	      len
	      (loop (cdr values)
		    (+fx len (ast-length (car values)))))))))






