;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.8/Ast/node.sch             */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue Dec 27 11:02:52 1994                          */
;*    Last change :  Tue Feb  6 15:32:19 1996 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The ast-node structure                                           */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    directives                                                       */
;*---------------------------------------------------------------------*/
(directives
   (include "Ast/ast-tools.sch"
	    "Ast/ast.sch"))

;*---------------------------------------------------------------------*/
;*    ast-node                                                         */
;*---------------------------------------------------------------------*/
(define-ast ast
   ;; all structures inherit these slots
   (location type info)
   ;; atomic values
   (define-node atom
      value)
   ;; variabe (local and global) references
   (define-node var
      variable)
   ;; quotation
   (define-node kwote
      value
      cfa-info)
   ;; sequence of expressions
   (define-node sequence
      exp)
   ;; functional application
   (define-node app
      fun
      actuals
      cfa-info
      cfa-info-aux
      stack-info
      tvector-info)
   ;; apply construction
   (define-node app-ly
      fun
      value)
   ;; computed functional appliction
   (define-node funcall
      fun
      actuals
      strength)
   ;; functional values
   (define-node fun
      value)
   ;; pragma
   (define-node prag-ma
      string
      values)
   ;; affectation expressions
   (define-node setq
      var
      val)
   ;; conditionals
   (define-node conditional
      test
      then
      else)
   ;; failure
   (define-node fail
      proc
      msg
      obj)
   ;; switch construction
   (define-node switch
      test
      clauses)
   ;; labels constructions
   (define-node let-fun
      ;; locals is a list of <local> variables.
      locals    
      body)
   ;; let constructions
   (define-node let-var
      ;; bindings is a list of <pair> (Scheme conses) (<local> . <ast>).
      bindings
      body
      removable?)
   ;; set-exit construction
   (define-node set-ex-it
      exit
      body)
   ;; jump-exit construction
   (define-node jump-ex-it
      exit
      value)
   ;; make-box
   (define-node make-box
      value)
   ;; box-ref
   (define-node box-ref
      var)
   ;; box-set!
   (define-node box-set!
      var
      value))

