;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.8/Ast/substitute.scm       */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Fri Jan  6 11:09:14 1995                          */
;*    Last change :  Thu Jan 18 17:08:04 1996 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The substitution tools module                                    */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module ast_substitute
   (include "Ast/node.sch"
	    "Tools/trace.sch")
   (import  tools_shape
	    ast_dump)
   (export  (substitute! <quoi.par>* <ast>)))

;*---------------------------------------------------------------------*/
;*    substitute! ...                                                  */
;*    -------------------------------------------------------------    */
;*    Substitute can replace a variable by a variable or an atom       */
;*    (including `fun') construction but nothing else.                 */
;*---------------------------------------------------------------------*/
(define (substitute! quoi.par* ast)
   ;; we set alpha-fast slot 
   (for-each (lambda (q.p)
		(variable-fast-alpha-set! (car q.p) (cdr q.p)))
	     quoi.par*)
   (let ((res (do-substitute! ast)))
      ;; we remove alpha-fast slots
      (for-each (lambda (q.p)
		   (variable-fast-alpha-set! (car q.p) #f))
		quoi.par*)
      res))
   
;*---------------------------------------------------------------------*/
;*    do-substitute! ...                                               */
;*---------------------------------------------------------------------*/
(define (do-substitute! ast)
   (trace init "do-substitute!: " (ast->sexp ast) #\Newline)
   (ast-case ast
      ((atom)
       ast)
      ((var)
       (let* ((var   (var-variable ast))
	      (alpha (variable-fast-alpha var)))
	  (cond
	     ((not alpha)
	      ast)
	     ((var? alpha)
	      (variable-occurrence-set! var (-fx (variable-occurrence var) 1))
	      (let ((new (var-variable alpha)))
		 (variable-occurrence-set! new
					   (+fx (variable-occurrence new) 1))
		 alpha))
	     ((fun? alpha)
	      (variable-occurrence-set! var (-fx (variable-occurrence var) 1))
	      (let ((new (var-variable (fun-value alpha))))
		 (variable-occurrence-set! new
					   (+fx (variable-occurrence new) 1))
		 alpha))
	     ((atom? alpha)
	      (variable-occurrence-set! var (-fx (variable-occurrence var) 1))
	      alpha)
	     ((variable? alpha)
	      (variable-occurrence-set! var (-fx (variable-occurrence var) 1))
	      (variable-occurrence-set! alpha
					(+fx (variable-occurrence alpha) 1))
	      (ast-var (ast-location ast) #f (ast-info ast) alpha))
	     (else
	      (internal-error "duplicate"
			      "Illegal substitution"
			      (ast->sexp ast))))))
      ((box-ref)
       (box-ref-var-set! ast (do-substitute! (box-ref-var ast)))
       ast)
      ((box-set!)
       (box-set!-var-set! ast (do-substitute! (box-set!-var ast)))
       (box-set!-value-set! ast (do-substitute! (box-set!-value ast)))
       ast)
      ((make-box)
       (make-box-value-set! ast (do-substitute! (make-box-value ast)))
       ast)
      ((kwote)
       ast)
      ((sequence)
       (do-substitute*! (sequence-exp ast))
       ast)
      ((app)
       (app-fun-set! ast (do-substitute! (app-fun ast)))
       (do-substitute*! (app-actuals ast))
       ast)
      ((funcall)
       (funcall-fun-set! ast (do-substitute! (funcall-fun ast)))
       (do-substitute*! (funcall-actuals ast))
       ast)
      ((fun)
       (do-substitute! (fun-value ast))
       ast)
      ((prag-ma)
       (do-substitute*! (prag-ma-values ast))
       ast)
      ((setq)
       (setq-val-set! ast (do-substitute! (setq-val ast)))
       ast)
      ((conditional)
       (conditional-test-set! ast (do-substitute! (conditional-test ast)))
       (conditional-then-set! ast (do-substitute! (conditional-then ast)))
       (conditional-else-set! ast (do-substitute! (conditional-else ast)))
       ast)
      ((fail)
       (fail-proc-set! ast (do-substitute! (fail-proc ast)))
       (fail-msg-set! ast (do-substitute! (fail-msg ast)))
       (fail-obj-set! ast (do-substitute! (fail-obj ast)))
       ast)
      ((app-ly)
       (app-ly-fun-set! ast (do-substitute! (app-ly-fun ast)))
       (app-ly-value-set! ast (do-substitute! (app-ly-value ast)))
       ast)
      ((switch)
       (switch-test-set! ast (do-substitute! (switch-test ast)))
       (for-each (lambda (clause)
		    (set-cdr! clause (do-substitute! (cdr clause))))
		 (switch-clauses ast))
       ast)
      ((let-fun)
       (for-each (lambda (local)
		    (let ((fun (local-value local)))
		       (function-body-set! fun
					   (do-substitute!
					    (function-body fun)))))
		 (let-fun-locals ast))
       (let-fun-body-set! ast (do-substitute! (let-fun-body ast)))
       ast)
      ((set-ex-it)
       (set-ex-it-body-set! ast (do-substitute! (set-ex-it-body ast)))
       ast)
      ((jump-ex-it)
       (jump-ex-it-exit-set! ast (do-substitute! (jump-ex-it-exit ast)))
       (jump-ex-it-value-set! ast (do-substitute! (jump-ex-it-value ast)))
       ast)
      ((let-var)
       (for-each (lambda (binding)
		    (set-cdr! binding (do-substitute! (cdr binding))))
		 (let-var-bindings ast))
       (let-var-body-set! ast (do-substitute! (let-var-body ast)))
       ast)))

;*---------------------------------------------------------------------*/
;*    do-substitute*! ...                                              */
;*---------------------------------------------------------------------*/
(define (do-substitute*! ast*)
   (if (null? ast*)
       'done
       (begin
	  (set-car! ast* (do-substitute! (car ast*)))
	  (do-substitute*! (cdr ast*)))))
   
