;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.8/Cc/indent.scm            */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue Sep 15 15:49:56 1992                          */
;*    Last change :  Fri Apr  5 11:30:31 1996 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The indentation of the C file                                    */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module cc_indent
   (include "Tools/trace.sch")
   (export  (indent name))
   (import  tools_speek
	    engine_param))

;*---------------------------------------------------------------------*/
;*    indent ...                                                       */
;*---------------------------------------------------------------------*/
(define (indent name)
   (if (and (string? name)
	    (string? *indent*)
	    (>fx (string-length *indent*) 0))
       (begin
	  (verbose 1 "   . indent (" (basename *indent*) ")" #\Newline)
	  (let ((cmd (string-append *indent* " "
					    *indent-opt* " "
					    name ".c > "
					    name ".cc ")))
	     (verbose 2 "        " cmd #\Newline)
	     (let ((res (system cmd)))
		(if (not (=fx res 0))
		    (warning *indent* "Non nul value returned -- " res)))
	     (if (file-exists? (string-append name ".cc"))
		 (let ((sname (string-append name ".cc"))
		       (dname (string-append name ".c")))
		    (verbose 2 "        mv " sname " " dname #\Newline)
		    (rename-file sname dname)))))))
