;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.8/Cfa/approx.scm           */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue Feb 21 15:46:00 1995                          */
;*    Last change :  Wed Sep  6 09:52:38 1995 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The approximations manipulations.                                */
;*    -------------------------------------------------------------    */
;*    Here is a description of how we encode approximations:           */
;*                                                                     */
;*       - the type key is stored in the `type-info' slot              */
;*       - the alloc key is stored in the `app-cfa-info' slot          */
;*       - the approximations are stored in the slots                  */
;*            . ast-info (for the ast)                                 */
;*            . var-info (for the variable).                           */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module cfa_approx
   (include "Tools/trace.sch"
	    "Ast/node.sch"
	    "Type/type.sch"
	    "Cfa/approx.sch")
   (import  cfa_collect
	    cfa_cache
	    cfa_cfa
	    cfa_top
	    type_cache
	    tools_set
	    tools_shape
	    ast_dump
	    type_env)
   (export  (declare-approx-sets!)
	    
	    (get-approx            <node>)
	    (set-approx!           <node> <approx>)
	    (type-lock-approx!     <approx>)
	    (top-lock-approx!      <approx>)
	    
	    (create-empty-approx)
	    (create-approx         <pair> <pair>)
	    (approx-shape          <approx>)
	    
	    (union-approx!         <approx> . <approx>)))

;*---------------------------------------------------------------------*/
;*    The sets                                                         */
;*---------------------------------------------------------------------*/
(define *type-set*  #unspecified)
(define *alloc-set* #unspecified)
				
;*---------------------------------------------------------------------*/
;*    declare-approx-sets! ...                                         */
;*---------------------------------------------------------------------*/
(define (declare-approx-sets!)
   (set! *type-set*  (declare-set! (list->vector (get-types))
				   type-info
				   type-info-set!))
   (set! *alloc-set* (declare-set! (list->vector (get-allocs))
				   app-cfa-info
				   app-cfa-info-set!)))

;*---------------------------------------------------------------------*/
;*    get-approx ...                                                   */
;*---------------------------------------------------------------------*/
(define (get-approx node)
   (cond
      ((variable? node)
       (cond
	  ((and (function? (variable-value node))
		(or (local? node)
		    (eq? (global-import node) 'export)
		    (eq? (global-import node) 'static)))
	   (ifun-result-approx (variable-cfa-info node)))
	  (else
	   (variable-cfa-info node))))
      ((ast? node)
       (ast-case node
	  ((var)
	   (variable-cfa-info (var-variable node)))
	  ((fun)
	   (let* ((var    (fun-value node))
		  (fun    (var-variable var))
		  (info   (variable-cfa-info fun))
		  (approx (ifun-result-approx info)))
	      approx))
	  ((sequence)
	   (get-approx (car (last-pair (sequence-exp node)))))
	  ((box-ref)
	   (get-approx (box-ref-var node)))
	  ((let-var)
	   (get-approx (let-var-body node)))
	  ((let-fun)
	   (get-approx (let-fun-body node)))
	  ((kwote)
	   (if (ast? (kwote-cfa-info node))
	       (get-approx (kwote-cfa-info node))
	       (ast-info node)))
	  (else
	   (ast-info node))))
      (else
       (internal-error "get-approx"
		       "Illegal argument"
		       node))))
   
;*---------------------------------------------------------------------*/
;*    set-approx! ...                                                  */
;*---------------------------------------------------------------------*/
(define (set-approx! node approx)
   [assert check (approx) (approx? approx)]
   (cond
      ((variable? node)
       (cond
	  ((and (function? (variable-value node))
		(or (local? node)
		    (eq? (global-import node) 'export)
		    (eq? (global-import node) 'static)))
	   (ifun-result-approx-set! (variable-cfa-info node) approx))
	  (else
	   (variable-cfa-info-set! node approx))))
      ((ast? node)
       (ast-case node
	  ((var)
	   (internal-error "set-approx!"
			   "no approximations can be set for `var'"
			   node))
	  ((fun)
	   (let* ((var    (fun-value node))
		  (fun    (var-variable var))
		  (info   (variable-cfa-info fun)))
	      (ifun-result-approx-set! info approx)))
	  ((sequence)
	   (internal-error "set-approx!"
			   "no approximations can be set for `sequence'"
			   (ast->sexp node)))
	  ((box-ref)
	   (internal-error "set-approx!"
			   "no approximations can be set for `let-var'"
			   (ast->sexp node)))
	  ((let-var)
	   (internal-error "set-approx!"
			   "no approximations can be set for `let-var'"
			   node))
	  ((let-fun)
	   (internal-error "set-approx!"
			   "no approximations can be set for `let-fun'"
			   node))
	  ((kwote)
	   (if (ast? (kwote-cfa-info node))
	       (set-approx! (kwote-cfa-info node) approx)
	       (ast-info-set! node approx)))
	  (else
	   (ast-info-set! node approx))))
      (else
       (internal-error "set-approx!"
		       "Illegal argument"
		       node))))

;*---------------------------------------------------------------------*/
;*    type-lock-approx! ...                                            */
;*---------------------------------------------------------------------*/
(define (type-lock-approx! approx)
   [assert check (approx) (approx? approx)]
   (approx-type-locked?-set! approx #t))

;*---------------------------------------------------------------------*/
;*    top-lock-approx! ...                                             */
;*---------------------------------------------------------------------*/
(define (top-lock-approx! approx)
   [assert check (approx) (approx? approx)]
   (approx-top-locked?-set! approx #t))

;*---------------------------------------------------------------------*/
;*    union-approx! ...                                                */
;*---------------------------------------------------------------------*/
(define (union-approx! dst . src)
   [assert check (dst) (approx? dst)]
   (trace (cfa loop init)
	  "        union-approx!: dst: " (approx-shape dst)
	  #\Newline)
   (let loop ((src src)
	      (top #f))
      [assert check (src) (or (null? src) (approx? (car src)))]
      (if (null? src)
	  (if top
	      (add-top! dst))
	  (let ((new (car src)))
	     (trace (cfa loop init)
		    "                       src: " (approx-shape new)
		    #\Newline)
	     (if (not (approx-type-locked? dst))
		 (if (set-union! (approx-type dst) (approx-type new))
		     (continue-cfa!)))
	     (if (set-union! (approx-alloc dst) (approx-alloc new))
		 (continue-cfa!))
	     (loop (cdr src)
		   (or top (approx-top? new)))))))

;*---------------------------------------------------------------------*/
;*    create-empty-approx ...                                          */
;*---------------------------------------------------------------------*/
(define (create-empty-approx)
   (approx (make-set! *type-set*)
	   #f
	   (make-set! *alloc-set*)
	   #f
	   #f
	   *cfa-stamp*
	   #f))

;*---------------------------------------------------------------------*/
;*    create-approx ...                                                */
;*    -------------------------------------------------------------    */
;*    This function allocates and fills an approximation.              */
;*---------------------------------------------------------------------*/
(define (create-approx type* alloc*)
   (let* ((approx (create-empty-approx))
	  (type   (approx-type approx))
	  (alloc  (approx-alloc approx)))
      (for-each (lambda (a) (set-extend! type a)) type*)
      (for-each (lambda (a) (set-extend! alloc a)) alloc*)
      approx))

;*---------------------------------------------------------------------*/
;*    approx-shape ...                                                 */
;*---------------------------------------------------------------------*/
(define (approx-shape approx)
   [assert check (approx) (approx? approx)]
   (let ((l (list (vector 'type (type-approx-shape (approx-type approx)))
		  (vector 'alloc (alloc-approx-shape (approx-alloc approx))))))
      (let ((l (if (approx-type-locked? approx)
		   (cons 'type-locked l)
		   l)))
	 (let ((l (if (approx-top-locked? approx)
		      (cons 'top-locked l)
		      l)))
	    (let ((l (if (approx-exported? approx)
		      (cons 'exported l)
		      l)))
	       (if (approx-top? approx)
		   (cons 'top l)
		   l))))))

;*---------------------------------------------------------------------*/
;*    type-approx-shape ...                                            */
;*---------------------------------------------------------------------*/
(define (type-approx-shape type)
   (shape (set->vector type)))

;*---------------------------------------------------------------------*/
;*    alloc-approx-shape ...                                           */
;*---------------------------------------------------------------------*/
(define (alloc-approx-shape alloc)
   (let ((vector (set->vector alloc)))
      (let loop ((i (-fx (vector-length vector) 1)))
	 (cond
	    ((=fx i -1)
	     vector)
	    (else
	     (vector-set! vector i (ast->sexp (vector-ref vector i)))
	     (loop (-fx i 1)))))))

