;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.8/Cforeign/export.scm      */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Jan 19 10:34:15 1994                          */
;*    Last change :  Wed May 17 09:09:16 1995 (serrano)                */
;*    -------------------------------------------------------------    */
;*    L'exportation des fonctions vers un monde exterieur              */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module cforeign_export
   (include "Ast/ast.sch"
	    "Expand/expander.sch"
	    "Type/type.sch")
   (import  tools_error
	    tools_shape
	    tools_args
	    engine_param
	    ast_env)
   (export  (remember-foreign-exported-bigloo-variable! <symbol> <symbol>)
	    (patch-foreign-exported!)))

;*---------------------------------------------------------------------*/
;*    *foreign-exported* ...                                           */
;*---------------------------------------------------------------------*/
(define *foreign-exported* '())

;*---------------------------------------------------------------------*/
;*    remember-foreign-exported-bigloo-variable! ...                   */
;*---------------------------------------------------------------------*/
(define (remember-foreign-exported-bigloo-variable! bname cname)
   [assert check (bname cname) (and (symbol? bname) (string? cname))]
   (set! *foreign-exported* (cons (cons bname cname) *foreign-exported*)))

;*---------------------------------------------------------------------*/
;*    patch-foreign-exported! ...                                      */
;*---------------------------------------------------------------------*/
(define (patch-foreign-exported!)
   (for-each (lambda (b.c)
		(let ((global (find-global (car b.c))))
		   (if (not (global? global))
		       (user-error "patch-foreign-exported!"
				   "Unbound global variable"
				   (car b.c))
		       (global-target-name-set! global (cdr b.c)))))
	     *foreign-exported*))
