;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.8/Cforeign/struct.scm      */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Fri Jul  7 15:16:28 1995                          */
;*    Last change :  Fri Feb  2 11:07:45 1996 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The installation of structures and unions.                       */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module cforeign_install-c-struct
   (include "Type/type.sch"
	    "Tools/trace.sch"
	    "Ast/ast.sch")
   (import  tools_error
	    tools_shape
	    parse_cforeign
	    parse_static-export
	    ast_env
	    engine_param
	    cforeign_type
	    type_env
	    type_coercion
	    type_tools)
   (export  (install-c-struct-accessors!)
	    (add-c-struct! s)))

;*---------------------------------------------------------------------*/
;*    install-c-struct-accessors! ...                                  */
;*---------------------------------------------------------------------*/
(define (install-c-struct-accessors!)
   (let loop ((l   (get-c-struct-list))
	      (res '()))
      (if (null? l)
	  res
	  (loop (cdr l) (append (make-c-struct-access (car l)) res)))))

;*---------------------------------------------------------------------*/
;*    make-c-struct-access ...                                         */
;*---------------------------------------------------------------------*/
(define (make-c-struct-access tinfo)
   (trace (type loop) "make-c-struct-access: " (shape tinfo) #\Newline)
   (let ((type (vector-ref tinfo 1)))
      (if (type? (type-alias type))
	  (if (eq? (type-class (type-alias type)) 'c-struct)
	      (make-c-struct-access-alias tinfo)
	      (make-c-struct-access-pointer-alias tinfo))
	  (make-c-struct-access-unalias tinfo))))

;*---------------------------------------------------------------------*/
;*    make-c-struct-access-alias ...                                   */
;*---------------------------------------------------------------------*/
(define (make-c-struct-access-alias tinfo)
   (let* ((type       (vector-ref tinfo 1))
	  (tid        (type-id type))
	  (atype      (let ((alias (get-aliased-type type)))
			 ;; we get here the aliased struct. We
			 ;; have to take care that the alias can
			 ;; be either a pointer on a structure
			 ;; or just the structure itself.
			 (if (eq? (type-class alias) 'c-pointer)
			     (type-point-to alias)
			     alias)))
	  (atid       (type-id atype))
	  (atid*      (symbol-append atid '*))
	  (btid       (symbol-append 'b tid))
	  (batid      (symbol-append 'b atid)))
      
      ;; the predicate
      (define (bid?)
	 `(define-inline (,(symbol-append btid '?::bool) o::obj)
	     (if (foreign? o)
		 (eq? (foreign-id o) ',batid)
		 #f)))

      ;; in safe mode, the predicate bid? should not be removed
      ;; until type coercion. Then, we mark it as used with this
      ;; simili-hack
      (if (not *unsafe-type*)
	  (begin
	     (parse-static (list
			    `(inline ,(symbol-append btid '?::bool)
				     o::obj)))
	     (let ((btid? (find-global (symbol-append btid '?))))
		(global-import-set! btid? 'export)
		(global-occurrence-set! btid? 1000))))

      (list (bid?))))

;*---------------------------------------------------------------------*/
;*    make-c-struct-access-pointer-alias ...                           */
;*    -------------------------------------------------------------    */
;*    Due to anonymous structure (C structure with no tag) we can't    */
;*    use the C accessors and the C creator of the aliased type,       */
;*    hence we define them for the alias pointer type.                 */
;*---------------------------------------------------------------------*/
(define (make-c-struct-access-pointer-alias tinfo)
   (let* ((type          (vector-ref tinfo 1))
	  (tid           (type-id type))
	  (patype        (vector-ref tinfo 0))
	  (atype         (type-point-to patype))
	  (btid          (symbol-append 'b tid))
	  (t-name        (type-name type))
	  (t-name*       (string-sans-$ t-name))
	  (t-name-sans-* (type-su-name type))
	  (t-exp         (type-exp atype))
	  (slots         (cdr t-exp)))

      [assert (t-name-sans-*) (string? t-name-sans-*)]
      
      ;; the user allocation form without initialization
      (define (make-id)
	 `(define-inline (,(symbol-append 'make- tid ':: tid))
	     (,(symbol-append 'pragma:: tid)
	      ,(string-append "(" t-name* ")GC_MALLOC( sizeof( "
			      t-name-sans-*
			      " ) )"))))
      
      ;; the user allocation form
      (define (id)
	 ;; for this function definition, we do not use previous
	 ;; inline definition in order to improve the dead code
	 ;; elimination performed during the inlining pass. Hence,
	 ;; we do not use the Scheme creator and the Scheme accessors.
	 ;; Rather we use the foreign creation and foreign accesses.
	 (let ((formals (map (lambda (slots)
				(symbol-append (cadr slots)
					       '::
					       (if (eq?
						    (type-class
						     (get-aliased-type
						      (find-type (car slots))))
						    'c-struct)
						   (symbol-append (car slots)
								  '*)
						   (car slots))))
			     slots)))
	    `(define-inline (,(symbol-append tid ':: tid) ,@formals)
		(let ((o (,(symbol-append 'pragma:: tid)
			  ,(string-append "(" t-name*
					  ")GC_MALLOC( sizeof( "
					  t-name-sans-*
					  " ) )"))))
		   (begin
		      ,@(map
			 (lambda (slot)
			    (let* ((slot-type  (if (eq?
						    (type-class
						     (get-aliased-type
						      (find-type (car slot))))
						    'c-struct)
						   (symbol-append (car slot)
								  '*)
						   (car slot)))
				   (slot-tid   (cadr slot))
				   (slot-name  (caddr slot))
				   (c-set-name (symbol-append 'c-
							      tid
							      '-
							      slot-tid
							      '-set!)))
			       `(,c-set-name
				o
				(pragma ,t-name)
				(pragma ,slot-name)
				,slot-tid)))
			 slots)
		      o)))))

      ;; equality (using ==)
      (define (=id)
	 `(define-inline (,(symbol-append '= tid '::bool)
			  ,(symbol-append 'o1:: tid)
			  ,(symbol-append 'o2:: tid))
	     (pragma::bool "($1 == $2)" o1 o2)))
      
      ;; id-null?
      (define (id-null?)
	 `(define-inline (,(symbol-append tid '-null?::bool)
			  ,(symbol-append 'o:: tid))
	     (pragma::bool ,(string-append "($1 == (" t-name* ")0L)")
			   o)))
      
      
      ;; the getter and setter
      (define (c-getter-and-setter)
	 (let loop ((slots slots)
		    (res   '()))
	    (if (null? slots)
		res
		(let* ((slot      (car slots))
		       (slot-type (car slot))
		       (slot-tid  (cadr slot))
		       (slot-name (caddr slot))
		       (get-name* (symbol-append 'c-
						 tid
						 '-
						 slot-tid))
		       (set-name* (symbol-append 'c-
						 tid
						 '-
						 slot-tid
						 '-set!)))
		   (if (eq? (type-class (get-aliased-type
					 (find-type slot-type)))
			    'c-struct)
		       (let ((slot-type* (symbol-append slot-type '*)))
			  (let ((get `(macro ,slot-type* ,get-name*
					     (,tid obj obj)
					     "C_STRUCT_REF_ADDR"))
				(set `(macro obj ,set-name*
					     (,tid obj obj ,slot-type*)
					     "C_STRUCT_SET_ADDR")))
			     (loop (cdr slots)
				   (cons get (cons set res)))))
		       (let ((get `(macro ,slot-type ,get-name*
					  (,tid obj obj)
					  "C_STRUCT_REF"))
			     (set `(macro obj ,set-name*
					  (,tid obj obj ,slot-type)
					  "C_STRUCT_SET")))
			  (loop (cdr slots)
				(cons get (cons set res)))))))))

      (define (getter-and-setter)
	 (let loop ((slots slots)
		    (res   '()))
	    (if (null? slots)
		res
		(let* ((slot       (car slots))
		       (slot-type  (if (eq? (type-class
					     (get-aliased-type
					      (find-type (car slot))))
					    'c-struct)
				       (symbol-append (car slot) '*)
				       (car slot)))
		       (slot-tid   (cadr slot))
		       (slot-name  (caddr slot))
		       (get-name   (symbol-append tid
						  '-
						  slot-tid
						  '::
						  slot-type))
		       (set-name   (symbol-append tid
						  '-
						  slot-tid
						  '-set!::obj))
		       (c-get-name (symbol-append 'c-
						  tid
						  '-
						  slot-tid))
		       (c-set-name (symbol-append 'c-
						  tid
						  '-
						  slot-tid
						  '-set!)))
		   (let ((get `(define-inline
				  (,get-name ,(symbol-append 'o:: tid))
				  (,c-get-name
				   o
				   (pragma ,t-name)
				   (pragma ,slot-name))))
			 (set `(define-inline
				  (,set-name
				   ,(symbol-append 'o:: tid)
				   ,(symbol-append 'v:: slot-type))
				  (,c-set-name
				   o
				   (pragma ,t-name)
				   (pragma ,slot-name)
				   v))))
		      (loop (cdr slots)
			    (cons get (cons set res))))))))
      
      (parse-c-foreign (c-getter-and-setter) 'import)
      
      (cons* (make-id) (id) (=id) (id-null?) (getter-and-setter))))

;*---------------------------------------------------------------------*/
;*    make-c-struct-access-unalias ...                                 */
;*---------------------------------------------------------------------*/
(define (make-c-struct-access-unalias tinfo)
   (let* ((type          (vector-ref tinfo 1))
	  (tid           (type-id type))
	  (tid*          (symbol-append tid '*))
	  (btid          (symbol-append 'b tid))
	  (t-name        (type-name type))
	  (t-name-sans-$ (string-sans-$ t-name))
	  (t-name*       (string-sans-$ (type-name (find-type tid*))))
	  (atype         (vector-ref tinfo 0))
	  (t-exp         (type-exp atype))
	  (slots         (cdr t-exp)))

      ;; the four conversion allocation fonctions (they are not
      ;; simple coercion because the first one allocate and the
      ;; second one destructurate).
      (define (tid*->btid)
	 `(macro ,btid
	     ,(symbol-append tid* '-> btid)
	     (symbol ,tid*)
	     "cobj_to_foreign"))

      (define (btid->tid*)
	 `(macro ,tid*
	     ,(symbol-append btid '-> tid*)
	     (,btid)
	     "FOREIGN_TO_COBJ"))

      ;; the user allocation form without initialization
      (define (make-id*)
	 `(define-inline (,(symbol-append 'make- tid* ':: tid*))
	     (,(symbol-append 'pragma:: tid*)
	      ,(string-append "(" t-name* ")GC_MALLOC( sizeof( "
			      t-name-sans-$
			      " ) )"))))
      
      ;; the user allocation form
      (define (id*)
	 ;; for this function definition, we do not use previous
	 ;; inline definition in order to improve the dead code
	 ;; elimination performed during the inlining pass. Hence,
	 ;; we do not use the Scheme creator and the Scheme accessors.
	 ;; Rather we use the foreign creation and foreign accesses.
	 (let ((formals (map (lambda (slots)
				(symbol-append (cadr slots)
					       '::
					       (if (eq?
						    (type-class
						     (get-aliased-type
						      (find-type (car slots))))
						    'c-struct)
						   (symbol-append (car slots)
								  '*)
						   (car slots))))
			     slots)))
	    `(define-inline (,(symbol-append tid* ':: tid*) ,@formals)
		(let ((o (,(symbol-append 'pragma:: tid*)
			  ,(string-append "(" t-name* ")GC_MALLOC( sizeof( "
					  t-name-sans-$
					  " ) )"))))
		   (begin
		      ,@(map
			 (lambda (slot)
			    (let* ((slot-type  (if (eq?
						    (type-class
						     (get-aliased-type
						      (find-type (car slot))))
						    'c-struct)
						   (symbol-append (car slot)
								  '*)
						   (car slot)))
				   (slot-tid   (cadr slot))
				   (slot-name  (caddr slot))
				   (c-set-name (symbol-append 'c-
							      tid*
							      '-
							      slot-tid
							      '-set!)))
			       `(,c-set-name
				o
				(pragma ,t-name*)
				(pragma ,slot-name)
				,slot-tid)))
			     slots)
		      o)))))

      ;; the predicate
      (define (bid?)
	 `(define-inline (,(symbol-append btid '?::bool) o::obj)
	     (if (foreign? o)
		 (eq? (foreign-id o) ',btid)
		 #f)))

      ;; equality (using ==)
      (define (=id)
	 `(define-inline (,(symbol-append '= tid* '::bool)
			  ,(symbol-append 'o1:: tid*)
			  ,(symbol-append 'o2:: tid*))
	     (pragma::bool "($1 == $2)" o1 o2)))

      ;; id-null?
      (define (id-null?)
	 `(define-inline (,(symbol-append tid* '-null?::bool)
			  ,(symbol-append 'o:: tid*))
	     (pragma::bool ,(string-append "($1 == (" t-name* ")0L)")
			   o)))
      
      ;; the getter and setter
      (define (c-getter*-and-setter*)
	 (let loop ((slots slots)
		    (res   '()))
	    (if (null? slots)
		res
		(let* ((slot      (car slots))
		       (slot-type (car slot))
		       (slot-tid  (cadr slot))
		       (slot-name (caddr slot))
		       (get-name* (symbol-append 'c-
						 tid*
						 '-
						 slot-tid))
		       (set-name* (symbol-append 'c-
						 tid*
						 '-
						 slot-tid
						 '-set!)))
		   (if (eq? (type-class (get-aliased-type
					 (find-type slot-type)))
			    'c-struct)
		       (let ((slot-type* (symbol-append slot-type '*)))
			  (let ((get `(macro ,slot-type* ,get-name*
					     (,tid* obj obj)
					     "C_STRUCT_REF_ADDR"))
				(set `(macro obj ,set-name*
					     (,tid* obj obj ,slot-type*)
					     "C_STRUCT_SET_ADDR")))
			     (loop (cdr slots)
				   (cons get (cons set res)))))
		       (let ((get `(macro ,slot-type ,get-name*
					  (,tid* obj obj)
					  "C_STRUCT_REF"))
			     (set `(macro obj ,set-name*
					  (,tid* obj obj ,slot-type)
					  "C_STRUCT_SET")))
			  (loop (cdr slots)
				(cons get (cons set res)))))))))
      
      (define (getter*-and-setter*)
	 (let loop ((slots slots)
		    (res   '()))
	    (if (null? slots)
		res
		(let* ((slot       (car slots))
		       (slot-type  (if (eq? (type-class
					     (get-aliased-type
					      (find-type (car slot))))
					    'c-struct)
				       (symbol-append (car slot) '*)
				       (car slot)))
		       (slot-tid   (cadr slot))
		       (slot-name  (caddr slot))
		       (get-name   (symbol-append tid*
						  '-
						  slot-tid
						  '::
						  slot-type))
		       (set-name   (symbol-append tid*
						  '-
						  slot-tid
						  '-set!::obj))
		       (c-get-name (symbol-append 'c-
						  tid*
						  '-
						  slot-tid))
		       (c-set-name (symbol-append 'c-
						  tid*
						  '-
						  slot-tid
						  '-set!)))
		   (let ((get `(define-inline
				  (,get-name ,(symbol-append 'o:: tid*))
				  (,c-get-name
				   o
				   (pragma ,t-name*)
				   (pragma ,slot-name))))
			 (set `(define-inline
				  (,set-name
				   ,(symbol-append 'o:: tid*)
				   ,(symbol-append 'v:: slot-type))
				  (,c-set-name
				   o
				   (pragma ,t-name*)
				   (pragma ,slot-name)
				   v))))
		      (loop (cdr slots)
			    (cons get (cons set res))))))))
      
      ;; in safe mode, the predicate bid? should not be removed
      ;; until type coercion. Then, we mark it as used with this
      ;; simili-hack
      (if (not *unsafe-type*)
	  (begin
	     (parse-static (list
			    `(inline ,(symbol-append btid '?::bool) o::obj)))
	     (let ((btid? (find-global (symbol-append btid '?))))
		(global-import-set! btid? 'export)
		(global-occurrence-set! btid? 1000))))
      
      (parse-c-foreign (cons* (tid*->btid) 
			      (btid->tid*)
			      (c-getter*-and-setter*)) 
		       'import)
      (cons* (make-id*) (id*) (=id) (id-null?) (bid?) (getter*-and-setter*))))

;*---------------------------------------------------------------------*/
;*    *c-struct-list* ...                                              */
;*---------------------------------------------------------------------*/
(define *c-struct-list* '())

;*---------------------------------------------------------------------*/
;*    add-c-struct! ...                                                */
;*---------------------------------------------------------------------*/
(define (add-c-struct! s)
   (set! *c-struct-list* (cons s *c-struct-list*)))

;*---------------------------------------------------------------------*/
;*    get-c-struct-list ...                                            */
;*---------------------------------------------------------------------*/
(define (get-c-struct-list)
   (reverse! *c-struct-list*))

