;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.8/Cgen/cdef.scm            */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Fri Mar 17 09:51:03 1995                          */
;*    Last change :  Fri Feb  9 11:20:36 1996 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The emission of C function definitions.                          */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module cgen_cdef
   (include "Ast/ast-tools.sch"
	    "Ast/ast.sch"
	    "Tools/trace.sch"
	    "Cgen/cgen.sch"
	    "Type/type.sch")
   (import  cgen_prototype
	    cgen_ident
	    engine_param
	    type_cache
	    type_tools
	    tools_shape)
   (export  (emit-c-def <output-port> <global>)))

;*---------------------------------------------------------------------*/
;*    emit-c-def ...                                                   */
;*---------------------------------------------------------------------*/
(define (emit-c-def port global)
   [assert check (global) (cgen? (global-info global))]
   [assert check (global) (cop? (cgen-cop (global-info global)))]
   (emit-function-definition port global)
   (emit-cop port (cgen-cop (global-info global)))
   (newline port)
   (newline port)
   'done)
 
;*---------------------------------------------------------------------*/
;*    emit-cop ...                                                     */
;*---------------------------------------------------------------------*/
(define (emit-cop port cop)
   (let loop ((cop cop))
      (trace cgen "emit-cop: " (shape cop) #\Newline)
      (cop-case cop
	 ((label)
	  (if (label-used? cop)
	      (fprint port (label-name cop) #\:))
	  (loop (label-body cop)))
	 ((goto)
	  (fprint port "goto " (label-name (goto-label cop)) #\;))
	 ((block)
	  (display #\{ port)
	  (loop (block-body cop))
	  (display #\} port))
	 ((csequence)
	  (if (cop-c-exp? cop)
	      (begin
		 (if (null? (csequence-exp cop))
		     (emit-atom-value port #unspecified)
		     (begin
			(display #\( port)
			(let liip ((exp (csequence-exp cop)))
			   (if (null? (cdr exp))
			       (begin
				  (loop (car exp))
				  (display #\) port))
			       (begin
				  (loop (car exp))
				  (if (cfail? (car exp))
				      (display #\) port)
				      (begin
					 (display #\, port)
					 (newline port)
					 (liip (cdr exp))))))))))
	      (let liip ((exp (csequence-exp cop)))
		 (if (null? exp)
		     #unspecified
		     (let ((e (car exp)))
			(loop e)
			(if (cop-c-exp? e)
			    (begin
			       (display #\; port)
			       (newline port)))
			(if (cfail? e)
			    (liip '())
			    (liip (cdr exp))))))))
	 ((void)
	  (loop (void-value cop)))
	 ((creturn)
	  (display "return " port)
	  (loop (creturn-value cop))
	  (fprint port #\;))
	 ((catom)
	  (emit-atom-value port (catom-value cop)))
	 ((cvar)
	  (display (variable-id (cvar-variable cop)) port))
	 ((stop)
	  (loop (stop-value cop))
	  (fprint port #\;))
	 ((nop)
	  (fprint port #\;))
	 ((csetq)
	  (let ((val (csetq-val cop))
		(var (csetq-var cop)))
	     (loop var)
	     ;; don't omit to put space sourrounding `=' otherwise
	     ;; it could become an ambiguous assignement (e.g. x=-1).
	     (display " = " port)
	     (loop val)))
	 ((cif)
	  (display "if(" port)
	  (loop (cif-test cop))
	  (display #\) port)
	  (loop (cif-then cop))
	  (display " else " port)
	  (loop (cif-else cop)))
	 ((branch)
	  (emit-cop port (branch-test cop))
	  (emit-cop port (branch-true cop))
	  (if (cop-c-exp? (branch-true cop))
	      (display ";" port))
	  (emit-cop port (branch-false cop))
	  (if (cop-c-exp? (branch-false cop))
	      (display ";" port))
	  (emit-cop port (branch-end cop)))
	 ((cswitch)
	  (emit-cswitch port cop))
	 ((local-var)
	  (emit-local-declaration port (local-var-vars cop)))
	 ((cfuncall)
	  (emit-cfuncall port cop))
	 ((capply)
	  (emit-capply port cop))
	 ((capp)
	  (emit-capp port cop))
	 ((cfail)
	  (display "FAILURE(" port)
	  (emit-cop port (cfail-proc cop))
	  (display #\, port)
	  (emit-cop port (cfail-msg cop))
	  (display #\, port)
	  (emit-cop port (cfail-obj cop))
	  (display ");" port))
	 ((cpragma)
	  (emit-cpragma port cop))
	 ((cmake-box)
	  (display "MAKE_CELL(" port)
	  (emit-cop port (cmake-box-value cop))
	  (display #\) port))
	 ((cbox-ref)
	  (display "CELL_REF(" port)
	  (emit-cop port (cbox-ref-var cop))
	  (display #\) port))
	 ((cbox-set!)
	  (display "CELL_SET(" port)
	  (emit-cop port (cbox-set!-var cop))
	  (display ", " port)
	  (emit-cop port (cbox-set!-value cop))
	  (display #\) port))
	 ((cset-ex-it)
	  (display "if( SET_EXIT(" port)
	  (emit-cop port (cset-ex-it-exit cop))
	  (display ") ) {" port)
	  (display "RESTORE_TRACE(); " port)
	  (emit-cop port (cset-ex-it-jump-value cop))
	  (display "} else {" port)
	  (emit-cop port (cset-ex-it-body cop))
	  (display "}" port))
	 ((cjump-ex-it)
	  (display "JUMP_EXIT( " port)
	  (emit-cop port (cjump-ex-it-exit cop))
	  (display #\, port)
	  (emit-cop port (cjump-ex-it-value cop))
	  (display #\) port))
	 (else
	  (warning "emit-cop" ":unimplemented node:" (shape cop))))))

;*---------------------------------------------------------------------*/
;*    emit-atom-value ...                                              */
;*---------------------------------------------------------------------*/
(define (emit-atom-value port value)
   (cond
      ((boolean? value)
       (display "((" port)
       (display (string-sans-$ (type-name *bool*)) port)
       (display #\) port)
       (display (if value 1 0) port)
       (display #\) port))
      ((null? value)
       (display "BNIL" port))
      ((char? value)
       (display "((unsigned char)" port)
       (if (=fx (char->integer value) 0)
	   (display "'\\000'" port)
	   (begin
	      (write-char #\' port)
	      (if (=fx (char->integer value) 39)
		  (display "\\''" port)
		  (begin
		     (case value
			((#\return)
			 (write-char #\\ port)
			 (write-char #\r port))
			((#\tab)
			 (write-char #\\ port)
			 (write-char #\t port))
			((#\newline)
			 (write-char #\\ port)
			 (write-char #\n port))
			((#\\)
			 (write-char #\\ port)
			 (write-char #\\ port))
			(else
			 (write-char value port)))
		     (write-char #\' port)))))
       (write-char #\) port))
      ((eq? value #unspecified)
       (display "BUNSPEC" port))
      ((cnst? value)
       (display "BCNST(" port)
       (display (cnst->integer value) port)
       (display #\) port))
      ((string? value)
       (display #\" port)
       (display (string-for-read value) port)
       (display #\" port))
      (else
       (display value port))))

;*---------------------------------------------------------------------*/
;*    emit-cfuncall ...                                                */
;*---------------------------------------------------------------------*/
(define (emit-cfuncall port cop)
   (define (emit-extra-light-cfuncall port cop)
      (let ((actuals (cfuncall-actuals cop)))
	 (emit-cop port (cfuncall-fun cop))
	 (display #\( port)
	 (let loop ((actuals actuals))
	    ;; actuals are never empty because their are always
	    ;; the EOA.
	    (if (null? (cddr actuals))
		(begin
		   (emit-cop port (car actuals))
		   (display ")" port))
		(begin
		   (emit-cop port (car actuals))
		   (display ", " port)
		   (loop (cdr actuals)))))))
   (define (emit-light-cfuncall port cop)
      (let ((actuals (cfuncall-actuals cop)))
	 (display "PROCEDURE_L_ENTRY(" port)
	 (emit-cop port (cfuncall-fun cop))
	 (display ")(" port)
	 (let loop ((actuals actuals))
	    ;; actuals are never empty because their are always
	    ;; the function and EOA.
	    (if (null? (cddr actuals))
		(begin
		   (emit-cop port (car actuals))
		   (display ")" port))
		(begin
		   (emit-cop port (car actuals))
		   (display ", " port)
		   (loop (cdr actuals)))))))
   (define (emit-regular-cfuncall/eoa port cop)
      (let ((actuals (cfuncall-actuals cop)))
	 (display "PROCEDURE_ENTRY(" port)
	 (emit-cop port (cfuncall-fun cop))
	 (display ")(" port)
	 (let loop ((actuals actuals))
	    ;; actuals are never empty because their are always
	    ;; the function and EOA.
	    (if (null? (cdr actuals))
		(begin
		   (emit-cop port (car actuals))
		   (display ")" port))
		(begin
		   (emit-cop port (car actuals))
		   (display ", " port)
		   (loop (cdr actuals)))))))
      (define (emit-regular-cfuncall/oeoa port cop)
      (let ((actuals (cfuncall-actuals cop)))
	 (display "PROCEDURE_ENTRY(" port)
	 (emit-cop port (cfuncall-fun cop))
	 (display ")(" port)
	 (let loop ((actuals actuals))
	    ;; actuals are never empty because their are always
	    ;; the function and EOA.
	    (if (null? (cddr actuals))
		(begin
		   (emit-cop port (car actuals))
		   (display ")" port))
		(begin
		   (emit-cop port (car actuals))
		   (display ", " port)
		   (loop (cdr actuals)))))))
   (define (emit-stdc-regular-cfuncall port cop)
      (display "(VA_PROCUDUREP( " port)
      (emit-cop port (cfuncall-fun cop))
      (display " ) ? " port)
      (emit-regular-cfuncall/eoa port cop)
      (display " : " port)
      (emit-regular-cfuncall/oeoa port cop)
      (display " )" port))
   (case (cfuncall-strength cop)
      ((extra-light)
       (emit-extra-light-cfuncall port cop))
      ((light)
       (emit-light-cfuncall port cop))
      (else
       (if *stdc*
	   (emit-stdc-regular-cfuncall port cop)
	   (emit-regular-cfuncall/eoa port cop)))))
	     
;*---------------------------------------------------------------------*/
;*    emit-capply ...                                                  */
;*---------------------------------------------------------------------*/
(define (emit-capply port cop)
   (display "apply(" port)
   (emit-cop port (capply-fun cop))
   (display ", " port)
   (emit-cop port (capply-value cop))
   (display #\) port))
	     
;*---------------------------------------------------------------------*/
;*    emit-capp ...                                                    */
;*---------------------------------------------------------------------*/
(define (emit-capp port cop)
   (define (emit-infix-capp)
      (let ((actuals (capp-actuals cop)))
	 (display #\( port)
	 (emit-cop port (car actuals))
	 (emit-cop port (capp-fun cop))
	 (emit-cop port (cadr actuals))
	 (display #\) port)))
   (define (emit-prefix-capp)
      (let ((actuals (capp-actuals cop)))
	 (emit-cop port (capp-fun cop))
	 (display #\( port)
	 (if (null? actuals)
	     (display #\) port)
	     (let loop ((actuals actuals))
		(if (null? (cdr actuals))
		    (begin
		       (emit-cop port (car actuals))
		       (display #\) port))
		    (begin
		       (emit-cop port (car actuals))
		       (display ", " port)
		       (loop (cdr actuals))))))))
   (let ((fun (cvar-variable (capp-fun cop))))
      (if (and (eq? (global-import fun) 'foreign)
	       (ffunction-infix (global-value fun)))
	  (emit-infix-capp)
	  (emit-prefix-capp))))
	     
;*---------------------------------------------------------------------*/
;*    emit-cswitch ...                                                 */
;*---------------------------------------------------------------------*/
(define (emit-cswitch port cop)
   (display "switch " port)
   (write-char #\( port)
   (emit-cop port (cswitch-test cop))
   (write-char #\) port)
   (write-char #\{ port)
   (let loop ((clauses (cswitch-clauses cop)))
      (let ((clause (car clauses)))
	 (if (eq? (car clause) 'else)
	     (begin
		(display "default: " port)
		(newline port)
		(emit-cop port (cdr clause))
		(if (cop-c-exp? (cdr clause))
		    (fprint port #\;))
		(write-char #\} port))
	     (begin
		(for-each (lambda (t)
			     (display "case " port)
			     (emit-atom-value port t)
			     (display " : " port)
			     (newline port))
			  (car clause))
		(emit-cop port (cdr clause))
		(if (cop-c-exp? (cdr clause))
		    (fprint port #\;))
		(fprint port "break;")
		(loop (cdr clauses)))))))

;*---------------------------------------------------------------------*/
;*    emit-cpragma ...                                                 */
;*---------------------------------------------------------------------*/
(define (emit-cpragma port cop)
   (if (null? (cpragma-values cop))
       (display (cpragma-string cop) port)
       (let* ((sport   (open-input-string (cpragma-string cop)))
	      (values  (list->vector (cpragma-values cop)))
	      (parser  (regular-grammar ()
			  ((#\$ (+ (>-< #\0 #\9)))
			   (let* ((str   (the-string))
				  (len   (the-length))
				  (index (string->number
					  (substring str 1 len))))
			      (emit-cop port (vector-ref values (-fx index 1)))
			      (ignore)))
			  ((+ (out #\$))
			   (display (the-string) port)
			   (ignore))
			  (else
			   (the-failing-char)))))
	  (read/rp parser sport))))
