;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.8/Cgen/prototype.scm       */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Mar 16 18:44:04 1995                          */
;*    Last change :  Fri Feb  9 15:35:55 1996 (serrano)                */
;*    -------------------------------------------------------------    */
;*    We emit a prototype.                                             */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module cgen_prototype
   (include "Ast/node.sch"
	    "Type/type.sch"
	    "Tvector/tvector.sch")
   (import  cgen_ident
	    tools_shape
	    tools_error
	    tvector_cnst
	    type_cache
	    type_env
	    type_tools
	    engine_param)
   (export  (get-local-type            <local>)
	    (emit-prototype            <port> <global>)
	    (emit-sprocedure-prototype <port> <global>)
	    (emit-function-definition  <port> <global>)
	    (emit-local-declaration    <port> <local>*)))

;*---------------------------------------------------------------------*/
;*    emit-prototype ...                                               */
;*---------------------------------------------------------------------*/
(define (emit-prototype port global)
   (case (global-class global)
      ((variable)
       (emit-variable-prototype port global))
      ((sstring)
       (emit-sstring-prototype port global))
      ((sreal)
       (emit-sreal-prototype port global))
      ((sprocedure)
       (emit-sprocedure-prototype port global))
      ((stvector)
       (emit-stvector-prototype port global))
      ((procedure inline)
       (emit-function-prototype port global))
      ((c-macro-function c-macro-variable)
       'nothing-to-do)
      ((c-function)
       (emit-ffunction-prototype port global))
      ((c-variable)
       (emit-cvariable-prototype port global))
      (else
       'done)))

;*---------------------------------------------------------------------*/
;*    get-type ...                                                     */
;*---------------------------------------------------------------------*/
(define (get-type type)
   (if (null? type)
       *obj*
       type))

;*---------------------------------------------------------------------*/
;*    emit-variable-prototype ...                                      */
;*---------------------------------------------------------------------*/
(define (emit-variable-prototype port global)
   (let ((type (get-type (global-type global))))
      [assert check (global type) (type? type)]
      (if (sub-obj-type? type)
	  (case (global-import global)
	     ((static)
	      (fprint port
		      (get-c-scope global)
		      #\space
		      (make-typed-declaration type (global-id global))
		      " = BUNSPEC"
		      #\;))
	     ((export)
	      (fprint port
		      (make-typed-declaration type (global-id global))
		      " = BUNSPEC"
		      #\;))
	     (else
	      (fprint port
		      (get-c-scope global)
		      #\space
		      (make-typed-declaration type (global-id global))
		      #\;)))
	  (if (eq? (global-import global) 'export)
	      (fprint port
		      (make-typed-declaration type (global-id global))
		      #\;)
	      (fprint port
		      (get-c-scope global)
		      #\space
		      (make-typed-declaration type (global-id global))
		      #\;)))))

;*---------------------------------------------------------------------*/
;*    emit-sstring-prototype ...                                       */
;*---------------------------------------------------------------------*/
(define (emit-sstring-prototype port global)
   (let* ((ostr (global-value global))
	  (str  (string-for-read ostr)))
      (fprin port
	     "DEFINE_STRING( "
	     (global-id global)
	     ", "
	     (scheme-id->c-id (symbol->string (gensym 'aux)))
	     ", \"")
      (let loop ((read       0)
		 (rlen       (string-length str)))
	 (cond
	    ((<=fx rlen *max-c-token-length*)
	     (display (substring str read (+fx read rlen)) port)
	     (fprint port "\", " (string-length (global-value global)) " );"))
	    (else
	     (let laap ((offset (+fx read *max-c-token-length*)))
		(cond
		   ((>=fx (+fx read 3) offset)
		    (error "emit-sstring-prototype" "Can't emit string" str))
		   ((char=? (string-ref str (-fx offset 1)) #\\)
		    (laap (-fx offset 1)))
		   ((and (char=? (string-ref str (-fx offset 2)) #\\)
			 (char-numeric? (string-ref str (-fx offset 1))))
		    (laap (-fx offset 2)))
		   ((and (char=? (string-ref str (-fx offset 3)) #\\)
			 (char-numeric? (string-ref str (-fx offset 2)))
			 (char-numeric? (string-ref str (-fx offset 1))))
		    (laap (-fx offset 3)))
		   (else
		    (fprin port (substring str read offset) #"\"\n\"")
		    (loop offset
			  (-fx rlen (-fx offset read)))))))))))

;*---------------------------------------------------------------------*/
;*    emit-sprocedure-prototype ...                                    */
;*---------------------------------------------------------------------*/
(define (emit-sprocedure-prototype port global)
   (if (eq? (global-import global) 'import)
       (emit-variable-prototype port global)
       (let* ((make    (global-value global))
	      (actuals (app-actuals make))
	      (entry   (car actuals))
	      (arity   (atom-value (cadr actuals)))
	      (id      (global-id global)))
	  (if (>=fx arity 0)
	      (fprint port
		      (if (eq? (global-import global) 'static)
			  "DEFINE_STATIC_PROCEDURE( "
			  "DEFINE_EXPORT_PROCEDURE( ")
		      id
		      ", "
		      (scheme-id->c-id (symbol->string (gensym 'aux)))
		      ", "
		      (global-id (var-variable entry))
		      ", 0L, "
		      arity
		      " );")
	      (fprint port
		      (if (eq? (global-import global) 'static)
			  "DEFINE_STATIC_PROCEDURE( "
			  "DEFINE_EXPORT_PROCEDURE( ")
		      id
		      ", "
		      (scheme-id->c-id (symbol->string (gensym 'aux)))
		      ", va_generic_entry"
		      ", "
		      (global-id (var-variable entry))
		      ", "
		      arity
		      " );")))))

;*---------------------------------------------------------------------*/
;*    emit-sreal-prototype ...                                         */
;*---------------------------------------------------------------------*/
(define (emit-sreal-prototype port global)
   (fprint port
	   "DEFINE_REAL( "
	   (global-id global)
	   ", "
	   (scheme-id->c-id (symbol->string (gensym 'aux)))
	   ", "
	   (global-value global)
	   " );"))

;*---------------------------------------------------------------------*/
;*    emit-stvector-prototype ...                                      */
;*---------------------------------------------------------------------*/
(define (emit-stvector-prototype port global)
   (let* ((tvect  (global-value global))
	  (vect   (a-tvector-vector tvect))
	  (itype  (tvector-item-type tvect))
	  (c-vect (tvector->c-vector tvect))
	  (aux    (scheme-id->c-id (symbol->string (gensym 'aux)))))
      (fprint port
	      "DEFINE_TVECTOR_START( "
	      aux
	      ", "
	      (vector-length vect)
	      ", "
	      (string-sans-$ (type-name itype))
	      " ) "
	      c-vect
	      " DEFINE_TVECTOR_STOP( "
	      (global-id global)
	      ", "
	      aux
	      " );")))

;*---------------------------------------------------------------------*/
;*    emit-function-prototype ...                                      */
;*---------------------------------------------------------------------*/
(define (emit-function-prototype port global)
   (fprin port (get-c-scope global) #\space)
   (let* ((fun  (global-value global))
	  (tres (get-type (function-type-res fun)))
	  (args (function-args fun)))
      (fprin port
	     (make-typed-declaration tres (global-id global))
	     #\()
      (if (null? args)
	  (display #\) port)
	  (begin
	     (display #\space port)
	     (let loop ((args args))
		(if (null? (cdr args))
		    (begin
		       (fprin port
			      (type-name-sans-$ (get-local-type (car args))))
		       (fprin port " )"))
		    (begin
		       (fprin port 
			      (type-name-sans-$ (get-local-type (car args)))
			      ", ")
		       (loop (cdr args))))))))
   (fprint port #\;))

;*---------------------------------------------------------------------*/
;*    emit-ffunction-prototype ...                                     */
;*---------------------------------------------------------------------*/
(define (emit-ffunction-prototype port global)
   (fprin port "extern ")
   (let* ((fun   (global-value global))
	  (tres  (get-type (ffunction-type-res fun)))
	  (arity (ffunction-arity fun))
	  (targs (ffunction-type-args fun)))
      (fprin port
	     (make-typed-declaration tres (global-id global))
	     #\()
      (cond
	 ((null? targs)
	  (display #\) port))
	 ((<=fx arity -1)
	  (fprin port (type-name-sans-$ (get-type (car targs))) ", ... )"))
	 (else
	  (display #\space port)
	  (let loop ((targs targs))
	     (if (null? (cdr targs))
		 (if (<fx arity 0)
		     (fprin port
			    "... )")
		     (fprin port
			    (type-name-sans-$ (get-type (car targs)))
			    " )"))
		 (begin
		    (fprin port 
			   (type-name-sans-$ (get-type (car targs)))
			   ", ")
		    (loop (cdr targs)))))))
      (display #\; port)
      (newline port)))

;*---------------------------------------------------------------------*/
;*    emit-function-definition ...                                     */
;*    -------------------------------------------------------------    */
;*    Function definition are written in an ansi style.                */
;*---------------------------------------------------------------------*/
(define (emit-function-definition port global)
   (let* ((fun  (global-value global))
	  (tres (get-type (function-type-res fun)))
	  (args (function-args fun)))
      (fprin port
	     (make-typed-declaration tres (global-id global)))
      (if (null? args)
	  (fprint port "()")
	  (begin
	     (display #\( port)
	     (let loop ((args args))
		(if (null? (cdr args))
		    (begin
		       (fprin port
			      (make-typed-declaration
			       (get-local-type (car args))
			       (local-id (car args))))
		       (fprint port #\)))
		    (begin
		       (fprin port
			       (make-typed-declaration
				(get-local-type (car args))
				(local-id (car args)))
			       ", ")
		       (loop (cdr args)))))))))

;*---------------------------------------------------------------------*/
;*    emit-cvariable-prototype ...                                     */
;*---------------------------------------------------------------------*/
(define (emit-cvariable-prototype port global)
   (let ((type (get-type (global-type global))))
      [assert check (global type) (type? type)]
      (fprint port
	      "extern "
	      (make-typed-declaration type (global-target-name global))
	      #\;)))

;*---------------------------------------------------------------------*/
;*    emit-local-declaration ...                                       */
;*---------------------------------------------------------------------*/
(define (emit-local-declaration port locals)
   (for-each (lambda (local)
		(fprint port
			(make-typed-declaration (get-local-type local)
						(local-id local))
			#\;))
	     locals))
   
;*---------------------------------------------------------------------*/
;*    get-c-scope ...                                                  */
;*---------------------------------------------------------------------*/
(define (get-c-scope global)
   (case (global-import global)
      ((static)
       "static")
      ((import)
       "extern")
      ((export)
       "extern")
      (else
       (internal-error "get-c-scope"
		       "Unknown importation"
		       (global-import global)))))

;*---------------------------------------------------------------------*/
;*    get-local-type ...                                               */
;*---------------------------------------------------------------------*/
(define (get-local-type local)
   (let ((type (local-type local)))
      [assert check (type) (or (null? type) (type? type))]
      (if (null? type)
	  *obj*
	  type)))

;*---------------------------------------------------------------------*/
;*    fprin ...                                                        */
;*---------------------------------------------------------------------*/
(define (fprin port . obj)
   (for-each (lambda (o) (display o port)) obj))
