;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.8/Coerce/convert.scm       */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Jan 19 10:19:33 1995                          */
;*    Last change :  Mon Jan 22 14:00:55 1996 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The coercion                                                     */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module coerce_convert
   (include "Type/type.sch"
	    "Ast/node.sch"
	    "Tools/trace.sch")
   (import  tools_shape
	    tools_location
	    type_cache
	    type_coercion
	    type_env
	    engine_param
	    coerce_coerce
	    ast_typeof
	    ast_sexp
	    ast_dump)
    (export (convert! <ast> <type> <type>)))

;*---------------------------------------------------------------------*/
;*    type-error-msg ...                                               */
;*---------------------------------------------------------------------*/
(define (type-error-msg to from)
   (string-append "`"
		  (symbol->string (type-id to)) "' expected, `"
		  (symbol->string (type-id from)) "' provided."))

;*---------------------------------------------------------------------*/
;*    type-error/location ...                                          */
;*---------------------------------------------------------------------*/
(define (type-error/location loc function from to)
   (user-error/location loc
			function
			"Type error"
			(type-error-msg to from)))

;*---------------------------------------------------------------------*/
;*    type-warning/location ...                                        */
;*---------------------------------------------------------------------*/
(define (type-warning/location loc function from to)
   (user-warning/location loc
			  function
			  "Type error"
			  (type-error-msg to from)))

;*---------------------------------------------------------------------*/
;*    runtime-type-error ...                                           */
;*---------------------------------------------------------------------*/
(define (runtime-type-error loc ti value)
   (trace type "runtime-type-error: " (shape ti) "  " (shape value) #\Newline)
   (define (runtime-type-error/id id)
      (trace type "   runtime-type-error/id: " (shape id) #\Newline)
      (if (and (>fx *compiler-debug* 0) (loc? loc))
	  `(begin
	      ((@ error/location __error)
	       ',(current-function)
	       ,(string-append "Type `"
			       (symbol->string ti)
			       "' expected")
	       ,id
	       ,(loc-full-fname loc)
	       ,(loc-pos loc))
	      ;; we introduce a dummy failure in order to allow
	      ;; C to compile its source file (otherwise their is
	      ;; some type mismatch).
	      (failure #f #f #f))
	  `(failure
	    ',(current-function)
	    (string->bstring ,(string-append "Type `"
					     (symbol->string ti)
					     "' expected"))
	    ,id)))
   (define (runtime-type-error/ast)
      (trace type "   runtime-type-error/ast: " #\Newline)
      (let* ((aux (gensym 'aux))
	     (res (sexp->ast `(let ((,(symbol-append aux '::obj) #unspecified))
				 ,(runtime-type-error/id aux))
			     '()
			     #f
			     loc
			     'read)))
	 (set-cdr! (car (let-var-bindings res)) value)
	 res))
   (if (ast? value)
       (runtime-type-error/ast)
       (runtime-type-error/id value)))

;*---------------------------------------------------------------------*/
;*    convert-error ...                                                */
;*    -------------------------------------------------------------    */
;*    When we find a type error and the wanted type is a Bigloo        */
;*    type we emit a warning and compile an error. Otherwise, we       */
;*    stop the compilation.                                            */
;*---------------------------------------------------------------------*/
(define (convert-error from to loc ast)
   (if (and (not (eq? to *obj*)) (sub-obj-type? to))
       (let ((unsafe-type *unsafe-type*))
	  (set! *unsafe-type* #t)
	  (type-warning/location loc (current-function) from to)
	  (let ((res (coerce! (runtime-type-error loc
						  (type-id to)
						  ast)
			      from)))
	     (set! *unsafe-type* unsafe-type)
	     res))
       (type-error/location loc (current-function) from to)))
   
;*---------------------------------------------------------------------*/
;*    convert! ...                                                     */
;*---------------------------------------------------------------------*/
(define (convert! ast from to)
   (assert check (ast from to) (and (type? from) (type? to)))
   (trace type "convert: " (shape from) " -> " (shape to) " : " (ast->sexp ast)
	  #\Newline)
   (let ((to   (get-aliased-type to))
	 (from (get-aliased-type from)))
      (if (or (eq? from to) (type-magic? from))
	  ast
	  (let ((coercer (find-coercer from to))
		(loc     (ast-location ast)))
	     (if (not (coercer? coercer))
		 ;; There is no convertion between these types. 
		 ;; Thus, it is a type error.
		 (convert-error from to loc ast)
		 (let ((checks  (coercer-check-op coercer))
		       (coerces (coercer-coerce-op coercer)))
		    (trace (type loop)
			   "   checks : " checks #\Newline
			   "   coerces: " coerces #\Newline)
		    (let loop ((checks  checks)
			       (coerces coerces)
			       (ast     ast))
		       (cond
			  ((null? checks)
			   (if (null? coerces)
			       ast
			       (internal-error "Illegal conversion"
					       (shape from)
					       (shape to))))
			  ((null? coerces)
			   (internal-error "Illegal conversion"
					   (shape from)
					   (shape to)))
			  (else
			   (loop (cdr checks)
				 (cdr coerces)
				 (make-one-conversion (car checks)
						      from
						      to
						      (car checks)
						      (car coerces)
						      ast)))))))))))

;*---------------------------------------------------------------------*/
;*    make-one-conversion ...                                          */
;*    -------------------------------------------------------------    */
;*    from A0 we build an Ast like:                                    */
;* 	(let ((v A0))                                                  */
;* 	   (if (check? v)                                              */
;* 	       (coerce v)                                              */
;* 	       (type-error)))                                          */
;*---------------------------------------------------------------------*/
(define (make-one-conversion id-from from to check-op coerce-op ast)
   (if (or (null? check-op) *unsafe-type*) 
       (do-convert coerce-op ast)
       (let* ((aux  (gensym 'aux))
	      (loc  (ast-location ast))
	      (last (sexp->ast
		     `(let ((,(symbol-append aux '::obj) #unspecified))
			 (if (,check-op ,aux)
			     ,aux
			     ,(runtime-type-error loc
						  (type-id to)
						  aux)))
		     '()
		     #f
		     loc
		     'read)))
	  (let* ((var        (car (car (let-var-bindings last))))
		 (coerce-app (do-convert coerce-op (ast-var loc #f #f var))))
	     ;; we set the local variable type
	     (let ((type (let ((t (ast-type ast)))
			    (if (not (type? t))
				(typeof ast)
				t))))
		(local-type-set! var type)
		[assert check (var) (let ((t (local-type var)))
				       (or (null? t)
					   (symbol? t)
					   (type? t)))])
	     ;; and the local variable value
	     (set-cdr! (car (let-var-bindings last)) ast)
	     (conditional-then-set! (let-var-body last) coerce-app)
	     (set! *unsafe-type* #t)
	     (conditional-else-set! (let-var-body last)
				    (coerce! (conditional-else
					       (let-var-body last))
					     from))
	     (set! *unsafe-type* #f)
	     last))))

;*---------------------------------------------------------------------*/
;*    do-convert ...                                                   */
;*---------------------------------------------------------------------*/
(define (do-convert coerce-op ast)
   (trace type "do-convert: " (shape coerce-op) " " (ast->sexp ast) #\Newline)
   (if (null? coerce-op)
       ast
       (let* ((nast (sexp->ast `(,coerce-op #unspecified)
			       '()
			       #f
			       (ast-location ast)
			       'read)))
	  (trace type "   app: " (ast->sexp nast) #\Newline)
	  (ast-case nast
	     ((app)
	      (app-actuals-set! nast (list ast))
	      nast)
	     ((let-var)
	      (let ((bdgs (let-var-bindings nast)))
		 (if (or (null? bdgs) (not (null? (cdr bdgs))))
		     (internal-error "do-convert"
				     "Illegal converter"
				     (shape coerce-op))
		     (begin
			(set-cdr! (car bdgs) ast)
			nast))))
	     (else
	      (internal-error "do-convert"
			      "Illegal converter"
			      (shape coerce-op)))))))
