;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.8/Effect/cgraph.scm        */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sat Jul 15 10:55:41 1995                          */
;*    Last change :  Fri Dec  8 12:32:29 1995 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The computation of the call-graph                                */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module effect_cgraph
   (include "Ast/node.sch"
	    "Tools/trace.sch"
	    "Effect/effect.sch")
   (import  tools_shape
	    tools_error)
   (export  (call-graph! ast owner W)
	    (get-info    global)
	    (get-all-functions)))

;*---------------------------------------------------------------------*/
;*    *all-functions*                                                  */
;*---------------------------------------------------------------------*/
(define *all-functions* '())

;*---------------------------------------------------------------------*/
;*    get-all-functions ...                                            */
;*---------------------------------------------------------------------*/
(define (get-all-functions)
   *all-functions*)

;*---------------------------------------------------------------------*/
;*    get-info ...                                                     */
;*---------------------------------------------------------------------*/
(define (get-info var)
   (cond
      ((local? var)
       (if (temp? (local-info var))
	   (local-info var)
	   (make-local-temp var)))
      ((global? var)
       (if (temp? (global-info var))
	   (global-info var)
	   (make-global-temp var)))
      (else
       (internal-error "get-info" "Not a variable" (shape var)))))
   
;*---------------------------------------------------------------------*/
;*    make-local-temp ...                                              */
;*---------------------------------------------------------------------*/
(define (make-local-temp local)
   (let ((new (make-temp)))
      (set! *all-functions* (cons local *all-functions*))
      (temp-seter?-set! new  #f)
      (local-info-set! local new)
      new))

;*---------------------------------------------------------------------*/
;*    make-global-temp ...                                             */
;*---------------------------------------------------------------------*/
(define (make-global-temp global)
   (let ((new (make-temp)))
      (set! *all-functions* (cons global *all-functions*))
      (temp-seter?-set!  new   #f)
      (global-info-set! global new)
      new))

;*---------------------------------------------------------------------*/
;*    save-call!                                                       */
;*---------------------------------------------------------------------*/
(define (save-call! owner callee w)
   (trace (loop effect)
	  "save-call!: " (shape owner) " <-> " (shape callee) #\Newline)
   (let ((W (if (global? callee)
		(if (mark-global-side-effect!? owner callee)
		    (cons owner W)
		    W)
		W)))
      (if (and (global? callee)
	       (or (eq? (global-import callee) 'import)
		   (eq? (global-import callee) 'foreign)))
	  ;; on ne marque pas ce genre d'application
	  W
	  (let ((owner-temp  (get-info owner))
		(callee-temp (get-info callee)))
	     (if (not (memq owner (temp-cfrom callee-temp)))
		 (begin
		    (temp-cfrom-set! callee-temp
				     (cons owner (temp-cfrom callee-temp)))
		    (temp-cto-set! owner-temp
				   (cons callee (temp-cto owner-temp)))))
	     W))))

;*---------------------------------------------------------------------*/
;*    mark-global-side-effect!? ...                                    */
;*---------------------------------------------------------------------*/
(define (mark-global-side-effect!? owner callee)
   (let ((sef? (cond
		  ((eq? (global-import callee) 'import)
		   (and (boolean? (function-sef? (global-value callee)))
			(function-sef? (global-value callee))))
		  ((eq? (global-import callee) 'foreign)
		   (and (boolean? (ffunction-sef? (global-value callee)))
			(ffunction-sef? (global-value callee))))
		  (else
		   #t))))
      (if sef?
	  #f
	  (let ((info (get-info owner)))
	     (if (temp-seter? info)
		 #f
		 (begin
		    (temp-seter?-set! info #t)
		    #t))))))

;*---------------------------------------------------------------------*/
;*    call-graph! ...                                                  */
;*---------------------------------------------------------------------*/
(define (call-graph! ast owner W)
   (ast-case ast
      ((atom)
       W)
      ((kwote)
       W)
      ((var)
       W)
      ((make-box)
       (call-graph! (make-box-value ast) owner W))
      ((box-ref)
       (call-graph! (box-ref-var ast) owner W))
      ((box-set!)
       (let ((temp (get-info owner)))
	  (if (not (temp-seter? temp))
	      (begin
		 (temp-seter?-set! temp #t)
		 (call-graph! (box-set!-value ast) owner (cons owner W)))
	      (call-graph! (box-set!-value ast) owner W))))
      ((prag-ma)
       (let loop ((values (prag-ma-values ast))
		  (W      W))
	  (if (null? values)
	      W
	      (loop (cdr values)
		    (call-graph! (car values) owner W)))))
      ((fail)
       (call-graph! (fail-proc ast)
		     owner
		     (call-graph! (fail-msg ast)
				  owner
				  (call-graph! (fail-obj ast)
					       owner
					       W))))
      ((sequence)
       (let loop ((exp (sequence-exp ast))
		  (W   W))
	  (if (null? exp)
	      W
	      (loop (cdr exp)
		    (call-graph! (car exp) owner W)))))
      ((conditional)
       (call-graph! (conditional-test ast)
		    owner
		    (call-graph! (conditional-then ast)
				 owner
				 (call-graph! (conditional-else ast)
					      owner
					      W))))
      ((switch)
       (let loop ((W       (call-graph! (switch-test ast) owner W))
		  (clauses (switch-clauses ast)))
	  (if (null? clauses)
	      W
	      (loop (call-graph! (cdr (car clauses)) owner W)
		    (cdr clauses)))))
      ((setq)
       (let ((temp (get-info owner)))
	  (if (not (temp-seter? temp))
	      (begin
		 (temp-seter?-set! temp #t)
		 (call-graph! (setq-val ast) owner (cons owner W)))
	      (call-graph! (setq-val ast) owner W))))
      ((let-var)
       (let loop ((bindings (let-var-bindings ast))
		  (W        W))
	  (if (null? bindings)
	      (call-graph! (let-var-body ast) owner W)
	      (loop (cdr bindings)
		    (call-graph! (cdr (car bindings)) owner W)))))
      ((let-fun)
       (for-each make-local-temp (let-fun-locals ast))
       (let loop ((locals (let-fun-locals ast))
		  (W      W))
	  (if (null? locals)
	      (call-graph! (let-fun-body ast) owner W)
	      (loop (cdr locals)
		    (call-graph! (function-body (local-value (car locals)))
				 (car locals)
				 W)))))
      ((set-ex-it)
       (call-graph! (set-ex-it-body ast) owner W))
      ((jump-ex-it)
       (call-graph! (jump-ex-it-value ast) owner W))
      ((fun)
       W)
      ((app-ly)
       (let ((temp (get-info owner)))
	  (if (not (temp-seter? temp))
	      (begin
		 (temp-seter?-set! temp #t)
		 (call-graph! (app-ly-fun ast)
			      owner
			      (call-graph! (app-ly-value ast)
					   owner
					   (cons owner W))))
	      (call-graph! (app-ly-fun ast)
			   owner
			   (call-graph! (app-ly-value ast) owner W)))))
      ((funcall)
       (let ((temp (get-info owner)))
	  (if (not (temp-seter? temp))
	      (begin
		 (temp-seter?-set! temp #t)
		 (call-args-graph! (funcall-fun ast)
				   (funcall-actuals ast)
				   owner
				   (cons owner W)))
	      (call-args-graph! (funcall-fun ast)
				(funcall-actuals ast)
				owner
				W))))
       ((app)
	(call-args-graph! (app-fun ast)
			  (app-actuals ast)
			  owner
			  (save-call! owner (var-variable (app-fun ast)) W)))))

;*---------------------------------------------------------------------*/
;*    call-args-graph! ...                                             */
;*---------------------------------------------------------------------*/
(define (call-args-graph! fun args owner W)
   (let loop ((args args)
	      (W    W))
      (if (null? args)
	  (call-graph! fun owner W)
	  (loop (cdr args)
		(call-graph! (car args) owner W)))))
