;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.8/Effect/effect.scm        */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Jul 13 13:46:44 1995                          */
;*    Last change :  Tue Feb  6 17:10:43 1996 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The effect property                                              */
;*    -------------------------------------------------------------    */
;*    It is optional to have run the Effect pass before invoking       */
;*    this function. Nevertheless, firstly invoking Effect pass        */
;*    leads to better approximations.                                  */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module effect_effect
   (include "Tools/trace.sch"
	    "Ast/node.sch")
   (import  tools_shape
	    effect_walk)
   (export  (side-effect-free? ast)))

;*---------------------------------------------------------------------*/
;*    side-effect-free? ...                                            */
;*---------------------------------------------------------------------*/
(define (side-effect-free? ast)
   (ast-case ast
      ((atom)
       #t)
      ((kwote)
       #t)
      ((var)
       #t)
      ((make-box)
       #f)
      ((box-ref)
       #t)
      ((box-set!)
       #f)
      ((prag-ma)
       #f)
      ((fail)
       #f)
      ((sequence)
       (sequence-side-effect-free? ast))
      ((conditional)
       (conditional-side-effect-free? ast))
      ((switch)
       (switch-side-effect-free? ast))
      ((setq)
       #f)
      ((let-var)
       (let-var-side-effect-free? ast))
      ((let-fun)
       (let-fun-side-effect-free? ast))
      ((set-ex-it)
       #f)
      ((jump-ex-it)
       #f)
      ((fun)
       #t)
      ((app-ly)
       #f)
      ((funcall)
       #f)
      ((app)
       (app-side-effect-free? ast))))

;*---------------------------------------------------------------------*/
;*    sequence-side-effect-free? ...                                   */
;*---------------------------------------------------------------------*/
(define (sequence-side-effect-free? ast)
   (and *effect-done?*
	(let loop ((exp (sequence-exp ast)))
	   (cond
	      ((null? exp)
	       #t)
	      ((side-effect-free? (car exp))
	       (loop (cdr exp)))
	      (else
	       #f)))))

;*---------------------------------------------------------------------*/
;*    conditional-side-effect-free? ...                                */
;*---------------------------------------------------------------------*/
(define (conditional-side-effect-free? ast)
   (and *effect-done?*
	(side-effect-free? (conditional-test ast))
	(side-effect-free? (conditional-then ast))
	(side-effect-free? (conditional-else ast))))

;*---------------------------------------------------------------------*/
;*    switch-side-effect-free? ...                                     */
;*---------------------------------------------------------------------*/
(define (switch-side-effect-free? ast)
   (and *effect-done?*
	(side-effect-free? (switch-test ast))
	(let loop ((clause (switch-clauses ast)))
	   (cond
	      ((null? clause)
	       #t)
	      ((side-effect-free? (cdr (car clause)))
	       (loop (cdr clause)))
	      (else
	       #f)))))

;*---------------------------------------------------------------------*/
;*    let-var-side-effect-free? ...                                    */
;*---------------------------------------------------------------------*/
(define (let-var-side-effect-free? ast)
   (and *effect-done?*
	(side-effect-free? (let-var-body ast))
	(let loop ((bindings (let-var-bindings ast)))
	   (cond
	      ((null? bindings)
	       #t)
	      ((side-effect-free? (cdr (car bindings)))
	       (loop (cdr bindings)))
	      (else
	       #f)))))

;*---------------------------------------------------------------------*/
;*    let-fun-side-effect-free? ...                                    */
;*---------------------------------------------------------------------*/
(define (let-fun-side-effect-free? ast)
   (and *effect-done?*
	(side-effect-free? (let-fun-body ast))
	(let loop ((locals (let-fun-locals ast)))
	   (cond
	      ((null? locals)
	       #t)
	      ((side-effect-free? (function-body (local-value (car locals))))
	       (loop (cdr locals)))
	      (else
	       #f)))))

;*---------------------------------------------------------------------*/
;*    app-side-effect-free? ...                                        */
;*---------------------------------------------------------------------*/
(define (app-side-effect-free? ast)
   (and *effect-done?*
	(function-side-effect-free? (var-variable (app-fun ast)))
	(let loop ((actuals (app-actuals ast)))
	   (cond
	      ((null? actuals)
	       #t)
	      ((side-effect-free? (car actuals))
	       (loop (cdr actuals)))
	      (else
	       #f)))))
	       
;*---------------------------------------------------------------------*/
;*    function-side-effect-free? ...                                   */
;*---------------------------------------------------------------------*/
(define (function-side-effect-free? var)
   (let ((fun (variable-value var)))
      (cond
	 ((function? fun)
	  (and (boolean? (function-sef? fun))
	       (function-sef? fun)))
	 ((ffunction? fun)
	  (and (boolean? (ffunction-sef? fun))
	       (ffunction-sef? fun)))
	 (else
	  #f))))
