;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.8/Globalize/cache.scm      */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Fri Mar 24 11:55:20 1995                          */
;*    Last change :  Fri Apr  7 13:47:49 1995 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The globalization cache.                                         */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module globalize_cache
   (import  ast_global)
   (export  (init-globalize-cache!)
	    (stop-globalize-cache!)
	    *make-fx-procedure*
	    *make-va-procedure*
	    *procedure-set!*))

;*---------------------------------------------------------------------*/
;*    A little cache for the library function: make-cell               */
;*---------------------------------------------------------------------*/
(define *make-fx-procedure*     #f)
(define *make-va-procedure*     #f)
(define *procedure-set!*        #f)

;*---------------------------------------------------------------------*/
;*    init-globalize-cache ...                                         */
;*---------------------------------------------------------------------*/
(define (init-globalize-cache!)
   (set! *make-fx-procedure*
	 (require-global 'make-fx-procedure #f #f))
   (set! *make-va-procedure*
	 (require-global 'make-va-procedure #f #f))
   (set! *procedure-set!*
	 (require-global 'procedure-set! #f #f))
   #t)

;*---------------------------------------------------------------------*/
;*    stop-globalize-cache! ...                                        */
;*---------------------------------------------------------------------*/
(define (stop-globalize-cache!)
   #t)
  

