;*=====================================================================*/
;*    .../prgm/project/bigloo/comptime1.8/Globalize/globalize.sch      */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Jan 26 15:07:56 1995                          */
;*    Last change :  Mon Jul 24 17:48:05 1995 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The structure used by the globalization process                  */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The `fin-Ginfo' structure ...                                    */
;*---------------------------------------------------------------------*/
(define-struct fun-Ginfo
   G?                 ;;  boolean       : is a function globalized
   cfrom              ;;  variable*     : the list of called by functions
   cfrom*             ;;  variable*     : transitive closure of cfrom
   cto                ;;  variable*     : the list of called functions
   cto*               ;;  variable*     : transitive closure of cto
   cfunction          ;;  variable*     : the list of E functions
   integrator         ;;  sexp          : a place to be integrated
   integrated         ;;  local*        : a list a integrated functions
   plugged-in         ;;  variable      : where is it plugged
   mark               ;;  sexp          : a mark for the integration
   free-mark          ;;  sexp          : a free search mark
   the-closure        ;;  local         : a closure
   the-global         ;;  global        : the globalized function
   kaptured           ;;  local*        : the kaptured variables
   new-body           ;;  ast           : a globalized new-body
   bmark              ;;  integer       : used in `globalize_new-body'
   umark              ;;  sexp          : union mark
   free               ;;  local*        : the free variable list
   bound)             ;;  local*        : the bound variable list

(define (default-fun-Ginfo)
   (fun-Ginfo #f           ;;  G?            
	      '()          ;;  cfrom         
	      '#f          ;;  cfrom*         
	      '()          ;;  cto           
	      '#f          ;;  cto*
	      '()          ;;  cfunction
	      '()          ;;  integrator    
	      '()          ;;  integrated
	      '()          ;;  plugged-in
	      -10          ;;  mark          
	      '()          ;;  free-mark     
	      #f           ;;  the-closure
	      #f           ;;  the-global
	      #f           ;;  kaptured      
	      #f           ;;  new-body
	      -10          ;;  bmark
	      -10          ;;  umark
	      #unspecified ;; free
	      '()))        ;;  bound

;*---------------------------------------------------------------------*/
;*    var-Ginfo                                                        */
;*---------------------------------------------------------------------*/
(define-struct var-Ginfo
   kaptured?          ;;  boolean       : is the variable captured
   free-mark          ;;  sexp          : a free search mark
   mark)              ;;  sexp          : a mark for the free var computation

(define (default-var-Ginfo)
   (var-Ginfo #f      ;;  kaptured?
	      -10     ;;  free-mark
	      -10))   ;;  mark

