;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.8/Lifext/walk.scm          */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Mon May  8 18:29:16 1995                          */
;*    Last change :  Wed Oct 11 11:40:19 1995 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The purpose of this pass is to re-write the ast to help          */
;*    the mapping of heap allocation to stack allocation. This         */
;*    pass only proceed the following translation:                     */
;*                                                                     */
;*       (let ((x (let ((y A))                                         */
;*    	       ...                                                     */
;*    	       y)))                                                    */
;*          ...                                                        */
;*          )                                                          */
;*                                                                     */
;*         ==>                                                         */
;*                                                                     */
;*       (let ((y A))                                                  */
;*          ...                                                        */
;*          (let ((x y))                                               */
;*    	       ...                                                     */
;*    	       )                                                       */
;*          )                                                          */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module lifext_walk
   (include "Tools/pass.sch"
	    "Ast/node.sch")
   (import  tools_shape
	    ast_global
	    ast_local
	    ast_dump
	    engine_param)
   (export  (lifext-walk! tree)))

;*---------------------------------------------------------------------*/
;*    lifext-walk! ...                                                 */
;*---------------------------------------------------------------------*/
(define (lifext-walk! ast)
   (pass-prelude "Lifext")
   (for-each lifext-fun! ast)
   (pass-postlude ast))

;*---------------------------------------------------------------------*/
;*    lifext-fun! ...                                                  */
;*---------------------------------------------------------------------*/
(define (lifext-fun! var)
   (let* ((fun  (variable-value var))
	  (body (function-body fun)))
      (function-body-set! fun (lifext-ast body))))

;*---------------------------------------------------------------------*/
;*    lifext-ast ...                                                   */
;*---------------------------------------------------------------------*/
(define (lifext-ast ast)
   (ast-case ast
      ((atom)
       ast)
      ((var)
       ast)
      ((kwote)
       ast)
      ((sequence)
       (let loop ((asts (sequence-exp ast)))
          (if (null? asts)
              ast
              (begin
                 (set-car! asts (lifext-ast (car asts)))
                 (loop (cdr asts))))))
      ((make-box)
       (make-box-value-set! ast (lifext-ast (make-box-value ast)))
       ast)
      ((box-ref)
       (box-ref-var-set! ast (lifext-ast (box-ref-var ast)))
       ast)
      ((box-set!)
       (box-set!-var-set! ast (lifext-ast (box-set!-var ast)))
       (box-set!-value-set! ast (lifext-ast (box-set!-value ast)))
       ast)
      ((setq)
       (setq-val-set! ast (lifext-ast (setq-val ast)))
       ast)
      ((conditional)
       (conditional-test-set! ast (lifext-ast (conditional-test ast)))
       (conditional-then-set! ast (lifext-ast (conditional-then ast)))
       (conditional-else-set! ast (lifext-ast (conditional-else ast)))
       ast)
      ((fail)
       (fail-proc-set! ast (lifext-ast (fail-proc ast)))
       (fail-msg-set! ast (lifext-ast (fail-msg ast)))
       (fail-obj-set! ast (lifext-ast (fail-obj ast)))
       ast)
      ((let-fun)
       (let-fun-body-set! ast (lifext-ast (let-fun-body ast)))
       (for-each lifext-fun! (let-fun-locals ast))
       ast)
      ((let-var)
       (lifext-let-var! ast))
      ((app-ly)
       (app-ly-fun-set! ast (lifext-ast (app-ly-fun ast)))
       (app-ly-value-set! ast (lifext-ast (app-ly-value ast)))
       ast) 
      ((funcall)
       (funcall-fun-set! ast (lifext-ast (funcall-fun ast)))
       (let loop ((actuals (funcall-actuals ast)))
	  (if (null? actuals)
	      ast
	      (begin
		 (set-car! actuals (lifext-ast (car actuals)))
		 (loop (cdr actuals))))))
      ((fun)
       (internal-error "do-set-recursive-call!"
		       "Illegal node (see `Bivaluation' pass)"
		       (ast->sexp ast)))
      ((app)
       (let loop ((actuals (app-actuals ast)))
	  (if (null? actuals)
	      ast
	      (begin
		 (set-car! actuals (lifext-ast (car actuals)))
		 (loop (cdr actuals))))))
      ((set-ex-it)
       (set-ex-it-body-set! ast (lifext-ast (set-ex-it-body ast)))
       ast)
      ((jump-ex-it)
       (jump-ex-it-exit-set! ast (lifext-ast (jump-ex-it-exit ast)))
       (jump-ex-it-value-set! ast (lifext-ast (jump-ex-it-value ast)))
       ast)
      ((switch)
       (switch-test-set! ast (lifext-ast (switch-test ast)))
       (for-each (lambda (clause)
                    (set-cdr! clause (lifext-ast (cdr clause))))
                 (switch-clauses ast))
       ast)
      ((prag-ma)
       (let loop ((asts (prag-ma-values ast)))
          (if (null? asts)
              ast
              (begin
                 (set-car! asts (lifext-ast (car asts)))
                 (loop (cdr asts))))))))
	       
;*---------------------------------------------------------------------*/
;*    lifext-let-var! ...                                              */
;*---------------------------------------------------------------------*/
(define (lifext-let-var! ast)
   (let-var-body-set! ast (lifext-ast (let-var-body ast)))
   (let loop ((res      ast)
	      (bindings (let-var-bindings ast)))
      (if (null? bindings)
	  res
	  (let ((binding (car bindings)))
	     (set-cdr! binding (lifext-ast (cdr binding)))
	     (ast-case (cdr binding)
		((let-var)
		 (let ((lbody (let-var-body (cdr binding)))
		       (lbind (let-var-bindings (cdr binding))))
		    (cond
		       ((null? lbind)
			(loop res (cdr bindings)))
		       ((pair? (cdr lbind))
			(loop res (cdr bindings)))
		       ((not (sequence? lbody))
			(loop res (cdr bindings)))
		       (else
			(let* ((sexp (sequence-exp lbody))
			       (last (car (last-pair sexp))))
			   (ast-case last
			      ((var)
			       (if (eq? (var-variable last) (car (car lbind)))
				   (let ((new-res (cdr binding)))
				      (set-car! (last-pair sexp) res)
				      (set-cdr! binding last)
				      (loop new-res (cdr bindings)))
				   (loop res (cdr bindings))))
			      (else
			       (loop res (cdr bindings)))))))))
		(else
		 (loop res (cdr bindings))))))))

