;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.8/Parse/src.scm            */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Mon Dec 26 11:14:32 1994                          */
;*    Last change :  Mon Mar 11 13:50:36 1996 (serrano)                */
;*    -------------------------------------------------------------    */
;*    We parse a source file (to check the soundess of the module      */
;*    declaration).			                               */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module parse_src
   (include "Tools/pass.sch"
	    "Tools/trace.sch")
   (import  parse_type
	    parse_import
	    parse_static-export
	    parse_with
	    parse_cforeign
	    parse_include
	    parse_load
	    eval_parse
	    tools_error
	    ast_pragma
	    engine_param
	    engine_engine
	    main
	    heap_restore
	    ast_env
	    type_env
	    read_access
	    read_inline
	    cforeign_export)
   (export  (parse-src module.body)))

;*---------------------------------------------------------------------*/
;*    parse-src ...                                                    */
;*---------------------------------------------------------------------*/
(define (parse-src module.body)
   (let ((module (car module.body))
	 (body   (cdr module.body)))
      (match-case module
	 ((module (and (? symbol?) ?module-name) . ?clauses)
	  ;; first, the source file name
	  (hello-world)
	  (set! *module-name* module-name)
	  ;; we store the module definition in order to be able
	  ;; to print expanded module rather than expanded code
	  (set! *module-clause* module)
	  (append (parse-module-clauses clauses) body))
	 (else
	  (if *bigloo-interpreter*
	      ;; in fact, we just want to interprete the file. We reach
	      ;; this point when the source file start by
	      ;; #!/usr/local/bin/bigloo (or something like that).
	      (begin
		 (set! *interpreter* #t)
		 (exit-bigloo (bigloo)))
	      ;; no, it is a parse error
	      (begin
		 ;; we display the source file name
		 (hello-world)
		 (user-error "Parse error"
			     "Illegal module declaration"
			     module)))))))

;*---------------------------------------------------------------------*/
;*    parse-module-clauses ...                                         */
;*---------------------------------------------------------------------*/
(define (parse-module-clauses clauses)
   ;; we read access file
   (read-access-file)
   ;; now, we restore the compilation heap
   (if (or *lib-mode* (not (restore-heap)))
       ;; or we build environments
       (begin
	  (initialize-Genv!)
	  (initialize-Tenv!)))
   ;; we are just able now to print the pass prelude
   (pass-prelude "Read")
   ;; we start parsing
   (trace read "Parse-module-clauses" #\Newline)
   (let loop ((module-clauses clauses)
	      (import         '())
	      (use            '())
	      (export         '())
	      (static         '())
	      (C-foreign      '())
	      (include        *bigloo-user-includes*)
	      (with           '())
	      (pragma         '())
	      (eval           (if (and (integer? *compiler-debug*)
				       (>=fx *compiler-debug* 4))
				  (list '(export-all))
				  '()))
	      (type           '()))
      (if (null? module-clauses)
	  (let* ((include-read      (parse-include (reverse include)))
		 ;; parse include returns multiple-values...
		 (include-import    (vector-ref include-read 0))
		 (include-C-foreign (vector-ref include-read 1))
		 (include-body      (vector-ref include-read 2))
		 (include-type      (vector-ref include-read 3))
		 (include-export    (vector-ref include-read 4))
		 (include-use       (vector-ref include-read 5))
		 (include-with      (vector-ref include-read 6)))
	     ;; First of all, we parse type definition...
	     (trace read "Parse-type..." #\Newline)
	     (parse-type (append include-type type))
	     ;; we parse the use clause
	     (trace read "Parse-use..." #\Newline)
	     (parse-import/use (reverse (append use include-use))
			       'use)
	     ;; we parse the import clause,
	     (trace read "Parse-import..." #\Newline)
	     (parse-import/use (reverse (append import include-import))
			       'import)
	     ;; then the static and exported clauses
	     (trace read "Parse-export..." #\Newline)
	     (parse-export (append include-export export))
	     (trace read "Parse-static..." #\Newline)
	     (parse-static static)
	     (trace read "Parse-eval..." #\Newline)
	     (parse-eval eval)
	     (trace read "Parse-c-foreign..." #\Newline)
	     (parse-c-foreign (append include-C-foreign C-foreign)
			      'export) 
	     (trace read "Parse-with..." #\Newline)
	     (parse-with (append include-with with))
	     (trace read "Parse-main..." #\Newline)
	     (parse-main *main*)
	     (parse-pragmas! pragma *module-name*)
	     ;; we set target name of global foreign exported variable
	     (patch-foreign-exported!)
	     ;; we return the top-level expressions of the included files
	     (reverse include-body))
	  (let ((clause (car module-clauses)))
	     (if (not (pair? clause))
		 (user-error "Parse error" "Illegal module clause" clause)
		 (case (car clause)
		    ((main)
		     (if (null? (cdr clause))
			 (user-error "Parse error"
				     "Illegal main clause"
				     clause)
			 (if (not (string? *main*))
			     (set! *main* (cadr clause))))
		     (loop (cdr module-clauses) import use export
			   static C-foreign include with pragma
			   eval type))
		    ((import)
		     ;; the imported list module is built on reverse
		     ;; order. This is normal
		     (loop (cdr module-clauses)
			   (append (cdr clause) import)
			   use export static C-foreign
			   include with pragma eval type))
		    ((load)
		     (parse-load clause)
		     (loop (cdr module-clauses)
			   import use export static C-foreign
			   include with pragma eval type))
		    ((use)
		     (loop (cdr module-clauses)
			   import
			   (append (cdr clause) use)
			   export static C-foreign
			   include with pragma eval type))
		    ((force)
		     (user-error "force" "no more supported" clause)
		     (loop (cdr module-clauses)
			   import use
			   export static C-foreign
			   include with pragma eval type))
		    ((export)
		     (loop (cdr module-clauses)
			   import use
			   (append (cdr clause) export)
			   static C-foreign include with pragma
			   eval type))
		    ((static)
		     (loop (cdr module-clauses)
			   import use export
			   (append (cdr clause) static)
			   C-foreign include with pragma
			   eval type))
		    ((C foreign)
		     ;; C foreign clauses have two name (for historical
		     ;; reason).
		     (loop (cdr module-clauses)
			   import use export static
			   (append C-foreign (cdr clause))
			   include with pragma eval type))
		    ((with)
		     (loop (cdr module-clauses)
			   import use export static C-foreign include
			   (append (cdr clause) with)
			   pragma eval type))
		    ((include)
		     (loop (cdr module-clauses)
			   import use export static C-foreign
			   (append (reverse (cdr clause)) include)
			   with pragma eval type))
		    ((pragma)
		     (loop (cdr module-clauses)
			   import use export static C-foreign include with
			   (append (cdr clause) pragma) eval type))
		    ((eval)
		     (loop (cdr module-clauses)
			   import use export static C-foreign include with
			   pragma
			   (append (cdr clause) eval) type))
		    ((type)
		     (loop (cdr module-clauses)
			   import use export static C-foreign include with
			   pragma
			   eval
			   (append (cdr clause) type)))
		    (else
		     (user-error "Parse error"
				 "Illegal module clause"
				 clause))))))))



      
      
