;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.8/Tstruct/install.scm      */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Oct  4 12:00:24 1995                          */
;*    Last change :  Tue Jan 30 09:01:01 1996 (serrano)                */
;*    -------------------------------------------------------------    */
;*    We install all the coercer and accessor for `tstruct' types.     */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module tstruct_install
   (include "Type/type.sch"
	    "Tstruct/tstruct.sch"
	    "Tools/trace.sch")
   (import  parse_cforeign
	    ast_pragma
	    type_env
	    type_coercion
	    tstruct_declare
	    engine_param)
   (export  (install-tstruct-accessors-and-coercers!)
	    (install-tstruct-accessors tv)))

;*---------------------------------------------------------------------*/
;*    install-tstruct-accessors-and-coercers! ...                      */
;*---------------------------------------------------------------------*/
(define (install-tstruct-accessors-and-coercers!)
   (let loop ((tstructs (get-tstruct-list))
	      (new-code '()))
      (if (null? tstructs)
	  (begin
	     (trace init
		    "-------------------------------------------"
		    #\Newline
		    "install-tstruct-accessors-and-coercers!:"
		    #\Newline)
	     (for-each (lambda (x)
			  (trace init x #\Newline))
		       new-code)
	     (trace init #\Newline)
	     new-code)
	  (loop (cdr tstructs)
		(append (install-tstruct-accessors (car tstructs))
			new-code)))))

;*---------------------------------------------------------------------*/
;*    install-tstruct-accessors ...                                    */
;*    -------------------------------------------------------------    */
;*    For each `tstruct' `ts' , we produce several inlines and         */
;*    several foreign.                                                 */
;*---------------------------------------------------------------------*/
(define (install-tstruct-accessors ts)
   (let* ((id            (type-id ts))
	  (info          (type-tinfo ts))
	  (ts-name       (tstruct-info-c-type-name info))
	  (slots-type-id (tstruct-info-slots-type-id info))
	  (slots-type    (map find-type slots-type-id))
	  (slots-name    (tstruct-info-slots-name info))
	  (obj           (find-type 'obj))
	  (ts->vector    (symbol-append id '->vector))
	  (vector->ts    (symbol-append 'vector-> id))
	  (allocate      (symbol-append 'allocate- id)))
      (define (make-ts?)
	 `(define-inline (,(symbol-append id '?::bool) o::obj)
	     (if (tstruct? o)
		 (eq? (tstruct-id o) ',id)
		 #f)))
      (define (make-ts)
	 (let ((new (gensym 'new)))
	    `(define-inline (,(symbol-append id ':: id)
		      ,@(map (lambda (n t)
				(symbol-append n ':: t))
			     slots-name slots-type-id))
		(let ((,new (,allocate (pragma ,ts-name) ',id ,ts->vector)))
		   ,@(map (lambda (n)
			     `(,(symbol-append id '- n '-set!) ,new ,n))
			  slots-name)
		   ,new))))
      (define (make-c-refs)
	 (let ((ts (gensym 'ts)))
	    (map (lambda (name type)
		    `(macro ,type
			,(symbol-append 'c- id '- name)
			(obj ,id obj)
			"TSTRUCT_REF"))
		 slots-name slots-type-id)))
      (define (make-c-sets)
	 (let ((ts (gensym 'ts)))
	    (map (lambda (name type)
		    `(macro obj
			,(symbol-append 'c- id '- name '-set!)
			(obj ,id obj ,type)
			"TSTRUCT_SET"))
		 slots-name slots-type-id)))
      (define (make-refs)
	 (let ((ts (gensym 'ts)))
	    (map (lambda (name type)
		    (let* ((sname (symbol-append id '- name ':: type))
			   (cname (symbol-append 'c- id '- name )))
		       `(define-inline (,sname ,(symbol-append ts ':: id))
			   (,cname (pragma ,ts-name)
				   ,ts
				   (pragma ,(symbol->string name))))))
		 slots-name slots-type-id)))
      (define (make-sets)
	 (let ((ts  (gensym 'ts))
	       (val (gensym 'val)))
	    (map (lambda (name type)
		    (let* ((sname (symbol-append id '- name '-set!::obj))
			   (cname (symbol-append 'c- id '- name '-set!)))
		       `(define-inline (,sname
					,(symbol-append ts ':: id)
					,(symbol-append val ':: type))
			   (,cname (pragma ,ts-name)
				   ,ts
				   (pragma ,(symbol->string name))
				   ,val))))
		 slots-name slots-type-id)))
      (define (make-ts->vector)
	 `(define (,(symbol-append ts->vector '::vector)
		   ,(symbol-append 'ts:: id))
	     (let ((new (c-create-vector ,(length slots-name))))
		,(let loop ((names  slots-name)
			    (offset 0)
			    (res    '()))
		    (if (null? names)
			`(begin ,@res new)
			(loop (cdr names)
			      (+fx offset 1)
			      (cons `(c-vector-set!
				      new
				      ,offset
				      (,(symbol-append id '- (car names))
				       ts))
				    res)))))))
      (define (make-vector->ts)
	 `(define (,(symbol-append vector->ts ':: id) vect::vector)
	     (let ((new (,allocate (pragma ,ts-name) ',id ,ts->vector)))
		(if (=fx (vector-length vect) ,(length slots-name))
		    ,(let loop ((names  slots-name)
				(offset 0)
				(res    '()))
			(if (null? names)
			    `(begin ,@res new)
			    (loop (cdr names)
				  (+fx offset 1)
				  (cons `(,(symbol-append id
							  '-
							  (car names)
							  '-set!)
					  new
					  (c-vector-ref vect ,offset))
					res))))
		    (if (>fx (vector-length vect) ,(length slots-name))
			(error ',vector->ts "vector too large" vect)
			(error ',vector->ts "vector too small" vect))))))
      (define (make-c-allocate-ts)
	 `(macro ,id ,allocate (obj obj obj) "ALLOCATE_TSTRUCT"))
      (parse-c-foreign (cons (make-c-allocate-ts)
			     (append (make-c-refs) (make-c-sets)))
		       'export)
      (append (list (make-ts?)
		    (make-ts)
		    (make-ts->vector)
		    (make-vector->ts))
	      (make-refs)
	      (make-sets))))

	 
				  
      
	     
	     
	 
