;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.8/Type/cache.scm           */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Jan 18 11:28:43 1995                          */
;*    Last change :  Mon Jan 22 15:09:19 1996 (serrano)                */
;*    -------------------------------------------------------------    */
;*    A small type cache to avoid to many lookup in Tenv.              */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module type_cache
   (import type_env)
   (export (make-type-cache!)
           *obj*
	   *cell*
	   *magic*
	   *void*
	   *bint*
	   *int*
	   *long*
	   *bool*
	   *real*
	   *char*
	   *bnil*
	   *pair*
	   *string*
	   *symbol*
	   *vector*
	   *unspec*
	   *procedure*
	   *exit*))

;*---------------------------------------------------------------------*/
;*    make-type-cache! ...                                             */
;*---------------------------------------------------------------------*/
(define (make-type-cache!)
   (set! *obj*        (find-type 'obj))
   (set! *cell*       (find-type 'cell))
   (set! *magic*      (find-type 'magic))
   (set! *void*       (find-type 'void))
   (set! *bint*       (find-type 'bint))
   (set! *int*        (find-type 'int))
   (set! *long*       (find-type 'long))
   (set! *bool*       (find-type 'bool))
   (set! *real*       (find-type 'double))
   (set! *char*       (find-type 'uchar))
   (set! *pair*       (find-type 'pair))
   (set! *bnil*       (find-type 'nil))
   (set! *string*     (find-type 'string))
   (set! *symbol*     (find-type 'symbol))
   (set! *vector*     (find-type 'vector))
   (set! *procedure*  (find-type 'procedure))
   (set! *unspec*     (find-type 'unspecified))
   (set! *exit*       (find-type 'exit)))

;*---------------------------------------------------------------------*/
;*    The register cache                                               */
;*---------------------------------------------------------------------*/
(define *obj*        #unspecified)
(define *cell*       #unspecified)
(define *magic*      #unspecified)
(define *void*       #unspecified)
(define *bint*       #unspecified)
(define *int*        #unspecified)
(define *long*       #unspecified)
(define *bool*       #unspecified)
(define *real*       #unspecified)
(define *char*       #unspecified)
(define *string*     #unspecified)
(define *symbol*     #unspecified)
(define *pair*       #unspecified)
(define *bnil*       #unspecified)
(define *vector*     #unspecified)
(define *procedure*  #unspecified)
(define *unspec*     #unspecified)
(define *exit*       #unspecified)
