;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/recette/string.scm                   */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue Nov  3 10:18:56 1992                          */
;*    Last change :  Wed Aug 30 10:05:32 1995 (serrano)                */
;*                                                                     */
;*    On test differentes operations sur les chaines de characteres    */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module string
   (import  (main "main.scm"))
   (include "test.sch")
   (export  (test-string)))

(define (scheme-id->c-id string)
   (let* ((nstring (if (and (not (char-alphabetic? (string-ref string 0)))
			    (not (char=? (string-ref string 0) #\_)))
		       (string-append "_" string)
		       string))
	  (len     (string-length nstring))
	  (rg      #f)
	  (res     (make-string len)))
      (let loop ((i 0))
	 (if (=fx i len)
	     (remove__ (if rg
			   (string-append
			    (string-downcase res)
			    (string-append
			     "_"
			     (integer->string 7)))
			   (string-downcase res)))
	     (let ((c (string-ref nstring i)))
		(cond
		   ((or (and (char>=? c #\A)
			     (char<=? c #\Z))
			(and (char>=? c #\a)
			     (char<=? c #\z))
			(and (char>=? c #\0)
			     (char<=? c #\9))
			(char=? c #\_))
		    (string-set! res i (string-ref nstring i))
		    (loop (+fx i 1)))
		   (else
		    (set! rg #t)
		    (string-set! res i #\_) 
		    (loop (+fx i 1)))))))))

(define (remove__ string)
   (cond
      ((not (>=fx (string-length string) 6))
       string)
      ((not (char=? (string-ref string 0) #\_))
       string)
      ((not (char=? (string-ref string 1) #\_))
       string)
      ((and (not (char=? (string-ref string 2) #\i))
	    (not (char=? (string-ref string 2) #\f)))
       string)
      ((and (not (char=? (string-ref string 3) #\n))
	    (not (char=? (string-ref string 3) #\i)))
       string)
      ((and (not (char=? (string-ref string 4) #\i))
	    (not (char=? (string-ref string 4) #\n)))
       string)
      ((and (not (char=? (string-ref string 5) #\t))
	    (not (char=? (string-ref string 5) #\i)))
       string)
      ((not (char=? (string-ref string 6) #\_))
       string)
      (else
       (string-append "_n_o_f_u_c_k_i_n_g___init_or_fini" string))))

;*---------------------------------------------------------------------*/
;*    test-string ...                                                  */
;*---------------------------------------------------------------------*/
(define (test-string)
   (test-module "string" "string.scm" #f)
   (test "string=?" (string=? "toto n'est pas content"
			      "toto n'est pas content")
	 #t)
   (test "string=?" (string=? "ToTo" "tOtO") #f)
   (test "string=?" (let ((s (make-string 3 (integer->char 0))))
		       (string=? s #"\000\000\000"))
	 #t)
   (test "string=?" (let ((s (make-string 3 (integer->char 0))))
		       (string=? s #"\000\001\000"))
	 #f)
   (test "string-length" (string-length "12345") 5)
   (test "string" (equal? "toto n'est pas content" "toto est content")
	 #f)
   (test "make-string" (string-ref (make-string 1 #\a) 0) #\a)
   (test "string-append" (string-append "Toto " "est content")
	 "Toto est content")
   (test "string-append" (string-append "toto" " n'est" " pas" " content")
	 "toto n'est pas content")
   (test "string-upcase" (string-upcase "toto TOTO ToTo") "TOTO TOTO TOTO")
   (test "string-ci=?"     (string-ci=? "Toto" "tOtO") #t)
   (test "string-set"    (let ((s (string-copy "0123456789")))
			    (string-set! s 0 (string-ref s 1))
			    s)
	 "1123456789")
   (test "list->string" (list->string '(#\t #\o #\t #\o)) "toto")
   (test "string->list" (string->list "toto") '(#\t #\o #\t #\o))
   (test "string->integer" (string->integer "01234") 1234)
   (test "integer->string" (integer->string 1234) "1234")
   (test "string->real" (string->real "1234.25") 1234.25)
   (test "real->string" (real->string 1234.25) "1234.25")
   (test "substring" (substring "0123456789" 1 5) "1234")
   (let ((dst (make-string 10 #\0))
	 (src (make-string 5 #\1)))
      (test "blit-string" (begin (blit-string! src 1 dst 1 3)
				 dst)
	    "0111000000"))
   (test "string<?" (string<? "012345" "123456") #t)
   (test "string<=?" (string<=? "012345" "012345") #t)
   (test "string>?" (string>? "012345" "123456") #f)
   (test "string>=?" (string<=? "012345" "012345") #t)
   (test "string-ci<?" (string-ci<? "abcdef" "ABCDEF") #f)
   (test "string-ci<?" (string-ci<? "abcdef" "ABCDEG") #t)
   (test "string-ci<=?" (string-ci<=? "abcdef" "ABCDEG") #t)
   (test "string-ci<=?" (string-ci<=? "abcdef" "ABCDEG") #t)
   (test "string-ci>?" (string-ci>? "abcdef" "ABCDEG") #f)
   (test "string-ci>?" (string-ci>? "abcdef" "ABCDEG") #f)
   (test "string-ci>=?" (string-ci>=? "abcdef" "ABCDEG") #f)
   (test "string-ci>=?" (string-ci>=? "abcdef" "ABCDEF") #t)
   (test "foreign" (let ((x "\n\t\\\"")) (string->list x)) '(#\n #\t #\\ #\"))
   (test "foreign" (let ((x #"\n\\\"")) (string->list x))
	 '(#\newline #\\ #\"))
   (test "symbol" (symbol->string (string->symbol "tOtO")) "tOtO")
   (test "symbol" (eq? (string->symbol "ToTo") 'toto) #f)
   (test "symbol" (eq? (string->symbol "TOTO") 'toto) #t)
   (test "string-copy" (string-copy "toto n'est pas content")
	 "toto n'est pas content")
   (test "escape" (string-length #"\000") 1)
   (test "escape" (char->integer (string-ref #"\000" 0)) 0)
   (test "escape" (char->integer (string-ref #"\003" 0)) 3)
   (test "id"
	 (scheme-id->c-id "INITIALIZE-IMPORTED-MODULES!_FOO")
	 "initialize_imported_modules__foo_7"))
   


	 
