/*---------------------------------------------------------------------*/
/*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
/*                                                                     */
/*                                     ,--^,                           */
/*                               _ ___/ /|/                            */
/*                           ,;'( )__, ) '                             */
/*                          ;;  //   L__.                              */
/*                          '   \    /  '                              */
/*                               ^   ^                                 */
/*                                                                     */
/*                                                                     */
/*    This program is distributed in the hope that it will be useful.  */
/*    Use and copying of this software and preparation of derivative   */
/*    works based upon this software are permitted, so long as the     */
/*    following conditions are met:                                    */
/*           o credit to the authors is acknowledged following         */
/*             current academic behaviour                              */
/*           o no fees or compensation are charged for use, copies,    */
/*             or access to this software                              */
/*           o this copyright notice is included intact.               */
/*      This software is made available AS IS, and no warranty is made */
/*      about the software or its performance.                         */
/*                                                                     */
/*      Bug descriptions, use reports, comments or suggestions are     */
/*      welcome Send them to                                           */
/*        <Manuel.Serrano@inria.fr>                                    */
/*        Manuel Serrano                                               */
/*        INRIA -- Rocquencourt                                        */
/*        Domaine de Voluceau, BP 105                                  */
/*        78153 Le Chesnay Cedex                                       */
/*        France                                                       */
/*---------------------------------------------------------------------*/


/*=====================================================================*/
/*   Ieee/port.scm                                                     */
/*   Bigloo (v1.8)                                                     */
/*   Manuel Serrano (c)       Thu Apr 11 10:48:22 PDT 1996             */
/*=====================================================================*/
#define THE_GC BOEHM_GC
#define BIGLOO_DEBUG 1

#include <bigloo.h>
#include <signal.h>

/* The C generated type (for typed structures) */
extern obj_t close_input_port( obj_t );
static obj_t symbol1260___r4_ports_6_10_1 = BUNSPEC;
extern obj_t open_input_string___r4_ports_6_10_1_175( obj_t );
static obj_t symbol1229___r4_ports_6_10_1 = BUNSPEC;
static obj_t symbol1206___r4_ports_6_10_1 = BUNSPEC;
static obj_t symbol1248___r4_ports_6_10_1 = BUNSPEC;
extern obj_t call_with_output_file___r4_ports_6_10_1_208( obj_t, obj_t );
static obj_t symbol1200___r4_ports_6_10_1 = BUNSPEC;
static obj_t symbol1217___r4_ports_6_10_1 = BUNSPEC;
extern obj_t _close_input_port___r4_ports_6_10_1_126( obj_t, obj_t );
static obj_t symbol1237___r4_ports_6_10_1 = BUNSPEC;
static obj_t symbol1245___r4_ports_6_10_1 = BUNSPEC;
static obj_t symbol1249___r4_ports_6_10_1 = BUNSPEC;
extern obj_t open_input_string( obj_t );
extern obj_t output_port____r4_ports_6_10_1_86( obj_t );
static obj_t symbol1218___r4_ports_6_10_1 = BUNSPEC;
extern obj_t current_output_port___r4_ports_6_10_1_30();
extern obj_t current_input_port;
DEFINE_STRING( string1211___r4_ports_6_10_1, aux1697, "Type `OUTPUT-PORT' expected", 27 );
DEFINE_STRING( string1225___r4_ports_6_10_1, aux1698, "Type `PAIR' expected", 20 );
extern obj_t append_output_file( obj_t );
extern obj_t close_output_port___r4_ports_6_10_1_226( obj_t );
extern obj_t _with_input_from_file___r4_ports_6_10_1_124( obj_t, obj_t, obj_t );
static obj_t symbol1240___r4_ports_6_10_1 = BUNSPEC;
extern obj_t file_exists____r4_ports_6_10_1_232( char * );
DEFINE_STRING( string1243___r4_ports_6_10_1, aux1699, "with-input-from-file", 20 );
static obj_t *__cnst;
static obj_t symbol1210___r4_ports_6_10_1 = BUNSPEC;
extern obj_t close_output_port( obj_t );
static obj_t symbol1207___r4_ports_6_10_1 = BUNSPEC;
extern obj_t check_version____bigloo_18( obj_t, char *, obj_t );
static obj_t symbol1223___r4_ports_6_10_1 = BUNSPEC;
extern obj_t _rename_file___r4_ports_6_10_1_244( obj_t, obj_t, obj_t );
DEFINE_STRING( string1239___r4_ports_6_10_1, aux1700, "can't open file", 15 );
static obj_t symbol1251___r4_ports_6_10_1 = BUNSPEC;
extern obj_t with_input_from_file___r4_ports_6_10_1_228( obj_t, obj_t );
extern obj_t current_output_port;
static obj_t symbol1256___r4_ports_6_10_1 = BUNSPEC;
DEFINE_STRING( string1208___r4_ports_6_10_1, aux1701, "Type `INPUT-PORT' expected", 26 );
static obj_t symbol1197___r4_ports_6_10_1 = BUNSPEC;
static obj_t symbol1221___r4_ports_6_10_1 = BUNSPEC;
DEFINE_STRING( string1198___r4_ports_6_10_1, aux1702, "Type `STRING' expected", 22 );
DEFINE_STRING( string1259___r4_ports_6_10_1, aux1703, "call-with-input-file", 20 );
static obj_t symbol1264___r4_ports_6_10_1 = BUNSPEC;
static obj_t symbol1224___r4_ports_6_10_1 = BUNSPEC;
extern obj_t close_input_port___r4_ports_6_10_1_184( obj_t );
DEFINE_STRING( string1226___r4_ports_6_10_1, aux1704, "/udir/serrano/prgm/project/bigloo/Ieee/port.scm", 47 );
static obj_t symbol1246___r4_ports_6_10_1 = BUNSPEC;
extern obj_t _append_output_file___r4_ports_6_10_1_104( obj_t, obj_t );
extern obj_t open_output_file( obj_t );
static obj_t symbol1219___r4_ports_6_10_1 = BUNSPEC;
static obj_t tvectors_declarations____r4_ports_6_10_1_255();
extern obj_t with_output_to_file___r4_ports_6_10_1_170( obj_t, obj_t );
static obj_t symbol1231___r4_ports_6_10_1 = BUNSPEC;
extern obj_t _input_port____r4_ports_6_10_1_127( obj_t, obj_t );
extern obj_t current_error_port;
static obj_t symbol1235___r4_ports_6_10_1 = BUNSPEC;
static obj_t list1233___r4_ports_6_10_1 = BUNSPEC;
extern obj_t _current_input_port___r4_ports_6_10_1_33( obj_t );
extern obj_t initialization___r4_ports_6_10_1();
extern obj_t initialization___error();
static obj_t symbol1214___r4_ports_6_10_1 = BUNSPEC;
extern obj_t _delete_file___r4_ports_6_10_1_64( obj_t, obj_t );
static obj_t symbol1212___r4_ports_6_10_1 = BUNSPEC;
static obj_t symbol1205___r4_ports_6_10_1 = BUNSPEC;
extern obj_t current_input_port___r4_ports_6_10_1_21();
extern obj_t open_output_string();
extern obj_t append_output_file___r4_ports_6_10_1_155( obj_t );
extern obj_t input_port____r4_ports_6_10_1_205( obj_t );
extern obj_t error_location___error_27( obj_t, obj_t, obj_t, obj_t, obj_t );
extern obj_t current_error_port___r4_ports_6_10_1_244();
extern long default_io_bufsiz;
static obj_t symbol1232___r4_ports_6_10_1 = BUNSPEC;
static obj_t list1252___r4_ports_6_10_1 = BUNSPEC;
extern obj_t string_to_symbol( char * );
extern obj_t open_output_string___r4_ports_6_10_1_95();
static obj_t symbol1253___r4_ports_6_10_1 = BUNSPEC;
static obj_t symbol1209___r4_ports_6_10_1 = BUNSPEC;
extern obj_t _open_input_file___r4_ports_6_10_1_196( obj_t, obj_t, obj_t );
extern obj_t _open_input_string___r4_ports_6_10_1_22( obj_t, obj_t );
static obj_t symbol1222___r4_ports_6_10_1 = BUNSPEC;
extern bool_t fexists( char * );
DEFINE_STRING( string1236___r4_ports_6_10_1, aux1705, "Wrong number of arguments in", 28 );
static obj_t symbol1254___r4_ports_6_10_1 = BUNSPEC;
extern obj_t _with_output_to_file___r4_ports_6_10_1_188( obj_t, obj_t, obj_t );
extern obj_t open_input_file( obj_t, obj_t );
static obj_t symbol1213___r4_ports_6_10_1 = BUNSPEC;
static obj_t symbol1204___r4_ports_6_10_1 = BUNSPEC;
static obj_t symbol1250___r4_ports_6_10_1 = BUNSPEC;
DEFINE_STRING( string1238___r4_ports_6_10_1, aux1706, "with-output-to-file", 19 );
extern bool_t reset_eof___r4_ports_6_10_1_50( obj_t );
extern obj_t call_with_input_file___r4_ports_6_10_1_164( obj_t, obj_t );
static obj_t symbol1247___r4_ports_6_10_1 = BUNSPEC;
extern obj_t open_input_file___r4_ports_6_10_1_217( obj_t, obj_t );
extern obj_t _reset_eof___r4_ports_6_10_1_158( obj_t, obj_t );
static obj_t symbol1258___r4_ports_6_10_1 = BUNSPEC;
extern obj_t _current_error_port___r4_ports_6_10_1_246( obj_t );
DEFINE_STRING( string1230___r4_ports_6_10_1, aux1707, "Type `PROCEDURE' expected", 25 );
extern obj_t open_output_file___r4_ports_6_10_1_55( obj_t );
extern bool_t reset_eof( obj_t );
static obj_t symbol1263___r4_ports_6_10_1 = BUNSPEC;
DEFINE_STRING( string1255___r4_ports_6_10_1, aux1708, "call-with-output-file", 21 );
static obj_t symbol1257___r4_ports_6_10_1 = BUNSPEC;
extern obj_t _file_exists____r4_ports_6_10_1_179( obj_t, obj_t );
extern obj_t rename_file___r4_ports_6_10_1_141( char *, char * );
extern obj_t _call_with_output_file___r4_ports_6_10_1_192( obj_t, obj_t, obj_t );
DEFINE_STRING( string1203___r4_ports_6_10_1, aux1709, "Type `BSTRING' expected", 23 );
static obj_t symbol1216___r4_ports_6_10_1 = BUNSPEC;
static obj_t symbol1201___r4_ports_6_10_1 = BUNSPEC;
static obj_t initialize_constants____r4_ports_6_10_1_238();
static obj_t symbol1241___r4_ports_6_10_1 = BUNSPEC;
static obj_t symbol1199___r4_ports_6_10_1 = BUNSPEC;
DEFINE_STRING( string1227___r4_ports_6_10_1, aux1710, "open-input-file", 15 );
extern obj_t _open_output_file___r4_ports_6_10_1_31( obj_t, obj_t );
DEFINE_STRING( string1228___r4_ports_6_10_1, aux1711, "not a number", 12 );
extern obj_t _flush_output_port___r4_ports_6_10_1_36( obj_t, obj_t );
static obj_t initialize_imported_modules____r4_ports_6_10_1_253();
extern obj_t _current_output_port___r4_ports_6_10_1_112( obj_t );
static obj_t symbol1220___r4_ports_6_10_1 = BUNSPEC;
static obj_t symbol1261___r4_ports_6_10_1 = BUNSPEC;
extern obj_t _open_output_string___r4_ports_6_10_1_247( obj_t );
extern obj_t _output_port____r4_ports_6_10_1_128( obj_t, obj_t );
static obj_t symbol1234___r4_ports_6_10_1 = BUNSPEC;
extern obj_t _close_output_port___r4_ports_6_10_1_53( obj_t, obj_t );
static obj_t require_initialization____r4_ports_6_10_1_232 = BUNSPEC;
static obj_t symbol1202___r4_ports_6_10_1 = BUNSPEC;
static obj_t symbol1215___r4_ports_6_10_1 = BUNSPEC;
static obj_t symbol1262___r4_ports_6_10_1 = BUNSPEC;
extern obj_t _call_with_input_file___r4_ports_6_10_1_75( obj_t, obj_t, obj_t );
static obj_t symbol1244___r4_ports_6_10_1 = BUNSPEC;
extern obj_t __debug____error_22;
extern obj_t flush_output_port___r4_ports_6_10_1_190( obj_t );
static obj_t symbol1242___r4_ports_6_10_1 = BUNSPEC;
extern obj_t delete_file___r4_ports_6_10_1_181( char * );

DEFINE_EXPORT_PROCEDURE( rename_file_env___r4_ports_6_10_1_223, aux1712, _rename_file___r4_ports_6_10_1_244, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( call_with_input_file_env___r4_ports_6_10_1_100, aux1713, _call_with_input_file___r4_ports_6_10_1_75, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( file_exists__env___r4_ports_6_10_1_122, aux1714, _file_exists____r4_ports_6_10_1_179, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( input_port__env___r4_ports_6_10_1_162, aux1715, _input_port____r4_ports_6_10_1_127, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( with_input_from_file_env___r4_ports_6_10_1_85, aux1716, _with_input_from_file___r4_ports_6_10_1_124, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( delete_file_env___r4_ports_6_10_1_48, aux1717, _delete_file___r4_ports_6_10_1_64, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( output_port__env___r4_ports_6_10_1_203, aux1718, _output_port____r4_ports_6_10_1_128, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( open_input_string_env___r4_ports_6_10_1_249, aux1719, _open_input_string___r4_ports_6_10_1_22, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( close_input_port_env___r4_ports_6_10_1_132, aux1720, _close_input_port___r4_ports_6_10_1_126, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( with_output_to_file_env___r4_ports_6_10_1_56, aux1721, _with_output_to_file___r4_ports_6_10_1_188, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( open_input_file_env___r4_ports_6_10_1_91, aux1722, va_generic_entry, _open_input_file___r4_ports_6_10_1_196, -2 );
DEFINE_EXPORT_PROCEDURE( open_output_string_env___r4_ports_6_10_1_64, aux1723, _open_output_string___r4_ports_6_10_1_247, 0L, 0 );
DEFINE_EXPORT_PROCEDURE( current_input_port_env___r4_ports_6_10_1_50, aux1724, _current_input_port___r4_ports_6_10_1_33, 0L, 0 );
DEFINE_EXPORT_PROCEDURE( reset_eof_env___r4_ports_6_10_1_137, aux1725, _reset_eof___r4_ports_6_10_1_158, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( open_output_file_env___r4_ports_6_10_1_243, aux1732, _open_output_file___r4_ports_6_10_1_31, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( close_output_port_env___r4_ports_6_10_1_79, aux1733, _close_output_port___r4_ports_6_10_1_53, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( current_error_port_env___r4_ports_6_10_1_252, aux1734, _current_error_port___r4_ports_6_10_1_246, 0L, 0 );
DEFINE_EXPORT_PROCEDURE( flush_output_port_env___r4_ports_6_10_1_253, aux1735, _flush_output_port___r4_ports_6_10_1_36, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( append_output_file_env___r4_ports_6_10_1_19, aux1736, _append_output_file___r4_ports_6_10_1_104, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( current_output_port_env___r4_ports_6_10_1_66, aux1737, _current_output_port___r4_ports_6_10_1_112, 0L, 0 );
DEFINE_EXPORT_PROCEDURE( call_with_output_file_env___r4_ports_6_10_1_0, aux1738, _call_with_output_file___r4_ports_6_10_1_192, 0L, 2 );

obj_t initialization___r4_ports_6_10_1()
{{PUSH_TRACE(symbol1263___r4_ports_6_10_1);
{obj_t res1094_868;
if(CBOOL(require_initialization____r4_ports_6_10_1_232)){require_initialization____r4_ports_6_10_1_232 = BFALSE;
__debug____error_22 = BINT(1);
initialize_imported_modules____r4_ports_6_10_1_253();
tvectors_declarations____r4_ports_6_10_1_255();
initialize_constants____r4_ports_6_10_1_238();
{obj_t aux1093_699;
aux1093_699 = symbol1264___r4_ports_6_10_1;
check_version____bigloo_18(aux1093_699, "Bigloo (v1.8)", BCHAR(((unsigned char)'b')));
}require_initialization____r4_ports_6_10_1_232 = BFALSE;
res1094_868 = BUNSPEC;
} else {res1094_868 = BUNSPEC;
}POP_TRACE();
return res1094_868;
}}}

obj_t initialize_imported_modules____r4_ports_6_10_1_253()
{initialization___error();
return BUNSPEC;
}

obj_t initialize_constants____r4_ports_6_10_1_238()
{symbol1197___r4_ports_6_10_1 = string_to_symbol("_rename-file");
symbol1199___r4_ports_6_10_1 = string_to_symbol("RENAME-FILE");
symbol1200___r4_ports_6_10_1 = string_to_symbol("_delete-file");
symbol1201___r4_ports_6_10_1 = string_to_symbol("DELETE-FILE");
symbol1202___r4_ports_6_10_1 = string_to_symbol("_append-output-file");
symbol1204___r4_ports_6_10_1 = string_to_symbol("APPEND-OUTPUT-FILE");
symbol1205___r4_ports_6_10_1 = string_to_symbol("_file-exists?");
symbol1206___r4_ports_6_10_1 = string_to_symbol("FILE-EXISTS?");
symbol1207___r4_ports_6_10_1 = string_to_symbol("_reset-eof");
symbol1209___r4_ports_6_10_1 = string_to_symbol("RESET-EOF");
symbol1210___r4_ports_6_10_1 = string_to_symbol("_flush-output-port");
symbol1212___r4_ports_6_10_1 = string_to_symbol("FLUSH-OUTPUT-PORT");
symbol1213___r4_ports_6_10_1 = string_to_symbol("_close-output-port");
symbol1214___r4_ports_6_10_1 = string_to_symbol("CLOSE-OUTPUT-PORT");
symbol1215___r4_ports_6_10_1 = string_to_symbol("_close-input-port");
symbol1216___r4_ports_6_10_1 = string_to_symbol("CLOSE-INPUT-PORT");
symbol1217___r4_ports_6_10_1 = string_to_symbol("OPEN-OUTPUT-STRING");
symbol1218___r4_ports_6_10_1 = string_to_symbol("_open-output-file");
symbol1219___r4_ports_6_10_1 = string_to_symbol("OPEN-OUTPUT-FILE");
symbol1220___r4_ports_6_10_1 = string_to_symbol("_open-input-string");
symbol1221___r4_ports_6_10_1 = string_to_symbol("OPEN-INPUT-STRING");
symbol1222___r4_ports_6_10_1 = string_to_symbol("_open-input-file");
symbol1223___r4_ports_6_10_1 = string_to_symbol("OPEN-INPUT-FILE");
symbol1224___r4_ports_6_10_1 = string_to_symbol("open-input-file");
symbol1229___r4_ports_6_10_1 = string_to_symbol("_with-output-to-file");
symbol1231___r4_ports_6_10_1 = string_to_symbol("WITH-OUTPUT-TO-FILE");
symbol1232___r4_ports_6_10_1 = string_to_symbol("with-output-to-file");
symbol1234___r4_ports_6_10_1 = string_to_symbol("FUNCALL");
symbol1235___r4_ports_6_10_1 = string_to_symbol("thunk");
list1233___r4_ports_6_10_1 = MAKE_PAIR(symbol1234___r4_ports_6_10_1, MAKE_PAIR(symbol1235___r4_ports_6_10_1, MAKE_PAIR(symbol1235___r4_ports_6_10_1, BNIL)));
symbol1237___r4_ports_6_10_1 = string_to_symbol("_");
symbol1240___r4_ports_6_10_1 = string_to_symbol("_with-input-from-file");
symbol1241___r4_ports_6_10_1 = string_to_symbol("WITH-INPUT-FROM-FILE");
symbol1242___r4_ports_6_10_1 = string_to_symbol("with-input-from-file");
symbol1244___r4_ports_6_10_1 = string_to_symbol("CURRENT-ERROR-PORT");
symbol1245___r4_ports_6_10_1 = string_to_symbol("CURRENT-OUTPUT-PORT");
symbol1246___r4_ports_6_10_1 = string_to_symbol("CURRENT-INPUT-PORT");
symbol1247___r4_ports_6_10_1 = string_to_symbol("OUTPUT-PORT?");
symbol1248___r4_ports_6_10_1 = string_to_symbol("INPUT-PORT?");
symbol1249___r4_ports_6_10_1 = string_to_symbol("_call-with-output-file");
symbol1250___r4_ports_6_10_1 = string_to_symbol("CALL-WITH-OUTPUT-FILE");
symbol1251___r4_ports_6_10_1 = string_to_symbol("call-with-output-file");
symbol1253___r4_ports_6_10_1 = string_to_symbol("proc");
symbol1254___r4_ports_6_10_1 = string_to_symbol("port");
list1252___r4_ports_6_10_1 = MAKE_PAIR(symbol1234___r4_ports_6_10_1, MAKE_PAIR(symbol1253___r4_ports_6_10_1, MAKE_PAIR(symbol1253___r4_ports_6_10_1, MAKE_PAIR(symbol1254___r4_ports_6_10_1, BNIL))));
symbol1256___r4_ports_6_10_1 = string_to_symbol("_call-with-input-file");
symbol1257___r4_ports_6_10_1 = string_to_symbol("CALL-WITH-INPUT-FILE");
symbol1258___r4_ports_6_10_1 = string_to_symbol("call-with-input-file");
symbol1260___r4_ports_6_10_1 = string_to_symbol("TVECTORS-DECLARATIONS!");
symbol1261___r4_ports_6_10_1 = string_to_symbol("INITIALIZE-CONSTANTS!");
symbol1262___r4_ports_6_10_1 = string_to_symbol("INITIALIZE-IMPORTED-MODULES!");
symbol1263___r4_ports_6_10_1 = string_to_symbol("INITIALIZATION");
symbol1264___r4_ports_6_10_1 = string_to_symbol("__R4_PORTS_6_10_1");
return BUNSPEC;
}

obj_t tvectors_declarations____r4_ports_6_10_1_255()
{{PUSH_TRACE(symbol1260___r4_ports_6_10_1);
{obj_t res1097_871;
res1097_871 = BUNSPEC;
POP_TRACE();
return res1097_871;
}}}

obj_t call_with_input_file___r4_ports_6_10_1_164(obj_t string_664, obj_t proc_665)
{{PUSH_TRACE(symbol1257___r4_ports_6_10_1);
{obj_t res1098_872;
{obj_t port_666;
port_666 = open_input_file___r4_ports_6_10_1_217(string_664, BNIL);
if(INPUT_PORTP(port_666)){obj_t res_667;
if(PROCEDURE_CORRECT_ARITYP(proc_665, 1)){res_667 = PROCEDURE_ENTRY(proc_665)(proc_665, port_666, BEOA);
} else {{obj_t aux1192_979;
aux1192_979 = symbol1258___r4_ports_6_10_1;
{obj_t aux1193_980;
aux1193_980 = list1252___r4_ports_6_10_1;
error_location___error_27(aux1192_979, string1236___r4_ports_6_10_1, aux1193_980, string1226___r4_ports_6_10_1, BINT(4430));
}}FAILURE(symbol1237___r4_ports_6_10_1,symbol1237___r4_ports_6_10_1,symbol1237___r4_ports_6_10_1);}{obj_t port_861;
if(INPUT_PORTP(port_666)){port_861 = port_666;
} else {{obj_t aux1196_982;
aux1196_982 = symbol1258___r4_ports_6_10_1;
error_location___error_27(aux1196_982, string1208___r4_ports_6_10_1, port_666, string1226___r4_ports_6_10_1, BINT(4450));
}FAILURE(BFALSE,BFALSE,BFALSE);}close_input_port(port_861);
}res1098_872 = res_667;
} else {res1098_872 = error_location___error_27(string1259___r4_ports_6_10_1, string1239___r4_ports_6_10_1, string_664, string1226___r4_ports_6_10_1, BINT(4488));
}}POP_TRACE();
return res1098_872;
}}}

obj_t _call_with_input_file___r4_ports_6_10_1_75(obj_t env_893, obj_t string_894, obj_t proc_895)
{{obj_t aux1592_1228;
obj_t aux1588_1224;
if(PROCEDUREP(proc_895))aux1592_1228 = proc_895;
 else {FAILURE(symbol1256___r4_ports_6_10_1,string1230___r4_ports_6_10_1,proc_895);}if(STRINGP(string_894))aux1588_1224 = string_894;
 else {FAILURE(symbol1256___r4_ports_6_10_1,string1203___r4_ports_6_10_1,string_894);}return call_with_input_file___r4_ports_6_10_1_164(aux1588_1224, aux1592_1228);
}}

obj_t call_with_output_file___r4_ports_6_10_1_208(obj_t string_668, obj_t proc_669)
{{PUSH_TRACE(symbol1250___r4_ports_6_10_1);
{obj_t res1099_873;
{obj_t port_670;
port_670 = open_output_file(string_668);
if(OUTPUT_PORTP(port_670)){obj_t res_671;
if(PROCEDURE_CORRECT_ARITYP(proc_669, 1)){res_671 = PROCEDURE_ENTRY(proc_669)(proc_669, port_670, BEOA);
} else {{obj_t aux1184_972;
aux1184_972 = symbol1251___r4_ports_6_10_1;
{obj_t aux1185_973;
aux1185_973 = list1252___r4_ports_6_10_1;
error_location___error_27(aux1184_972, string1236___r4_ports_6_10_1, aux1185_973, string1226___r4_ports_6_10_1, BINT(4902));
}}FAILURE(symbol1237___r4_ports_6_10_1,symbol1237___r4_ports_6_10_1,symbol1237___r4_ports_6_10_1);}{obj_t port_863;
if(OUTPUT_PORTP(port_670)){port_863 = port_670;
} else {{obj_t aux1188_975;
aux1188_975 = symbol1251___r4_ports_6_10_1;
error_location___error_27(aux1188_975, string1211___r4_ports_6_10_1, port_670, string1226___r4_ports_6_10_1, BINT(4922));
}FAILURE(BFALSE,BFALSE,BFALSE);}close_output_port(port_863);
}res1099_873 = res_671;
} else {res1099_873 = error_location___error_27(string1255___r4_ports_6_10_1, string1239___r4_ports_6_10_1, string_668, string1226___r4_ports_6_10_1, BINT(4961));
}}POP_TRACE();
return res1099_873;
}}}

obj_t _call_with_output_file___r4_ports_6_10_1_192(obj_t env_896, obj_t string_897, obj_t proc_898)
{{obj_t aux1562_1199;
obj_t aux1557_1195;
if(PROCEDUREP(proc_898))aux1562_1199 = proc_898;
 else {FAILURE(symbol1249___r4_ports_6_10_1,string1230___r4_ports_6_10_1,proc_898);}if(STRINGP(string_897))aux1557_1195 = string_897;
 else {FAILURE(symbol1249___r4_ports_6_10_1,string1203___r4_ports_6_10_1,string_897);}return call_with_output_file___r4_ports_6_10_1_208(aux1557_1195, aux1562_1199);
}}

obj_t input_port____r4_ports_6_10_1_205(obj_t obj_672)
{{PUSH_TRACE(symbol1248___r4_ports_6_10_1);
{obj_t res1100_874;
res1100_874 = BBOOL(INPUT_PORTP(obj_672));
POP_TRACE();
return res1100_874;
}}}

obj_t _input_port____r4_ports_6_10_1_127(obj_t env_899, obj_t obj_900)
{return input_port____r4_ports_6_10_1_205(obj_900);
}

obj_t output_port____r4_ports_6_10_1_86(obj_t obj_673)
{{PUSH_TRACE(symbol1247___r4_ports_6_10_1);
{obj_t res1101_875;
res1101_875 = BBOOL(OUTPUT_PORTP(obj_673));
POP_TRACE();
return res1101_875;
}}}

obj_t _output_port____r4_ports_6_10_1_128(obj_t env_901, obj_t obj_902)
{return output_port____r4_ports_6_10_1_86(obj_902);
}

obj_t current_input_port___r4_ports_6_10_1_21()
{{PUSH_TRACE(symbol1246___r4_ports_6_10_1);
{obj_t res1102_876;
res1102_876 = current_input_port;
POP_TRACE();
return res1102_876;
}}}

obj_t _current_input_port___r4_ports_6_10_1_33(obj_t env_903)
{return current_input_port___r4_ports_6_10_1_21();
}

obj_t current_output_port___r4_ports_6_10_1_30()
{{PUSH_TRACE(symbol1245___r4_ports_6_10_1);
{obj_t res1103_877;
res1103_877 = current_output_port;
POP_TRACE();
return res1103_877;
}}}

obj_t _current_output_port___r4_ports_6_10_1_112(obj_t env_904)
{return current_output_port___r4_ports_6_10_1_30();
}

obj_t current_error_port___r4_ports_6_10_1_244()
{{PUSH_TRACE(symbol1244___r4_ports_6_10_1);
{obj_t res1104_878;
res1104_878 = current_error_port;
POP_TRACE();
return res1104_878;
}}}

obj_t _current_error_port___r4_ports_6_10_1_246(obj_t env_905)
{return current_error_port___r4_ports_6_10_1_244();
}

obj_t with_input_from_file___r4_ports_6_10_1_228(obj_t string_674, obj_t thunk_675)
{{PUSH_TRACE(symbol1241___r4_ports_6_10_1);
{obj_t res1105_879;
{obj_t port_676;
port_676 = open_input_file___r4_ports_6_10_1_217(string_674, BNIL);
if(INPUT_PORTP(port_676)){obj_t old_input_port_677_245;
obj_t result_678;
old_input_port_677_245 = current_input_port;
result_678 = BNIL;
if(INPUT_PORTP(port_676)){current_input_port = port_676;
} else {{obj_t aux1164_963;
aux1164_963 = symbol1242___r4_ports_6_10_1;
error_location___error_27(aux1164_963, string1208___r4_ports_6_10_1, port_676, string1226___r4_ports_6_10_1, BINT(6852));
}FAILURE(BFALSE,BFALSE,BFALSE);}if(PROCEDURE_CORRECT_ARITYP(thunk_675, 0)){result_678 = PROCEDURE_ENTRY(thunk_675)(thunk_675, BEOA);
} else {{obj_t aux1168_965;
aux1168_965 = symbol1242___r4_ports_6_10_1;
{obj_t aux1169_966;
aux1169_966 = list1233___r4_ports_6_10_1;
error_location___error_27(aux1168_965, string1236___r4_ports_6_10_1, aux1169_966, string1226___r4_ports_6_10_1, BINT(6904));
}}FAILURE(symbol1237___r4_ports_6_10_1,symbol1237___r4_ports_6_10_1,symbol1237___r4_ports_6_10_1);}{obj_t port_864;
if(INPUT_PORTP(port_676)){port_864 = port_676;
} else {{obj_t aux1177_968;
aux1177_968 = symbol1242___r4_ports_6_10_1;
error_location___error_27(aux1177_968, string1208___r4_ports_6_10_1, port_676, string1226___r4_ports_6_10_1, BINT(6919));
}FAILURE(BFALSE,BFALSE,BFALSE);}close_input_port(port_864);
}current_input_port = old_input_port_677_245;
res1105_879 = result_678;
} else {res1105_879 = error_location___error_27(string1243___r4_ports_6_10_1, string1239___r4_ports_6_10_1, string_674, string1226___r4_ports_6_10_1, BINT(7009));
}}POP_TRACE();
return res1105_879;
}}}

obj_t _with_input_from_file___r4_ports_6_10_1_124(obj_t env_906, obj_t string_907, obj_t thunk_908)
{{obj_t aux1486_1146;
obj_t aux1482_1142;
if(PROCEDUREP(thunk_908))aux1486_1146 = thunk_908;
 else {FAILURE(symbol1240___r4_ports_6_10_1,string1230___r4_ports_6_10_1,thunk_908);}if(STRINGP(string_907))aux1482_1142 = string_907;
 else {FAILURE(symbol1240___r4_ports_6_10_1,string1203___r4_ports_6_10_1,string_907);}return with_input_from_file___r4_ports_6_10_1_228(aux1482_1142, aux1486_1146);
}}

obj_t with_output_to_file___r4_ports_6_10_1_170(obj_t string_679, obj_t thunk_680)
{{PUSH_TRACE(symbol1231___r4_ports_6_10_1);
{obj_t res1106_880;
{obj_t port_681;
port_681 = open_output_file(string_679);
if(OUTPUT_PORTP(port_681)){obj_t old_output_port_682_81;
obj_t result_683;
old_output_port_682_81 = current_output_port;
result_683 = BNIL;
if(OUTPUT_PORTP(port_681)){current_output_port = port_681;
} else {{obj_t aux1151_954;
aux1151_954 = symbol1232___r4_ports_6_10_1;
error_location___error_27(aux1151_954, string1211___r4_ports_6_10_1, port_681, string1226___r4_ports_6_10_1, BINT(7486));
}FAILURE(BFALSE,BFALSE,BFALSE);}if(PROCEDURE_CORRECT_ARITYP(thunk_680, 0)){result_683 = PROCEDURE_ENTRY(thunk_680)(thunk_680, BEOA);
} else {{obj_t aux1154_956;
aux1154_956 = symbol1232___r4_ports_6_10_1;
{obj_t aux1155_957;
aux1155_957 = list1233___r4_ports_6_10_1;
error_location___error_27(aux1154_956, string1236___r4_ports_6_10_1, aux1155_957, string1226___r4_ports_6_10_1, BINT(7539));
}}FAILURE(symbol1237___r4_ports_6_10_1,symbol1237___r4_ports_6_10_1,symbol1237___r4_ports_6_10_1);}{obj_t port_866;
if(OUTPUT_PORTP(port_681)){port_866 = port_681;
} else {{obj_t aux1157_959;
aux1157_959 = symbol1232___r4_ports_6_10_1;
error_location___error_27(aux1157_959, string1211___r4_ports_6_10_1, port_681, string1226___r4_ports_6_10_1, BINT(7554));
}FAILURE(BFALSE,BFALSE,BFALSE);}close_output_port(port_866);
}current_output_port = old_output_port_682_81;
res1106_880 = result_683;
} else {res1106_880 = error_location___error_27(string1238___r4_ports_6_10_1, string1239___r4_ports_6_10_1, string_679, string1226___r4_ports_6_10_1, BINT(7647));
}}POP_TRACE();
return res1106_880;
}}}

obj_t _with_output_to_file___r4_ports_6_10_1_188(obj_t env_909, obj_t string_910, obj_t thunk_911)
{{obj_t aux1444_1112;
obj_t aux1439_1108;
if(PROCEDUREP(thunk_911))aux1444_1112 = thunk_911;
 else {FAILURE(symbol1229___r4_ports_6_10_1,string1230___r4_ports_6_10_1,thunk_911);}if(STRINGP(string_910))aux1439_1108 = string_910;
 else {FAILURE(symbol1229___r4_ports_6_10_1,string1203___r4_ports_6_10_1,string_910);}return with_output_to_file___r4_ports_6_10_1_170(aux1439_1108, aux1444_1112);
}}

obj_t open_input_file___r4_ports_6_10_1_217(obj_t string_684, obj_t bufsiz_685)
{{PUSH_TRACE(symbol1223___r4_ports_6_10_1);
{obj_t res1107_881;
{obj_t size_686;
if(NULLP(bufsiz_685)){size_686 = BINT(default_io_bufsiz);
} else {obj_t pair_867;
if(PAIRP(bufsiz_685)){pair_867 = bufsiz_685;
} else {{obj_t aux1145_950;
aux1145_950 = symbol1224___r4_ports_6_10_1;
error_location___error_27(aux1145_950, string1225___r4_ports_6_10_1, bufsiz_685, string1226___r4_ports_6_10_1, BINT(8034));
}FAILURE(BFALSE,BFALSE,BFALSE);}size_686 = CAR(pair_867);
}if(INTEGERP(size_686)){res1107_881 = open_input_file(string_684, size_686);
} else {res1107_881 = error_location___error_27(string1227___r4_ports_6_10_1, string1228___r4_ports_6_10_1, size_686, string1226___r4_ports_6_10_1, BINT(8085));
}}POP_TRACE();
return res1107_881;
}}}

obj_t _open_input_file___r4_ports_6_10_1_196(obj_t env_912, obj_t string_913, obj_t bufsiz_914)
{{obj_t aux1412_1087;
if(STRINGP(string_913))aux1412_1087 = string_913;
 else {FAILURE(symbol1222___r4_ports_6_10_1,string1203___r4_ports_6_10_1,string_913);}return open_input_file___r4_ports_6_10_1_217(aux1412_1087, bufsiz_914);
}}

obj_t open_input_string___r4_ports_6_10_1_175(obj_t string_687)
{{PUSH_TRACE(symbol1221___r4_ports_6_10_1);
{obj_t res1108_882;
res1108_882 = open_input_string(string_687);
POP_TRACE();
return res1108_882;
}}}

obj_t _open_input_string___r4_ports_6_10_1_22(obj_t env_915, obj_t string_916)
{{obj_t aux1402_1079;
if(STRINGP(string_916))aux1402_1079 = string_916;
 else {FAILURE(symbol1220___r4_ports_6_10_1,string1203___r4_ports_6_10_1,string_916);}return open_input_string___r4_ports_6_10_1_175(aux1402_1079);
}}

obj_t open_output_file___r4_ports_6_10_1_55(obj_t string_688)
{{PUSH_TRACE(symbol1219___r4_ports_6_10_1);
{obj_t res1109_883;
res1109_883 = open_output_file(string_688);
POP_TRACE();
return res1109_883;
}}}

obj_t _open_output_file___r4_ports_6_10_1_31(obj_t env_917, obj_t string_918)
{{obj_t aux1392_1071;
if(STRINGP(string_918))aux1392_1071 = string_918;
 else {FAILURE(symbol1218___r4_ports_6_10_1,string1203___r4_ports_6_10_1,string_918);}return open_output_file___r4_ports_6_10_1_55(aux1392_1071);
}}

obj_t open_output_string___r4_ports_6_10_1_95()
{{PUSH_TRACE(symbol1217___r4_ports_6_10_1);
{obj_t res1110_884;
res1110_884 = open_output_string();
POP_TRACE();
return res1110_884;
}}}

obj_t _open_output_string___r4_ports_6_10_1_247(obj_t env_919)
{return open_output_string___r4_ports_6_10_1_95();
}

obj_t close_input_port___r4_ports_6_10_1_184(obj_t port_689)
{{PUSH_TRACE(symbol1216___r4_ports_6_10_1);
{obj_t res1111_885;
res1111_885 = close_input_port(port_689);
POP_TRACE();
return res1111_885;
}}}

obj_t _close_input_port___r4_ports_6_10_1_126(obj_t env_920, obj_t port_921)
{{obj_t aux1376_1059;
if(INPUT_PORTP(port_921))aux1376_1059 = port_921;
 else {FAILURE(symbol1215___r4_ports_6_10_1,string1208___r4_ports_6_10_1,port_921);}return close_input_port___r4_ports_6_10_1_184(aux1376_1059);
}}

obj_t close_output_port___r4_ports_6_10_1_226(obj_t port_690)
{{PUSH_TRACE(symbol1214___r4_ports_6_10_1);
{obj_t res1112_886;
res1112_886 = close_output_port(port_690);
POP_TRACE();
return res1112_886;
}}}

obj_t _close_output_port___r4_ports_6_10_1_53(obj_t env_922, obj_t port_923)
{{obj_t aux1366_1051;
if(OUTPUT_PORTP(port_923))aux1366_1051 = port_923;
 else {FAILURE(symbol1213___r4_ports_6_10_1,string1211___r4_ports_6_10_1,port_923);}return close_output_port___r4_ports_6_10_1_226(aux1366_1051);
}}

obj_t flush_output_port___r4_ports_6_10_1_190(obj_t port_691)
{{PUSH_TRACE(symbol1212___r4_ports_6_10_1);
{obj_t res1113_887;
res1113_887 = FLUSH_OUTPUT_PORT(port_691);
POP_TRACE();
return res1113_887;
}}}

obj_t _flush_output_port___r4_ports_6_10_1_36(obj_t env_924, obj_t port_925)
{{obj_t aux1355_1043;
if(OUTPUT_PORTP(port_925))aux1355_1043 = port_925;
 else {FAILURE(symbol1210___r4_ports_6_10_1,string1211___r4_ports_6_10_1,port_925);}return flush_output_port___r4_ports_6_10_1_190(aux1355_1043);
}}

bool_t reset_eof___r4_ports_6_10_1_50(obj_t port_692)
{{PUSH_TRACE(symbol1209___r4_ports_6_10_1);
{bool_t res1114_888;
res1114_888 = reset_eof(port_692);
POP_TRACE();
return res1114_888;
}}}

obj_t _reset_eof___r4_ports_6_10_1_158(obj_t env_926, obj_t port_927)
{{bool_t aux1338_1033;
{obj_t aux1340_1034;
if(INPUT_PORTP(port_927))aux1340_1034 = port_927;
 else {FAILURE(symbol1207___r4_ports_6_10_1,string1208___r4_ports_6_10_1,port_927);}aux1338_1033 = reset_eof___r4_ports_6_10_1_50(aux1340_1034);
}return BBOOL(aux1338_1033);
}}

obj_t file_exists____r4_ports_6_10_1_232(char * name_693)
{{PUSH_TRACE(symbol1206___r4_ports_6_10_1);
{obj_t res1115_889;
res1115_889 = BBOOL(fexists(name_693));
POP_TRACE();
return res1115_889;
}}}

obj_t _file_exists____r4_ports_6_10_1_179(obj_t env_928, obj_t name_929)
{{char * aux1323_1022;
{obj_t aux1324_1023;
if(STRINGP(name_929))aux1324_1023 = name_929;
 else {FAILURE(symbol1205___r4_ports_6_10_1,string1198___r4_ports_6_10_1,name_929);}aux1323_1022 = BSTRING_TO_STRING(aux1324_1023);
}return file_exists____r4_ports_6_10_1_232(aux1323_1022);
}}

obj_t append_output_file___r4_ports_6_10_1_155(obj_t string_694)
{{PUSH_TRACE(symbol1204___r4_ports_6_10_1);
{obj_t res1116_890;
res1116_890 = append_output_file(string_694);
POP_TRACE();
return res1116_890;
}}}

obj_t _append_output_file___r4_ports_6_10_1_104(obj_t env_930, obj_t string_931)
{{obj_t aux1313_1014;
if(STRINGP(string_931))aux1313_1014 = string_931;
 else {FAILURE(symbol1202___r4_ports_6_10_1,string1203___r4_ports_6_10_1,string_931);}return append_output_file___r4_ports_6_10_1_155(aux1313_1014);
}}

obj_t delete_file___r4_ports_6_10_1_181(char * string_695)
{{PUSH_TRACE(symbol1201___r4_ports_6_10_1);
{obj_t res1117_891;
res1117_891 = BBOOL(unlink(string_695));
POP_TRACE();
return res1117_891;
}}}

obj_t _delete_file___r4_ports_6_10_1_64(obj_t env_932, obj_t string_933)
{{char * aux1298_1003;
{obj_t aux1299_1004;
if(STRINGP(string_933))aux1299_1004 = string_933;
 else {FAILURE(symbol1200___r4_ports_6_10_1,string1198___r4_ports_6_10_1,string_933);}aux1298_1003 = BSTRING_TO_STRING(aux1299_1004);
}return delete_file___r4_ports_6_10_1_181(aux1298_1003);
}}

obj_t rename_file___r4_ports_6_10_1_141(char * string1_696, char * string2_697)
{{PUSH_TRACE(symbol1199___r4_ports_6_10_1);
{obj_t res1118_892;
{bool_t test1286_997;
{int aux1092_698;
aux1092_698 = rename(string1_696, string2_697);
test1286_997 = (BINT(aux1092_698)==BINT(0));
}if(test1286_997){res1118_892 = BTRUE;
} else {res1118_892 = BFALSE;
}}POP_TRACE();
return res1118_892;
}}}

obj_t _rename_file___r4_ports_6_10_1_244(obj_t env_934, obj_t string1_935, obj_t string2_936)
{{char * aux1275_989;
char * aux1265_983;
{obj_t aux1276_990;
if(STRINGP(string2_936))aux1276_990 = string2_936;
 else {FAILURE(symbol1197___r4_ports_6_10_1,string1198___r4_ports_6_10_1,string2_936);}aux1275_989 = BSTRING_TO_STRING(aux1276_990);
}{obj_t aux1267_984;
if(STRINGP(string1_935))aux1267_984 = string1_935;
 else {FAILURE(symbol1197___r4_ports_6_10_1,string1198___r4_ports_6_10_1,string1_935);}aux1265_983 = BSTRING_TO_STRING(aux1267_984);
}return rename_file___r4_ports_6_10_1_141(aux1265_983, aux1275_989);
}}

