/*---------------------------------------------------------------------*/
/*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
/*                                                                     */
/*                                     ,--^,                           */
/*                               _ ___/ /|/                            */
/*                           ,;'( )__, ) '                             */
/*                          ;;  //   L__.                              */
/*                          '   \    /  '                              */
/*                               ^   ^                                 */
/*                                                                     */
/*                                                                     */
/*    This program is distributed in the hope that it will be useful.  */
/*    Use and copying of this software and preparation of derivative   */
/*    works based upon this software are permitted, so long as the     */
/*    following conditions are met:                                    */
/*           o credit to the authors is acknowledged following         */
/*             current academic behaviour                              */
/*           o no fees or compensation are charged for use, copies,    */
/*             or access to this software                              */
/*           o this copyright notice is included intact.               */
/*      This software is made available AS IS, and no warranty is made */
/*      about the software or its performance.                         */
/*                                                                     */
/*      Bug descriptions, use reports, comments or suggestions are     */
/*      welcome Send them to                                           */
/*        <Manuel.Serrano@inria.fr>                                    */
/*        Manuel Serrano                                               */
/*        INRIA -- Rocquencourt                                        */
/*        Domaine de Voluceau, BP 105                                  */
/*        78153 Le Chesnay Cedex                                       */
/*        France                                                       */
/*---------------------------------------------------------------------*/


/*=====================================================================*/
/*   Ieee/vector.scm                                                   */
/*   Bigloo (v1.8)                                                     */
/*   Manuel Serrano (c)       Thu Apr 11 10:48:22 PDT 1996             */
/*=====================================================================*/
#define THE_GC BOEHM_GC
#define BIGLOO_DEBUG 1

#include <bigloo.h>
#include <signal.h>

/* The C generated type (for typed structures) */
static obj_t symbol1179___r4_vectors_6_8 = BUNSPEC;
static obj_t symbol1151___r4_vectors_6_8 = BUNSPEC;
extern obj_t _vector_set_ur____r4_vectors_6_8_242( obj_t, obj_t, obj_t, obj_t );
extern obj_t _vector_fill____r4_vectors_6_8_46( obj_t, obj_t, obj_t );
static obj_t symbol1175___r4_vectors_6_8 = BUNSPEC;
static obj_t symbol1147___r4_vectors_6_8 = BUNSPEC;
static obj_t symbol1149___r4_vectors_6_8 = BUNSPEC;
extern bool_t vector____r4_vectors_6_8_181( obj_t );
extern obj_t _vector___r4_vectors_6_8( obj_t, obj_t );
static obj_t symbol1167___r4_vectors_6_8 = BUNSPEC;
static obj_t symbol1163___r4_vectors_6_8 = BUNSPEC;
extern obj_t vector__list___r4_vectors_6_8_188( obj_t );
static obj_t symbol1169___r4_vectors_6_8 = BUNSPEC;
static obj_t symbol1173___r4_vectors_6_8 = BUNSPEC;
extern obj_t vector_fill____r4_vectors_6_8_117( obj_t, obj_t );
extern obj_t vector_tag_set____r4_vectors_6_8_3( obj_t, long );
static obj_t symbol1172___r4_vectors_6_8 = BUNSPEC;
static obj_t symbol1156___r4_vectors_6_8 = BUNSPEC;
extern obj_t _vector_set____r4_vectors_6_8_243( obj_t, obj_t, obj_t, obj_t );
extern obj_t vector_ref___r4_vectors_6_8_123( obj_t, long );
static obj_t symbol1160___r4_vectors_6_8 = BUNSPEC;
static obj_t *__cnst;
extern obj_t _vector_ref___r4_vectors_6_8_145( obj_t, obj_t, obj_t );
static obj_t symbol1161___r4_vectors_6_8 = BUNSPEC;
extern obj_t check_version____bigloo_18( obj_t, char *, obj_t );
static obj_t symbol1152___r4_vectors_6_8 = BUNSPEC;
extern obj_t _vector_tag___r4_vectors_6_8_68( obj_t, obj_t );
extern obj_t fill_vector( obj_t, long, obj_t );
extern long list_length( obj_t );
DEFINE_STRING( string1145___r4_vectors_6_8, aux1495, "Type `VECTOR' expected", 22 );
static obj_t symbol1159___r4_vectors_6_8 = BUNSPEC;
extern obj_t _vector_tag_set____r4_vectors_6_8_22( obj_t, obj_t, obj_t );
DEFINE_STRING( string1155___r4_vectors_6_8, aux1496, "/udir/serrano/prgm/project/bigloo/Ieee/vector.scm", 49 );
extern obj_t _vector_length___r4_vectors_6_8_201( obj_t, obj_t );
extern obj_t make_vector( long, obj_t );
extern obj_t vector_ref_ur___r4_vectors_6_8_45( obj_t, long );
static obj_t symbol1166___r4_vectors_6_8 = BUNSPEC;
DEFINE_STRING( string1165___r4_vectors_6_8, aux1497, "index out of range", 18 );
static obj_t symbol1170___r4_vectors_6_8 = BUNSPEC;
static obj_t symbol1177___r4_vectors_6_8 = BUNSPEC;
extern long vector_tag___r4_vectors_6_8_100( obj_t );
extern obj_t _make_vector___r4_vectors_6_8_116( obj_t, obj_t, obj_t );
static obj_t tvectors_declarations____r4_vectors_6_8_79();
extern obj_t _vector____r4_vectors_6_8_45( obj_t, obj_t );
extern obj_t vector_set_ur____r4_vectors_6_8_5( obj_t, long, obj_t );
extern obj_t make_vector___r4_vectors_6_8_252( long, obj_t );
static obj_t initialize_constants____r4_vectors_6_8_80();
extern obj_t initialization___r4_vectors_6_8();
extern obj_t initialization___error();
static obj_t symbol1174___r4_vectors_6_8 = BUNSPEC;
static obj_t symbol1171___r4_vectors_6_8 = BUNSPEC;
DEFINE_STRING( string1164___r4_vectors_6_8, aux1499, "vector-set!", 11 );
static obj_t symbol1180___r4_vectors_6_8 = BUNSPEC;
extern long vector_length___r4_vectors_6_8_190( obj_t );
extern obj_t _vector_ref_ur___r4_vectors_6_8_154( obj_t, obj_t, obj_t );
static obj_t symbol1178___r4_vectors_6_8 = BUNSPEC;
extern obj_t vector_set____r4_vectors_6_8_151( obj_t, long, obj_t );
static obj_t symbol1176___r4_vectors_6_8 = BUNSPEC;
static obj_t initialize_imported_modules____r4_vectors_6_8_29();
extern obj_t list__vector___r4_vectors_6_8_160( obj_t );
extern obj_t _list__vector___r4_vectors_6_8_187( obj_t, obj_t );
DEFINE_STRING( string1154___r4_vectors_6_8, aux1500, "Type `PAIR' expected", 20 );
static obj_t symbol1162___r4_vectors_6_8 = BUNSPEC;
extern obj_t error_location___error_27( obj_t, obj_t, obj_t, obj_t, obj_t );
static obj_t symbol1158___r4_vectors_6_8 = BUNSPEC;
static obj_t symbol1150___r4_vectors_6_8 = BUNSPEC;
static obj_t symbol1144___r4_vectors_6_8 = BUNSPEC;
extern obj_t string_to_symbol( char * );
DEFINE_STRING( string1146___r4_vectors_6_8, aux1501, "Type `LONG' expected", 20 );
DEFINE_STRING( string1168___r4_vectors_6_8, aux1502, "vector-ref", 10 );
static obj_t require_initialization____r4_vectors_6_8_71 = BUNSPEC;
static obj_t symbol1153___r4_vectors_6_8 = BUNSPEC;
extern obj_t _vector__list___r4_vectors_6_8_124( obj_t, obj_t );
extern obj_t __debug____error_22;
static obj_t symbol1148___r4_vectors_6_8 = BUNSPEC;
extern obj_t vector___r4_vectors_6_8( obj_t );
static obj_t symbol1157___r4_vectors_6_8 = BUNSPEC;

DEFINE_EXPORT_PROCEDURE( vector__env___r4_vectors_6_8_86, aux1504, _vector____r4_vectors_6_8_45, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( vector_tag_set__env___r4_vectors_6_8_66, aux1505, _vector_tag_set____r4_vectors_6_8_22, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( vector__list_env___r4_vectors_6_8_95, aux1506, _vector__list___r4_vectors_6_8_124, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( make_vector_env___r4_vectors_6_8_104, aux1507, va_generic_entry, _make_vector___r4_vectors_6_8_116, -2 );
DEFINE_EXPORT_PROCEDURE( vector_tag_env___r4_vectors_6_8_205, aux1508, _vector_tag___r4_vectors_6_8_68, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( vector_set__env___r4_vectors_6_8_187, aux1509, _vector_set____r4_vectors_6_8_243, 0L, 3 );
DEFINE_EXPORT_PROCEDURE( list__vector_env___r4_vectors_6_8_186, aux1515, _list__vector___r4_vectors_6_8_187, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( vector_length_env___r4_vectors_6_8_115, aux1516, _vector_length___r4_vectors_6_8_201, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( vector_ref_ur_env___r4_vectors_6_8_254, aux1517, _vector_ref_ur___r4_vectors_6_8_154, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( vector_set_ur__env___r4_vectors_6_8_130, aux1518, _vector_set_ur____r4_vectors_6_8_242, 0L, 3 );
DEFINE_EXPORT_PROCEDURE( vector_env___r4_vectors_6_8_166, aux1519, va_generic_entry, _vector___r4_vectors_6_8, -1 );
DEFINE_EXPORT_PROCEDURE( vector_fill__env___r4_vectors_6_8_110, aux1522, _vector_fill____r4_vectors_6_8_46, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( vector_ref_env___r4_vectors_6_8_79, aux1523, _vector_ref___r4_vectors_6_8_145, 0L, 2 );

obj_t initialization___r4_vectors_6_8()
{{PUSH_TRACE(symbol1179___r4_vectors_6_8);
{obj_t res1092_722;
if(CBOOL(require_initialization____r4_vectors_6_8_71)){require_initialization____r4_vectors_6_8_71 = BFALSE;
__debug____error_22 = BINT(1);
initialize_imported_modules____r4_vectors_6_8_29();
tvectors_declarations____r4_vectors_6_8_79();
initialize_constants____r4_vectors_6_8_80();
{obj_t aux1091_569;
aux1091_569 = symbol1180___r4_vectors_6_8;
check_version____bigloo_18(aux1091_569, "Bigloo (v1.8)", BCHAR(((unsigned char)'b')));
}require_initialization____r4_vectors_6_8_71 = BFALSE;
res1092_722 = BUNSPEC;
} else {res1092_722 = BUNSPEC;
}POP_TRACE();
return res1092_722;
}}}

obj_t initialize_imported_modules____r4_vectors_6_8_29()
{initialization___error();
return BUNSPEC;
}

obj_t initialize_constants____r4_vectors_6_8_80()
{symbol1144___r4_vectors_6_8 = string_to_symbol("_vector-tag-set!");
symbol1147___r4_vectors_6_8 = string_to_symbol("VECTOR-TAG-SET!");
symbol1148___r4_vectors_6_8 = string_to_symbol("_vector-tag");
symbol1149___r4_vectors_6_8 = string_to_symbol("VECTOR-TAG");
symbol1150___r4_vectors_6_8 = string_to_symbol("_vector-fill!");
symbol1151___r4_vectors_6_8 = string_to_symbol("VECTOR-FILL!");
symbol1152___r4_vectors_6_8 = string_to_symbol("LIST->VECTOR");
symbol1153___r4_vectors_6_8 = string_to_symbol("list->vector");
symbol1156___r4_vectors_6_8 = string_to_symbol("_vector->list");
symbol1157___r4_vectors_6_8 = string_to_symbol("VECTOR->LIST");
symbol1158___r4_vectors_6_8 = string_to_symbol("_vector-set-ur!");
symbol1159___r4_vectors_6_8 = string_to_symbol("VECTOR-SET-UR!");
symbol1160___r4_vectors_6_8 = string_to_symbol("_vector-ref-ur");
symbol1161___r4_vectors_6_8 = string_to_symbol("VECTOR-REF-UR");
symbol1162___r4_vectors_6_8 = string_to_symbol("_vector-set!");
symbol1163___r4_vectors_6_8 = string_to_symbol("VECTOR-SET!");
symbol1166___r4_vectors_6_8 = string_to_symbol("_vector-ref");
symbol1167___r4_vectors_6_8 = string_to_symbol("VECTOR-REF");
symbol1169___r4_vectors_6_8 = string_to_symbol("_vector-length");
symbol1170___r4_vectors_6_8 = string_to_symbol("VECTOR-LENGTH");
symbol1171___r4_vectors_6_8 = string_to_symbol("VECTOR");
symbol1172___r4_vectors_6_8 = string_to_symbol("_make-vector");
symbol1173___r4_vectors_6_8 = string_to_symbol("MAKE-VECTOR");
symbol1174___r4_vectors_6_8 = string_to_symbol("make-vector");
symbol1175___r4_vectors_6_8 = string_to_symbol("VECTOR?");
symbol1176___r4_vectors_6_8 = string_to_symbol("TVECTORS-DECLARATIONS!");
symbol1177___r4_vectors_6_8 = string_to_symbol("INITIALIZE-CONSTANTS!");
symbol1178___r4_vectors_6_8 = string_to_symbol("INITIALIZE-IMPORTED-MODULES!");
symbol1179___r4_vectors_6_8 = string_to_symbol("INITIALIZATION");
symbol1180___r4_vectors_6_8 = string_to_symbol("__R4_VECTORS_6_8");
return BUNSPEC;
}

obj_t tvectors_declarations____r4_vectors_6_8_79()
{{PUSH_TRACE(symbol1176___r4_vectors_6_8);
{obj_t res1095_725;
res1095_725 = BUNSPEC;
POP_TRACE();
return res1095_725;
}}}

bool_t vector____r4_vectors_6_8_181(obj_t obj_526)
{{PUSH_TRACE(symbol1175___r4_vectors_6_8);
{bool_t res1096_726;
res1096_726 = VECTORP(obj_526);
POP_TRACE();
return res1096_726;
}}}

obj_t _vector____r4_vectors_6_8_45(obj_t env_739, obj_t obj_740)
{return BBOOL(vector____r4_vectors_6_8_181(obj_740));
}

obj_t make_vector___r4_vectors_6_8_252(long int_527, obj_t fill_528)
{{PUSH_TRACE(symbol1173___r4_vectors_6_8);
{obj_t res1097_727;
if(NULLP(fill_528)){res1097_727 = make_vector(int_527, BUNSPEC);
} else {obj_t aux1079_529;
{obj_t pair_697;
if(PAIRP(fill_528)){pair_697 = fill_528;
} else {{obj_t aux1143_794;
aux1143_794 = symbol1174___r4_vectors_6_8;
error_location___error_27(aux1143_794, string1154___r4_vectors_6_8, fill_528, string1155___r4_vectors_6_8, BINT(3957));
}FAILURE(BFALSE,BFALSE,BFALSE);}aux1079_529 = CAR(pair_697);
}res1097_727 = make_vector(int_527, aux1079_529);
}POP_TRACE();
return res1097_727;
}}}

obj_t _make_vector___r4_vectors_6_8_116(obj_t env_741, obj_t int_742, obj_t fill_743)
{{long aux1402_953;
{obj_t aux1403_954;
if(INTEGERP(int_742))aux1403_954 = int_742;
 else {FAILURE(symbol1172___r4_vectors_6_8,string1146___r4_vectors_6_8,int_742);}aux1402_953 = (long)CINT(aux1403_954);
}return make_vector___r4_vectors_6_8_252(aux1402_953, fill_743);
}}

obj_t vector___r4_vectors_6_8(obj_t args_530)
{{PUSH_TRACE(symbol1171___r4_vectors_6_8);
{obj_t res1098_728;
res1098_728 = list__vector___r4_vectors_6_8_160(args_530);
POP_TRACE();
return res1098_728;
}}}

obj_t _vector___r4_vectors_6_8(obj_t env_744, obj_t args_745)
{return vector___r4_vectors_6_8(args_745);
}

long vector_length___r4_vectors_6_8_190(obj_t vector_531)
{{PUSH_TRACE(symbol1170___r4_vectors_6_8);
{long res1099_729;
res1099_729 = VECTOR_LENGTH(vector_531);
POP_TRACE();
return res1099_729;
}}}

obj_t _vector_length___r4_vectors_6_8_201(obj_t env_746, obj_t vector_747)
{{long aux1383_939;
{obj_t aux1384_940;
if(VECTORP(vector_747))aux1384_940 = vector_747;
 else {FAILURE(symbol1169___r4_vectors_6_8,string1145___r4_vectors_6_8,vector_747);}aux1383_939 = vector_length___r4_vectors_6_8_190(aux1384_940);
}return BINT(aux1383_939);
}}

obj_t vector_ref___r4_vectors_6_8_123(obj_t vector_532, long k_533)
{{PUSH_TRACE(symbol1167___r4_vectors_6_8);
{obj_t res1100_730;
{bool_t test1372_931;
{long aux1080_534;
aux1080_534 = VECTOR_LENGTH(vector_532);
test1372_931 = BOUND_CHECK(k_533, aux1080_534);
}if(test1372_931){res1100_730 = VECTOR_REF(vector_532, k_533);
} else {res1100_730 = error_location___error_27(string1168___r4_vectors_6_8, string1165___r4_vectors_6_8, BINT(k_533), string1155___r4_vectors_6_8, BINT(4891));
}}POP_TRACE();
return res1100_730;
}}}

obj_t _vector_ref___r4_vectors_6_8_145(obj_t env_748, obj_t vector_749, obj_t k_750)
{{long aux1361_923;
obj_t aux1357_919;
{obj_t aux1364_924;
if(INTEGERP(k_750))aux1364_924 = k_750;
 else {FAILURE(symbol1166___r4_vectors_6_8,string1146___r4_vectors_6_8,k_750);}aux1361_923 = (long)CINT(aux1364_924);
}if(VECTORP(vector_749))aux1357_919 = vector_749;
 else {FAILURE(symbol1166___r4_vectors_6_8,string1145___r4_vectors_6_8,vector_749);}return vector_ref___r4_vectors_6_8_123(aux1357_919, aux1361_923);
}}

obj_t vector_set____r4_vectors_6_8_151(obj_t vector_535, long k_536, obj_t obj_537)
{{PUSH_TRACE(symbol1163___r4_vectors_6_8);
{obj_t res1101_731;
{bool_t test1343_911;
{long aux1081_538;
aux1081_538 = VECTOR_LENGTH(vector_535);
test1343_911 = BOUND_CHECK(k_536, aux1081_538);
}if(test1343_911){res1101_731 = VECTOR_SET(vector_535, k_536, obj_537);
} else {res1101_731 = error_location___error_27(string1164___r4_vectors_6_8, string1165___r4_vectors_6_8, BINT(k_536), string1155___r4_vectors_6_8, BINT(5299));
}}POP_TRACE();
return res1101_731;
}}}

obj_t _vector_set____r4_vectors_6_8_243(obj_t env_751, obj_t vector_752, obj_t k_753, obj_t obj_754)
{{long aux1334_903;
obj_t aux1329_899;
{obj_t aux1335_904;
if(INTEGERP(k_753))aux1335_904 = k_753;
 else {FAILURE(symbol1162___r4_vectors_6_8,string1146___r4_vectors_6_8,k_753);}aux1334_903 = (long)CINT(aux1335_904);
}if(VECTORP(vector_752))aux1329_899 = vector_752;
 else {FAILURE(symbol1162___r4_vectors_6_8,string1145___r4_vectors_6_8,vector_752);}return vector_set____r4_vectors_6_8_151(aux1329_899, aux1334_903, obj_754);
}}

obj_t vector_ref_ur___r4_vectors_6_8_45(obj_t vector_539, long k_540)
{{PUSH_TRACE(symbol1161___r4_vectors_6_8);
{obj_t res1102_732;
res1102_732 = VECTOR_REF(vector_539, k_540);
POP_TRACE();
return res1102_732;
}}}

obj_t _vector_ref_ur___r4_vectors_6_8_154(obj_t env_755, obj_t vector_756, obj_t k_757)
{{long aux1316_889;
obj_t aux1311_885;
{obj_t aux1317_890;
if(INTEGERP(k_757))aux1317_890 = k_757;
 else {FAILURE(symbol1160___r4_vectors_6_8,string1146___r4_vectors_6_8,k_757);}aux1316_889 = (long)CINT(aux1317_890);
}if(VECTORP(vector_756))aux1311_885 = vector_756;
 else {FAILURE(symbol1160___r4_vectors_6_8,string1145___r4_vectors_6_8,vector_756);}return vector_ref_ur___r4_vectors_6_8_45(aux1311_885, aux1316_889);
}}

obj_t vector_set_ur____r4_vectors_6_8_5(obj_t vector_541, long k_542, obj_t obj_543)
{{PUSH_TRACE(symbol1159___r4_vectors_6_8);
{obj_t res1103_733;
res1103_733 = VECTOR_SET(vector_541, k_542, obj_543);
POP_TRACE();
return res1103_733;
}}}

obj_t _vector_set_ur____r4_vectors_6_8_242(obj_t env_758, obj_t vector_759, obj_t k_760, obj_t obj_761)
{{long aux1298_875;
obj_t aux1293_871;
{obj_t aux1299_876;
if(INTEGERP(k_760))aux1299_876 = k_760;
 else {FAILURE(symbol1158___r4_vectors_6_8,string1146___r4_vectors_6_8,k_760);}aux1298_875 = (long)CINT(aux1299_876);
}if(VECTORP(vector_759))aux1293_871 = vector_759;
 else {FAILURE(symbol1158___r4_vectors_6_8,string1145___r4_vectors_6_8,vector_759);}return vector_set_ur____r4_vectors_6_8_5(aux1293_871, aux1298_875, obj_761);
}}

obj_t vector__list___r4_vectors_6_8_188(obj_t vector_544)
{{PUSH_TRACE(symbol1157___r4_vectors_6_8);
{obj_t res1104_734;
{long vlen_545;
vlen_545 = VECTOR_LENGTH(vector_544);
if((vlen_545==0)){res1104_734 = BNIL;
} else {long i_547;
obj_t acc_548;
{long aux1086_553;
aux1086_553 = (vlen_545-1);
i_547 = aux1086_553;
acc_548 = BNIL;
loop_546:
if((i_547==0)){obj_t aux1082_549;
aux1082_549 = VECTOR_REF(vector_544, i_547);
res1104_734 = MAKE_PAIR(aux1082_549, acc_548);
} else {long aux1083_550;
aux1083_550 = (i_547-1);
{obj_t aux1084_551;
{obj_t aux1085_552;
aux1085_552 = VECTOR_REF(vector_544, i_547);
aux1084_551 = MAKE_PAIR(aux1085_552, acc_548);
}{obj_t acc_869;
long i_868;
i_868 = aux1083_550;
acc_869 = aux1084_551;
acc_548 = acc_869;
i_547 = i_868;
goto loop_546;
}}}}}}POP_TRACE();
return res1104_734;
}}}

obj_t _vector__list___r4_vectors_6_8_124(obj_t env_762, obj_t vector_763)
{{obj_t aux1264_851;
if(VECTORP(vector_763))aux1264_851 = vector_763;
 else {FAILURE(symbol1156___r4_vectors_6_8,string1145___r4_vectors_6_8,vector_763);}return vector__list___r4_vectors_6_8_188(aux1264_851);
}}

obj_t list__vector___r4_vectors_6_8_160(obj_t list_554)
{{PUSH_TRACE(symbol1152___r4_vectors_6_8);
{obj_t res1105_735;
{long len_555;
len_555 = list_length(list_554);
{obj_t vec_556;
vec_556 = make_vector(len_555, BNIL);
{{long i_558;
obj_t l_559;
i_558 = 0;
l_559 = list_554;
loop_557:
if((i_558==len_555)){res1105_735 = vec_556;
} else {{obj_t aux1087_560;
{obj_t pair_715;
if(PAIRP(l_559)){pair_715 = l_559;
} else {{obj_t aux1117_779;
aux1117_779 = symbol1153___r4_vectors_6_8;
error_location___error_27(aux1117_779, string1154___r4_vectors_6_8, l_559, string1155___r4_vectors_6_8, BINT(6846));
}FAILURE(BFALSE,BFALSE,BFALSE);}aux1087_560 = CAR(pair_715);
}VECTOR_SET(vec_556, i_558, aux1087_560);
}{long aux1088_561;
aux1088_561 = (i_558+1);
{obj_t aux1089_562;
{obj_t pair_720;
if(PAIRP(l_559)){pair_720 = l_559;
} else {{obj_t aux1120_781;
aux1120_781 = symbol1153___r4_vectors_6_8;
error_location___error_27(aux1120_781, string1154___r4_vectors_6_8, l_559, string1155___r4_vectors_6_8, BINT(6873));
}FAILURE(BFALSE,BFALSE,BFALSE);}aux1089_562 = CDR(pair_720);
}{obj_t l_849;
long i_848;
i_848 = aux1088_561;
l_849 = aux1089_562;
l_559 = l_849;
i_558 = i_848;
goto loop_557;
}}}}}}}}POP_TRACE();
return res1105_735;
}}}

obj_t _list__vector___r4_vectors_6_8_187(obj_t env_764, obj_t list_765)
{return list__vector___r4_vectors_6_8_160(list_765);
}

obj_t vector_fill____r4_vectors_6_8_117(obj_t vector_563, obj_t fill_564)
{{PUSH_TRACE(symbol1151___r4_vectors_6_8);
{obj_t res1106_736;
{long aux1090_565;
aux1090_565 = VECTOR_LENGTH(vector_563);
res1106_736 = fill_vector(vector_563, aux1090_565, fill_564);
}POP_TRACE();
return res1106_736;
}}}

obj_t _vector_fill____r4_vectors_6_8_46(obj_t env_766, obj_t vector_767, obj_t fill_768)
{{obj_t aux1214_819;
if(VECTORP(vector_767))aux1214_819 = vector_767;
 else {FAILURE(symbol1150___r4_vectors_6_8,string1145___r4_vectors_6_8,vector_767);}return vector_fill____r4_vectors_6_8_117(aux1214_819, fill_768);
}}

long vector_tag___r4_vectors_6_8_100(obj_t vector_566)
{{PUSH_TRACE(symbol1149___r4_vectors_6_8);
{long res1107_737;
res1107_737 = VECTOR_TAG(vector_566);
POP_TRACE();
return res1107_737;
}}}

obj_t _vector_tag___r4_vectors_6_8_68(obj_t env_769, obj_t vector_770)
{{long aux1200_809;
{obj_t aux1201_810;
if(VECTORP(vector_770))aux1201_810 = vector_770;
 else {FAILURE(symbol1148___r4_vectors_6_8,string1145___r4_vectors_6_8,vector_770);}aux1200_809 = vector_tag___r4_vectors_6_8_100(aux1201_810);
}return BINT(aux1200_809);
}}

obj_t vector_tag_set____r4_vectors_6_8_3(obj_t vector_567, long tag_568)
{{PUSH_TRACE(symbol1147___r4_vectors_6_8);
{obj_t res1108_738;
res1108_738 = VECTOR_TAG_SET(vector_567, tag_568);
POP_TRACE();
return res1108_738;
}}}

obj_t _vector_tag_set____r4_vectors_6_8_22(obj_t env_771, obj_t vector_772, obj_t tag_773)
{{long aux1187_799;
obj_t aux1182_795;
{obj_t aux1188_800;
if(INTEGERP(tag_773))aux1188_800 = tag_773;
 else {FAILURE(symbol1144___r4_vectors_6_8,string1146___r4_vectors_6_8,tag_773);}aux1187_799 = (long)CINT(aux1188_800);
}if(VECTORP(vector_772))aux1182_795 = vector_772;
 else {FAILURE(symbol1144___r4_vectors_6_8,string1145___r4_vectors_6_8,vector_772);}return vector_tag_set____r4_vectors_6_8_3(aux1182_795, aux1187_799);
}}

