/*---------------------------------------------------------------------*/
/*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
/*                                                                     */
/*                                     ,--^,                           */
/*                               _ ___/ /|/                            */
/*                           ,;'( )__, ) '                             */
/*                          ;;  //   L__.                              */
/*                          '   \    /  '                              */
/*                               ^   ^                                 */
/*                                                                     */
/*                                                                     */
/*    This program is distributed in the hope that it will be useful.  */
/*    Use and copying of this software and preparation of derivative   */
/*    works based upon this software are permitted, so long as the     */
/*    following conditions are met:                                    */
/*           o credit to the authors is acknowledged following         */
/*             current academic behaviour                              */
/*           o no fees or compensation are charged for use, copies,    */
/*             or access to this software                              */
/*           o this copyright notice is included intact.               */
/*      This software is made available AS IS, and no warranty is made */
/*      about the software or its performance.                         */
/*                                                                     */
/*      Bug descriptions, use reports, comments or suggestions are     */
/*      welcome Send them to                                           */
/*        <Manuel.Serrano@inria.fr>                                    */
/*        Manuel Serrano                                               */
/*        INRIA -- Rocquencourt                                        */
/*        Domaine de Voluceau, BP 105                                  */
/*        78153 Le Chesnay Cedex                                       */
/*        France                                                       */
/*---------------------------------------------------------------------*/


/*---------------------------------------------------------------------*/
/*    serrano/prgm/project/bigloo/runtime1.8/Clib/callcc.c             */
/*                                                                     */
/*    Author      :  Manuel Serrano                                    */
/*    Creation    :  Mon Sep 14 09:03:27 1992                          */
/*    Last change :  Tue Apr  9 17:22:42 1996 (serrano)                */
/*                                                                     */
/*    On implement cette satanee fonction: `call/cc'                   */
/*---------------------------------------------------------------------*/
#include <bigloo.h>
#include <string.h>

/*---------------------------------------------------------------------*/
/*    Quelques petites macros                                          */
/*---------------------------------------------------------------------*/
#define BLOCK_SIZE 10    /* la taille d'accroissement de la pile.      */

/*---------------------------------------------------------------------*/
/*    On recupere la variable de bas de pile                           */
/*---------------------------------------------------------------------*/
extern char *stack_bottom;
extern long  glob_dummy;

extern obj_t make_fx_procedure();
extern obj_t c_constant_string_to_string();

/*---------------------------------------------------------------------*/
/*    La variable de transition de la continuation.                    */
/*    -------------------------------------------------------------    */
/*    On est oblige d'utiliser une variable intermediaire. On ne peut  */
/*    pas passer la valeur de la continuation dans le longjmp car sur  */
/*    les Alpha le prototype de `longjmp' est jmp_buf x int -> ... .   */
/*    La conversion obj_t/int est incorrecte. On utilise donc la       */
/*    variable static globale pour faire transiter la continuation.    */
/*---------------------------------------------------------------------*/
static obj_t __continuation = BUNSPEC;

/*---------------------------------------------------------------------*/
/*    flush_regs_in_stack ...                                          */
/*---------------------------------------------------------------------*/
#if( defined( sparc ) )
extern int flush_regs_in_stack();
#endif

/*---------------------------------------------------------------------*/
/*    get_top_of_stack ...                                             */
/*    -------------------------------------------------------------    */
/*    On ne peut pas chercher le top de la pile dans la fonction       */
/*    `call_cc' car on ne sait pas si les arguments d'une fonction     */
/*    sont ranges apres les variables locales ou le contraire. Il me   */
/*    semble que la solution est donc d'appeller une autre fonction,   */
/*    prendre une variable locale et retourner cette adresse car on    */
/*    est sur qu'elle sera plus grande (ou plus petite si la pile      */
/*    decroit) que la valeur du frame pointer de `call_cc'.            */
/*---------------------------------------------------------------------*/
char *
get_top_of_stack()
{
   long *dummy; /* dummy est un long et pas un char car je veux */
                /* etre sur de ne pas avoir de pbm d'alignement*/

   return (char *)(&(dummy));
}

/*---------------------------------------------------------------------*/
/*    blowup_window_register ...                                       */
/*    -------------------------------------------------------------    */
/*    On veut etre sur que le `longjmp' va restorer toutes les         */
/*    fenetres de registre. Pour s'assurer de cela, on fait des appels */
/*    recursifs pour que toutes les fenetres soient utilisees.         */
/*---------------------------------------------------------------------*/
void
blowup_window_register( counter, proc, value )
long   counter;
obj_t proc, value; 
{
#if( 0 <  NB_WINDOW_REGISTER )   
   if( counter < NB_WINDOW_REGISTER )
   {
      long x;
      
      glob_dummy = x;
       
      blowup_window_register( counter + 1, proc, value, &x );
   }
   else
#endif   
   {
      static obj_t  stack;
      static obj_t  jmpbuf;
      static obj_t  s_value;
      static obj_t  s_proc;
      static char  *stack_top;
      
      stack        = PROCEDURE_REF( proc, 0 );
      stack_top    = (char *)CREF( PROCEDURE_REF( proc, 1 ) );
      jmpbuf       = CREF( PROCEDURE_REF( proc, 2 ) );
      top_of_frame = (struct dframe *)CREF( PROCEDURE_REF( proc, 4 ) );
		
      s_value      = value;
      s_proc       = proc;
      
      /* on sauve la valeur de retour */
      PROCEDURE_SET( s_proc, 3, s_value );

      /* on verifie que c'est bien une pile qu'on va restorer */
      if( (!STACKP( stack )) || (!EQP( CREF( stack ), STACK( stack ).self )) )
         FAILURE( c_constant_string_to_string( "apply_continuation" ),
                  c_constant_string_to_string( "not a C stack" ),
                  stack );
      else
      {
         /* on restore la pile */
#if( STACK_GROWS_DOWN )
         memcpy( (char *)stack_top,
                 &(STACK( stack ).stack),
                 CINT( STACK( stack ).size ));
#else
         memcpy( (char *)stack_bottom,
                 &(STACK( stack ).stack),
                 CINT( STACK( stack ).size ) );
#endif
	 /* on restore les bexit */
	 exitd_top = STACK( stack ).exitd_top;
	 
         /* ok, on fait maintenant le longjmp */
	 __continuation = s_proc;
			
         longjmp( (long *)jmpbuf, (long)1 );
      }
   }
}

/*---------------------------------------------------------------------*/
/*    apply_continuation ...                                           */
/*---------------------------------------------------------------------*/
obj_t
apply_continuation( proc, value )
obj_t proc, value;
{
   char *stack_top, *actual_stack_top;

   actual_stack_top = get_top_of_stack();
   stack_top        = (char *)CREF( PROCEDURE_REF( proc, 1 ) );
   
   /* on fait grandire la pile jusqu'a ce qu'elle depasse stack_top */
#if( STACK_GROWS_DOWN )
   if( ((unsigned long)stack_top) <= (unsigned long)actual_stack_top)
#else 
   if( ((unsigned long)stack_top) >= (unsigned long)actual_stack_top )
#endif
   {
      char *dummy[ BLOCK_SIZE ];

      /* Je fais un appel recursif pour faire grandir la pile.        */
      /* C'est absolument atroce, mais je passe un arg supplementaire */
      /* a la fonction: dummy. La raison est que j'ai peur qu'un      */
      /* compilo tres intelligent s'apercoive que je n'utilise pas    */
      /* cette variable et donc qu'il me la supprime oubien que ce    */
      /* meme compilo fasse une optimisation sur un appel qui est     */
      /* recursif terminal et donc qu'il transforme cela en un goto,  */
      /* sans faire grandir la pile. D'autre part, comme la fonction  */
      /* `alloca' n'est pas standard et donc qu'il ne faut pas        */
      /* pour allouer sur la pile.                                    */
      /* En plus, afin, d'etre sur que dummy ne va pas etre mangee    */
      /* par un compilo trop intelligent, on la range dans une        */
      /* variable globale.                                            */
      glob_dummy = (long)dummy;
      apply_continuation( proc, value, dummy );
   }
   else
      blowup_window_register( 0, proc, value );
}

/*---------------------------------------------------------------------*/
/*    call_cc ...                                                      */
/*---------------------------------------------------------------------*/
obj_t
call_cc( proc )
obj_t proc;
{
   jmp_buf jmpbuf;
   long     value;
   
   value = setjmp( jmpbuf );

   if( !value ) 
   {
      obj_t         continuation;
      obj_t         stack;
      char         *stack_top;
      unsigned long stack_size;

      /* sur sparc, il est indispensables de flusher les registres. */
#if( defined( sparc ) )      
      flush_regs_in_stack();
#endif

      /* on recupere l'adresse du sommet de pile */
      stack_top = get_top_of_stack();
      
      /* on calcule la taille de la pile, en prevoyant que le GC peut */
      /* flusher les registres dans la pile (REGISTER_SAVE_BUFFER)    */
#if( STACK_GROWS_DOWN )
      stack_size = (unsigned long)stack_bottom - (unsigned long)stack_top;
#else
      stack_size = (unsigned long)stack_top - (unsigned long)stack_bottom;
#endif

      { 
         obj_t aux;

         /* on alloue un espace pour la sauvegarder de la pile  */
         stack = MAKE_STACK( stack_size + sizeof(char *), aux );
      }

      STACK( stack ).size      = BINT( (long)stack_size );
      STACK( stack ).self      = CREF( stack );
      STACK( stack ).exitd_top = exitd_top;

      /* on construit la continuation */
      continuation = make_fx_procedure( &apply_continuation, 1, 5 );
      PROCEDURE_SET( continuation, 0, stack );
      PROCEDURE_SET( continuation, 1, BREF( stack_top ) );
      PROCEDURE_SET( continuation, 2, BREF( jmpbuf ) );
      PROCEDURE_SET( continuation, 3, BUNSPEC );
      PROCEDURE_SET( continuation, 4, BREF( (obj_t)top_of_frame ) );

      /* on duplique la pile */
#if( STACK_GROWS_DOWN )
      memcpy( &(STACK( stack ).stack), (char *)stack_top, stack_size );
#else
      memcpy( &(STACK( stack ).stack), (char *)stack_bottom, stack_size);
#endif
 
      /* on va faire l'application mais avant il faut qu'on test */
      /* que la fonction est correcte. Pour cela, on va verifier */
      /* que la fonction a une arite correcte.                   */
      /* Le test procedurep( proc ) a deja ete effectue dans la  */
      /* definition scheme de `call/cc'.                         */
      if( !PROCEDURE_CORRECT_ARITYP( proc, 1 ) )
         the_failure( c_constant_string_to_string( "call/cc" ),
                      c_constant_string_to_string( "illegal arity" ),
                      BINT( PROCEDURE_ARITY( proc ) ) );
      else
         return PROCEDURE_ENTRY( proc )( proc, continuation, BEOA );
   }
   else
      return (obj_t)PROCEDURE_REF( __continuation, 3 );
}


