/*---------------------------------------------------------------------*/
/*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
/*                                                                     */
/*                                     ,--^,                           */
/*                               _ ___/ /|/                            */
/*                           ,;'( )__, ) '                             */
/*                          ;;  //   L__.                              */
/*                          '   \    /  '                              */
/*                               ^   ^                                 */
/*                                                                     */
/*                                                                     */
/*    This program is distributed in the hope that it will be useful.  */
/*    Use and copying of this software and preparation of derivative   */
/*    works based upon this software are permitted, so long as the     */
/*    following conditions are met:                                    */
/*           o credit to the authors is acknowledged following         */
/*             current academic behaviour                              */
/*           o no fees or compensation are charged for use, copies,    */
/*             or access to this software                              */
/*           o this copyright notice is included intact.               */
/*      This software is made available AS IS, and no warranty is made */
/*      about the software or its performance.                         */
/*                                                                     */
/*      Bug descriptions, use reports, comments or suggestions are     */
/*      welcome Send them to                                           */
/*        <Manuel.Serrano@inria.fr>                                    */
/*        Manuel Serrano                                               */
/*        INRIA -- Rocquencourt                                        */
/*        Domaine de Voluceau, BP 105                                  */
/*        78153 Le Chesnay Cedex                                       */
/*        France                                                       */
/*---------------------------------------------------------------------*/


/*=====================================================================*/
/*    serrano/prgm/project/bigloo/runtime1.8/Clib/roots.c              */
/*    -------------------------------------------------------------    */
/*    Author      :  Manuel Serrano                                    */
/*    Creation    :  Tue Aug 29 08:44:14 1995                          */
/*    Last change :  Sun Dec 10 14:20:47 1995 (serrano)                */
/*    -------------------------------------------------------------    */
/*    We add global variables as GC roots.                             */
/*=====================================================================*/
#include <bigloo.h>

/*---------------------------------------------------------------------*/
/*    external prototypes                                              */
/*---------------------------------------------------------------------*/
extern obj_t c_constant_string_to_string();

/*---------------------------------------------------------------------*/
/*    root bounds                                                      */
/*---------------------------------------------------------------------*/
long min_root = 0, max_root = 0;

/*---------------------------------------------------------------------*/
/*    void                                                             */
/*    add_root ...                                                     */
/*---------------------------------------------------------------------*/
obj_t
add_root( long var_addr )
{
   printf( "adding: %8x (%ld) \n", var_addr, var_addr );
   
   if( (var_addr < min_root) || (min_root == 0) )
      min_root = var_addr;
   else
      if( (var_addr > max_root) || (max_root == 0) )
         max_root = var_addr;
   
   return BUNSPEC;
}

/*---------------------------------------------------------------------*/
/*    void                                                             */
/*    send_roots ...                                                   */
/*    -------------------------------------------------------------    */
/*    In order to allow the GC to manage all roots as a single         */
/*    region we don't reset min_root nor max_root after each           */
/*    GC_add_roots. Hence, the GC, always see overlapping regions.     */
/*---------------------------------------------------------------------*/
obj_t
send_roots()
{
#if( THE_GC == BOEHM_GC )
   extern void GC_add_roots();

   printf( "sending-roots: %8x (%ld) -> %8x (%ld)\n",
	  min_root, min_root,
	  max_root, max_root );
   GC_add_roots( min_root, max_root );
#else
   ; 
#endif

   return BUNSPEC;
}
