;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/runtime1.8/Eval/expd-define.scm      */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Mon Jan  4 17:14:30 1993                          */
;*    Last change :  Wed Nov  1 17:23:47 1995 (serrano)                */
;*                                                                     */
;*    Les expanseurs des formes `define's et `lambda'                  */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module __expander_define
   
   (import  (__error                   "Llib/error.scm")
	    (__bigloo                  "Llib/bigloo.scm")
	    (__tvector                 "Llib/tvector.scm")
	    (__structure               "Llib/struct.scm")
	    (__tvector                 "Llib/tvector.scm")
	    (__bexit                   "Llib/bexit.scm")
	    (__unix                    "Llib/unix.scm")
	    
	    (__reader                  "Read/reader.scm")
	    
	    (__rgc                     "Rgc/runtime.scm")
	    
	    (__r4_numbers_6_5          "Ieee/number.scm")
	    (__r4_numbers_6_5_fixnum   "Ieee/fixnum.scm")
	    (__r4_numbers_6_5_flonum   "Ieee/flonum.scm")
	    (__r4_characters_6_6       "Ieee/char.scm")
	    (__r4_equivalence_6_2      "Ieee/equiv.scm")
	    (__r4_booleans_6_1         "Ieee/boolean.scm")
	    (__r4_symbols_6_4          "Ieee/symbol.scm")
	    (__r4_strings_6_7          "Ieee/string.scm")
	    (__r4_pairs_and_lists_6_3  "Ieee/pair-list.scm")
	    (__r4_input_6_10_2         "Ieee/input.scm")
	    (__r4_control_features_6_9 "Ieee/control.scm")
	    (__r4_vectors_6_8          "Ieee/vector.scm")
	    (__r4_ports_6_10_1         "Ieee/port.scm")
	    (__r4_output_6_10_3        "Ieee/output.scm")
	    
	    (__progn                   "Eval/progn.scm"))
   
   (use     (__type                    "Llib/type.scm")
	    (__evenv                   "Eval/evenv.scm"))

   (export  (expand-eval-lambda        <expression> <expander>)
	    (expand-eval-define        <expression> <expander>)
	    (expand-eval-define-inline <expression> <expander>)))

;*---------------------------------------------------------------------*/
;*    expand-eval-lambda ...                                           */
;*---------------------------------------------------------------------*/
(define (expand-eval-lambda x e)
   (let ((old-internal internal-definition?))
      (set! internal-definition? #t)
      (let ((res (match-case x
		    ((?- ?args . (and ?body (not ())))
		     (let ((e (internal-begin-expander e)))
			`(lambda ,args
			    ,(e (normalize-progn body) e))))
		    (else
		     (error "lambda" "Illegal form" x)))))
	 (set! internal-definition? old-internal)
	 (replace! x res))))

;*---------------------------------------------------------------------*/
;*    internal-definition? ...                                         */
;*---------------------------------------------------------------------*/
(define internal-definition? #f)

;*---------------------------------------------------------------------*/
;*    expand-eval-define ...                                           */
;*    -------------------------------------------------------------    */
;*    on divise en deux sous:                                          */
;*       1- on define une lambda.                                      */
;*       2- on define une valeur (autre qu'un lambda).                 */
;*---------------------------------------------------------------------*/
(define (expand-eval-define x e)
   (if internal-definition?
       (expand-eval-internal-define x e)
       (expand-eval-external-define x e)))

;*---------------------------------------------------------------------*/
;*    expand-eval-internal-define ...                                  */
;*---------------------------------------------------------------------*/
(define (expand-eval-internal-define x e)
      (match-case x
      ;; 1- on definit une lambda typee
      ((?- ((?type ?name) . ?args) . (and ?body (not ())))
       (let ((res `(define (,type ,name)
		      (lambda ,args ,(e (normalize-progn body) e)))))
	  (replace! x res)))
      ;; 1- on definit une lambda non typee
      ((or (?- (?name . ?args) . (and ?body (not ())))
	   (?- ?name (lambda ?args . (and ?body (not ())))))
       (let ((res `(define ,name
		      (lambda ,args ,(e (normalize-progn body) e)))))
	  (replace! x res)))
      ;; 2- on definit une valeur non typee
      ((?- ?name . (?value . ()))
       (let ((res `(define ,name ,(e value e))))
	  (replace! x res)))
      ;; 2b- on definit une valeur typee
      (else
       (error "define" "Illegal form" x))))

;*---------------------------------------------------------------------*/
;*    internal-begin-expander ...                                      */
;*---------------------------------------------------------------------*/
(define (internal-begin-expander old-expander)
   (lambda (expr expander)
      (let ((res (match-case expr
		    ((begin)
		     (error 'begin "Illegal form" expr))
		    ((begin . ?rest)
		     `(begin ,@(lambda-defines
				(map (lambda (x) (expander x expander))
				     rest))))
		    (else
		     (old-expander expr expander)))))
      (replace! expr res))))
				 
;*---------------------------------------------------------------------*/
;*    lambda-defines ...                                               */
;*---------------------------------------------------------------------*/
(define (lambda-defines body)
    (let loop ((oldforms  body)
	       (newforms '())
	       (vars     '())
	       (sets     '()))
       (if (pair? oldforms)
	   (let ((form (car oldforms)))
	      (cond ((or (not (pair? form))
			 (not (eq? (car form) 'define)))
		     (loop (cdr oldforms)
			   (cons form newforms)
			   vars sets))
		    (else
		     (loop (cdr oldforms) newforms
			   (cons (cadr form) vars)
			   (cons `(set! ,(cadr form) ,(caddr form))
				 sets)))))
	   (if (not (null? vars))
	       `(((lambda ,vars (begin ,@(reverse sets) ,@(reverse newforms)))
		  ,@(vector->list (make-vector (length vars) 0))))
	       body))))

;*---------------------------------------------------------------------*/
;*    expand-eval-external-define ...                                  */
;*---------------------------------------------------------------------*/
(define (expand-eval-external-define x e)
   (set! internal-definition? #t)
   (let ((e (internal-begin-expander e)))
      (let ((res  (if (and (pair? x) (pair? (cdr x)) (pair? (cddr x)))
		      (let ((type (cadr x)))
			 (if (pair? type)
			     `(define ,(car type)
				 (lambda ,(cdr type)
				    ,(e (normalize-progn (cddr x)) e)))
			     `(define ,type
				 ,(e (normalize-progn (cddr x)) e))))
		      (error "define" "Illegal form" x))))
	 (set! internal-definition? #f)
	 (replace! x res))))

;*---------------------------------------------------------------------*/
;*    expand-eval-define-inline ...                                    */
;*---------------------------------------------------------------------*/
(define (expand-eval-define-inline x e)
   (match-case x
      ((?- (?fun . ?formals) . (and ?body (not ())))
       (let ((res `(define ,fun
		      (lambda ,formals ,(e (normalize-progn body) e)))))
	  (replace! x res)))
      (else
       (error "define-inline" "Illegal form" x))))

