;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/runtime1.8/Eval/expd-do.scm          */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Mon Sep 28 16:06:31 1992                          */
;*    Last change :  Mon Jul 10 14:53:06 1995 (serrano)                */
;*                                                                     */
;*    La macro `DO'                                                    */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module __expander_do
   
   (import  (__error                   "Llib/error.scm")
	    (__bigloo                  "Llib/bigloo.scm")
	    (__tvector                 "Llib/tvector.scm")
	    (__structure               "Llib/struct.scm")
	    (__tvector                 "Llib/tvector.scm")
	    (__bexit                   "Llib/bexit.scm")
	    (__unix                    "Llib/unix.scm")
	    
	    (__reader                  "Read/reader.scm")
	    
	    (__rgc                     "Rgc/runtime.scm")
	    
	    (__r4_numbers_6_5          "Ieee/number.scm")
	    (__r4_numbers_6_5_fixnum   "Ieee/fixnum.scm")
	    (__r4_numbers_6_5_flonum   "Ieee/flonum.scm")
	    (__r4_characters_6_6       "Ieee/char.scm")
	    (__r4_equivalence_6_2      "Ieee/equiv.scm")
	    (__r4_booleans_6_1         "Ieee/boolean.scm")
	    (__r4_symbols_6_4          "Ieee/symbol.scm")
	    (__r4_strings_6_7          "Ieee/string.scm")
	    (__r4_pairs_and_lists_6_3  "Ieee/pair-list.scm")
	    (__r4_input_6_10_2         "Ieee/input.scm")
	    (__r4_control_features_6_9 "Ieee/control.scm")
	    (__r4_vectors_6_8          "Ieee/vector.scm")
	    (__r4_ports_6_10_1         "Ieee/port.scm")
	    (__r4_output_6_10_3        "Ieee/output.scm"))
   
   (use     (__type                    "Llib/type.scm")
	    (__evenv                   "Eval/evenv.scm"))
   
   (export  (expand-do <expression> <expander>)))

;*---------------------------------------------------------------------*/
;*    gen-doloop-name ...                                              */
;*---------------------------------------------------------------------*/
(define (gen-doloop-name)
   (gensym "do-loop--"))

;*---------------------------------------------------------------------*/
;*    expand-do ...                                                    */
;*---------------------------------------------------------------------*/
(define (expand-do exp e)
   (match-case exp
      ((?- ?bindings ?end . ?command)
       (let* ((let-bindings  bindings)
	      (vars 	   '())
	      (inits 	   '())
	      (steps 	   '())
 	      (loop	    (gen-doloop-name))
	      (test	    (if (pair? end)
		 		(car end)
				(error "do" "Illegal form" exp)))
	      (ending       (if (null? (cdr end))
				(list #f)
				(cdr end)))
	      (body         command))
	  (for-each
	   (lambda (var-init-step)
	      (if (and (>=fx (length var-init-step) 2)
		       (<=fx (length var-init-step) 3))
		  (let* ((var (car var-init-step))
			 (init (cadr var-init-step))
			 (step (if (not (null? (cddr var-init-step)))
				   (car (cddr var-init-step))
				   var)))
		     (set! vars  (cons var vars))
		     (set! steps (cons step steps))
		     (set! inits (cons init inits)))
		  (error 'do "Illegal form:" var-init-step)))
	   (reverse let-bindings))
	  (e `(letrec ((,loop (lambda ,vars
				 (if ,test
				     (begin ,@ending)
				     (begin ,@body
					    (,loop ,@steps))))))
		 (,loop ,@inits))
	     e)))
      (else
       (error 'do "Illegal form" 'exp))))

